/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.impl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.crypto.api.CertificateInfo;
import org.wso2.carbon.crypto.api.CryptoContext;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.CryptoService;
import org.wso2.carbon.crypto.api.ExternalCryptoProvider;
import org.wso2.carbon.crypto.api.HybridEncryptionInput;
import org.wso2.carbon.crypto.api.HybridEncryptionOutput;
import org.wso2.carbon.crypto.api.InternalCryptoProvider;
import org.wso2.carbon.crypto.api.KeyResolver;
import org.wso2.carbon.crypto.api.PrivateKeyInfo;
import org.wso2.carbon.crypto.api.PrivateKeyRetriever;

public class DefaultCryptoService
implements CryptoService,
PrivateKeyRetriever {
    private static final Log log = LogFactory.getLog(DefaultCryptoService.class);
    private Map<String, InternalCryptoProvider> internalCryptoProviders;
    private Map<String, ExternalCryptoProvider> externalCryptoProviders;
    private List<KeyResolver> keyResolvers;
    private String internalCryptoProviderClassName;
    private String externalCryptoProviderClassName;

    public DefaultCryptoService() {
        this.init();
    }

    private void init() {
        this.externalCryptoProviders = new HashMap<String, ExternalCryptoProvider>();
        this.internalCryptoProviders = new HashMap<String, InternalCryptoProvider>();
        this.keyResolvers = new ArrayList<KeyResolver>();
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider) throws CryptoException {
        this.failIfInternalCryptoInputsAreNotValid(cleartext, algorithm, "'Internal Encryption'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Encrypting data using the algorithm '%s' and the Java Security API provider '%s'.", algorithm, javaSecurityAPIProvider));
        }
        if (this.areInternalCryptoProvidersAvailable()) {
            InternalCryptoProvider mostSuitableInternalProvider = this.getMostSuitableInternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Internal providers are available. The most suitable provider is '%s'", mostSuitableInternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableInternalProvider.encrypt(cleartext, algorithm, javaSecurityAPIProvider);
        }
        String errorMessage = String.format("No internal crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", InternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] decrypt(byte[] ciphertext, String algorithm, String javaSecurityAPIProvider) throws CryptoException {
        this.failIfInternalCryptoInputsAreNotValid(ciphertext, algorithm, "'Internal Encryption'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Decrypting data using the algorithm '%s' and the Java Security API provider '%s'.", algorithm, javaSecurityAPIProvider));
        }
        if (this.areInternalCryptoProvidersAvailable()) {
            InternalCryptoProvider mostSuitableInternalProvider = this.getMostSuitableInternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Internal providers are available. The most suitable provider is '%s'", mostSuitableInternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableInternalProvider.decrypt(ciphertext, algorithm, javaSecurityAPIProvider);
        }
        String errorMessage = String.format("No internal crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", InternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] sign(byte[] data, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext) throws CryptoException {
        PrivateKeyInfo privateKeyInfo;
        this.failIfExternalCryptoInputIsInvalid(data, algorithm, cryptoContext, "'Signing'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Signing data using the algorithm '%s' and the Java Security API provider '%s'; %s", algorithm, javaSecurityAPIProvider, cryptoContext));
        }
        if ((privateKeyInfo = this.getPrivateKeyInfo(cryptoContext)) == null) {
            throw new CryptoException("Private key info could not be found for " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Private key info found. %s %s", privateKeyInfo, cryptoContext));
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.sign(data, algorithm, javaSecurityAPIProvider, cryptoContext, privateKeyInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] decrypt(byte[] ciphertext, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext) throws CryptoException {
        PrivateKeyInfo privateKeyInfo;
        this.failIfExternalCryptoInputIsInvalid(ciphertext, algorithm, cryptoContext, "'External Decrypt'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Decrypting data using the algorithm '%s' and the Java Security API provider '%s'; %s", algorithm, javaSecurityAPIProvider, cryptoContext));
        }
        if ((privateKeyInfo = this.getPrivateKeyInfo(cryptoContext)) == null) {
            throw new CryptoException("Private key info could not be found for : " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Private key info found. %s %s", privateKeyInfo, cryptoContext));
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.decrypt(ciphertext, algorithm, javaSecurityAPIProvider, cryptoContext, privateKeyInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext) throws CryptoException {
        CertificateInfo certificateInfo;
        this.failIfExternalCryptoInputIsInvalid(cleartext, algorithm, cryptoContext, "'External Encrypt'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Encrypting data using the algorithm '%s' and the Java Security API provider '%s'; %s", algorithm, javaSecurityAPIProvider, cryptoContext));
        }
        if ((certificateInfo = this.getCertificateInfo(cryptoContext)) == null) {
            throw new CryptoException("Certificate info could not be found for : " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Certificate info found. %s %s", certificateInfo, cryptoContext));
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.encrypt(cleartext, algorithm, javaSecurityAPIProvider, cryptoContext, certificateInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public boolean verifySignature(byte[] data, byte[] signature, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext) throws CryptoException {
        CertificateInfo certificateInfo;
        this.failIfSignatureVerificationInputIsInvalid(data, signature, algorithm, cryptoContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Verifying the signature using the algorithm '%s' and the Java Security API provider '%s'; %s", algorithm, javaSecurityAPIProvider, cryptoContext));
        }
        if ((certificateInfo = this.getCertificateInfo(cryptoContext)) == null) {
            throw new CryptoException("Certificate info could not be found for : " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Certificate info found. %s %s", certificateInfo, cryptoContext));
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.verifySignature(data, signature, algorithm, javaSecurityAPIProvider, cryptoContext, certificateInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public Certificate getCertificate(CryptoContext cryptoContext) throws CryptoException {
        CertificateInfo certificateInfo;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Retrieving the certificate using %s", cryptoContext));
        }
        if ((certificateInfo = this.getCertificateInfo(cryptoContext)) == null) {
            throw new CryptoException("Certificate info could not be found for : " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Certificate info found. %s %s", certificateInfo, cryptoContext));
        }
        if (certificateInfo.getCertificate() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Certificate is available in certificate info.");
            }
            return certificateInfo.getCertificate();
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Certificate is NOT available in certificate info. Delegating search to the providers.");
            }
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.getCertificate(cryptoContext, certificateInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public HybridEncryptionOutput hybridEncrypt(HybridEncryptionInput hybridEncryptionInput, String symmetricAlgorithm, String asymmetricAlgorithm, String javaSecurityProvider, CryptoContext cryptoContext) throws CryptoException {
        CertificateInfo certificateInfo;
        this.failIfHybridEncryptOperationInputsAreInvalid(hybridEncryptionInput.getPlainData(), symmetricAlgorithm, asymmetricAlgorithm, cryptoContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Encrypting data using the asymmetric algorithm '%s' and symmetric algorithm '%s' with Java Security API provider '%s'; %s", asymmetricAlgorithm, symmetricAlgorithm, javaSecurityProvider, cryptoContext));
        }
        if ((certificateInfo = this.getCertificateInfo(cryptoContext)) == null) {
            throw new CryptoException("Certificate info could not be found for : " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Certificate info found. %s %s", certificateInfo, cryptoContext));
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.hybridEncrypt(hybridEncryptionInput, symmetricAlgorithm, asymmetricAlgorithm, javaSecurityProvider, cryptoContext, certificateInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] hybridDecrypt(HybridEncryptionOutput hybridEncryptionOutput, String symmetricAlgorithm, String asymmetricAlgorithm, String javaSecurityProvider, CryptoContext cryptoContext) throws CryptoException {
        PrivateKeyInfo privateKeyInfo;
        this.failIfHybridDecryptOperationInputsAreInvalid(hybridEncryptionOutput, symmetricAlgorithm, asymmetricAlgorithm, cryptoContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Decrypting data using the asymmetric algorithm '%s' and symmetric algorithm '%s' the Java Security API provider '%s'; %s", asymmetricAlgorithm, symmetricAlgorithm, javaSecurityProvider, cryptoContext));
        }
        if ((privateKeyInfo = this.getPrivateKeyInfo(cryptoContext)) == null) {
            throw new CryptoException("Private key info could not be found for : " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Private key info found. %s %s", privateKeyInfo, cryptoContext));
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.hybridDecrypt(hybridEncryptionOutput, symmetricAlgorithm, asymmetricAlgorithm, javaSecurityProvider, cryptoContext, privateKeyInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public PrivateKey getPrivateKey(CryptoContext cryptoContext) throws CryptoException {
        PrivateKeyInfo privateKeyInfo = this.getPrivateKeyInfo(cryptoContext);
        if (privateKeyInfo == null) {
            throw new CryptoException("Private key info could not be found for : " + cryptoContext);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Private key info found. %s %s", privateKeyInfo, cryptoContext));
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            ExternalCryptoProvider mostSuitableExternalProvider = this.getMostSuitableExternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("External providers are available. The most suitable provider is '%s'", mostSuitableExternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableExternalProvider.getPrivateKey(cryptoContext, privateKeyInfo);
        }
        String errorMessage = String.format("No external crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", ExternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider, boolean returnSelfContainedCipherText) throws CryptoException {
        this.failIfInternalCryptoInputsAreNotValid(cleartext, algorithm, "'Internal Encryption'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Encrypting data using the algorithm '%s' and the Java Security API provider '%s'.", algorithm, javaSecurityAPIProvider));
        }
        if (this.areInternalCryptoProvidersAvailable()) {
            InternalCryptoProvider mostSuitableInternalProvider = this.getMostSuitableInternalProvider();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Internal providers are available. The most suitable provider is '%s'", mostSuitableInternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableInternalProvider.encrypt(cleartext, algorithm, javaSecurityAPIProvider, returnSelfContainedCipherText);
        }
        String errorMessage = String.format("No internal crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", InternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] encrypt(byte[] cleartext, String algorithm, String javaSecurityAPIProvider, boolean returnSelfContainedCipherText, String internalCryptoProviderType) throws CryptoException {
        this.failIfInternalCryptoInputsAreNotValid(cleartext, algorithm, internalCryptoProviderType, "'Internal Encryption'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Encrypting data using internal crypto provider '%s'", internalCryptoProviderType));
        }
        if (this.areInternalCryptoProvidersAvailable()) {
            InternalCryptoProvider mostSuitableInternalProvider = this.getMostSuitableInternalProvider(internalCryptoProviderType);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Internal providers are available. The most suitable provider is '%s'", mostSuitableInternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableInternalProvider.encrypt(cleartext, algorithm, javaSecurityAPIProvider, returnSelfContainedCipherText);
        }
        String errorMessage = String.format("No internal crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", InternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public byte[] decrypt(byte[] ciphertext, String algorithm, String javaSecurityAPIProvider, String internalCryptoProviderType) throws CryptoException {
        this.failIfInternalCryptoInputsAreNotValid(ciphertext, algorithm, internalCryptoProviderType, "'Internal Decryption'");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Decrypting data using internal crypto provider '%s'", internalCryptoProviderType));
        }
        if (this.areInternalCryptoProvidersAvailable()) {
            InternalCryptoProvider mostSuitableInternalProvider = this.getMostSuitableInternalProvider(internalCryptoProviderType);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Internal providers are available. The most suitable provider is '%s'", mostSuitableInternalProvider.getClass().getCanonicalName()));
            }
            return mostSuitableInternalProvider.decrypt(ciphertext, algorithm, javaSecurityAPIProvider);
        }
        String errorMessage = String.format("No internal crypto providers available. Correctly register a service implementation of '%s' as an OSGi service", InternalCryptoProvider.class);
        throw new CryptoException(errorMessage);
    }

    public void registerKeyResolver(KeyResolver keyResolver) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering key resolver : " + keyResolver));
        }
        this.keyResolvers.add(keyResolver);
        this.reorderKeyResolversByPriority();
    }

    public void unregisterKeyResolver(KeyResolver keyResolver) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering key resolver : " + keyResolver));
        }
        this.keyResolvers.remove(keyResolver);
    }

    public void registerInternalCryptoProvider(InternalCryptoProvider internalCryptoProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering internal crypto provider : " + internalCryptoProvider));
        }
        this.internalCryptoProviders.put(internalCryptoProvider.getClass().getName(), internalCryptoProvider);
    }

    public void unregisterAllInternalCryptoProviders() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unregistering all internal crypto providers.");
        }
        if (this.areInternalCryptoProvidersAvailable()) {
            this.internalCryptoProviders.clear();
        }
    }

    public void unregisterInternalCryptoProvider(InternalCryptoProvider internalCryptoProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering internal crypto provider : " + internalCryptoProvider));
        }
        this.internalCryptoProviders.remove(internalCryptoProvider.getClass().getCanonicalName());
    }

    public boolean areInternalCryptoProvidersAvailable() {
        return !this.internalCryptoProviders.isEmpty();
    }

    public InternalCryptoProvider getMostSuitableInternalProvider() throws CryptoException {
        InternalCryptoProvider mostSuitableProvider;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Looking for the most suitable internal crypto provider.");
        }
        if (this.isInternalCryptoProviderConfiguredInConfigFile()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configured internal crypto provider class name: " + this.internalCryptoProviderClassName));
            }
            if ((mostSuitableProvider = this.internalCryptoProviders.get(this.internalCryptoProviderClassName)) == null) {
                String errorMessage = String.format("The configured internal crypto provider class name: '%s' has not been registered as a service.", this.internalCryptoProviderClassName);
                throw new CryptoException(errorMessage);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Internal crypto provider class name is not configured.");
            }
            if (this.internalCryptoProviders.isEmpty()) {
                mostSuitableProvider = null;
            } else {
                if (this.internalCryptoProviders.size() > 1) {
                    String errorMessage = "There are more than one internal crypto providers available. But the preferred one is not configured in the config file. Please configure one.";
                    throw new CryptoException(errorMessage);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Only one internal crypto provider has been registered. Considering it as the most suitable one.");
                }
                mostSuitableProvider = (InternalCryptoProvider)((Map.Entry)this.internalCryptoProviders.entrySet().toArray()[0]).getValue();
            }
        }
        return mostSuitableProvider;
    }

    public void registerExternalCryptoProvider(ExternalCryptoProvider provider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering external crypto provider : " + provider));
        }
        this.externalCryptoProviders.put(provider.getClass().getName(), provider);
    }

    public void unregisterExternalCryptoProvider(ExternalCryptoProvider externalCryptoProvider) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering external crypto provider : " + externalCryptoProvider));
        }
        this.externalCryptoProviders.remove(externalCryptoProvider.getClass().getCanonicalName());
    }

    public void unregisterAllExternalCryptoProviders() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unregistering all external crypto providers.");
        }
        if (this.areExternalCryptoProvidersAvailable()) {
            this.externalCryptoProviders.clear();
        }
    }

    public boolean areExternalCryptoProvidersAvailable() {
        return !this.externalCryptoProviders.isEmpty();
    }

    public ExternalCryptoProvider getMostSuitableExternalProvider() throws CryptoException {
        ExternalCryptoProvider mostSuitableExternalProvider;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Looking for the most suitable external crypto provider.");
        }
        if (this.isExternalCryptoProviderConfiguredInConfigFile()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configured external crypto provider class name: " + this.externalCryptoProviderClassName));
            }
            if ((mostSuitableExternalProvider = this.externalCryptoProviders.get(this.externalCryptoProviderClassName)) == null) {
                String errorMessage = String.format("The configured external crypto provider class name: '%s' has not been registered as a service.", this.externalCryptoProviderClassName);
                throw new CryptoException(errorMessage);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"External crypto provider class name is not configured.");
            }
            if (this.externalCryptoProviders.isEmpty()) {
                mostSuitableExternalProvider = null;
            } else {
                if (this.externalCryptoProviders.size() > 1) {
                    String errorMessage = "There are more than one external crypto providers available. But the preferred one is not configured in the config file. Please configure one.";
                    throw new CryptoException(errorMessage);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Only one external crypto provider has been registered. Considering it as the most suitable one.");
                }
                mostSuitableExternalProvider = (ExternalCryptoProvider)((Map.Entry)this.externalCryptoProviders.entrySet().toArray()[0]).getValue();
            }
        }
        return mostSuitableExternalProvider;
    }

    public void setInternalCryptoProviderClassName(String internalCryptoProviderClassName) {
        this.internalCryptoProviderClassName = internalCryptoProviderClassName;
    }

    public void setExternalCryptoProviderClassName(String externalCryptoProviderClassName) {
        this.externalCryptoProviderClassName = externalCryptoProviderClassName;
    }

    public void overrideKeyResolverPriority(String keyResolverClassName, int keyResolverPriority) {
        for (KeyResolver keyResolver : this.keyResolvers) {
            if (!keyResolver.getClass().getCanonicalName().equals(keyResolverClassName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Setting %d as the priority of the key resolver '%s'", keyResolverPriority, keyResolverClassName));
            }
            keyResolver.setPriority(keyResolverPriority);
            this.reorderKeyResolversByPriority();
            break;
        }
    }

    private void reorderKeyResolversByPriority() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Re-ordering key resolvers by priority.");
        }
        Collections.sort(this.keyResolvers, new Comparator<KeyResolver>(){

            @Override
            public int compare(KeyResolver k1, KeyResolver k2) {
                if (k1.getPriority() == k2.getPriority()) {
                    return 0;
                }
                if (k1.getPriority() < k2.getPriority()) {
                    return -1;
                }
                return 1;
            }
        });
    }

    private PrivateKeyInfo getPrivateKeyInfo(CryptoContext cryptoContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finding private key info for " + cryptoContext));
        }
        for (KeyResolver privateKeyResolver : this.keyResolvers) {
            PrivateKeyInfo privateKeyInfo;
            if (!privateKeyResolver.isApplicable(cryptoContext)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%s is applicable for %s", privateKeyResolver, cryptoContext));
            }
            if ((privateKeyInfo = privateKeyResolver.getPrivateKeyInfo(cryptoContext)) != null) {
                return privateKeyInfo;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Private key info was not returned by %s. Continuing with remaining resolvers.", privateKeyResolver));
        }
        return null;
    }

    private CertificateInfo getCertificateInfo(CryptoContext cryptoContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finding certificate info for " + cryptoContext));
        }
        for (KeyResolver privateKeyResolver : this.keyResolvers) {
            CertificateInfo certificateInfo;
            if (!privateKeyResolver.isApplicable(cryptoContext)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%s is applicable for %s", privateKeyResolver, cryptoContext));
            }
            if ((certificateInfo = privateKeyResolver.getCertificateInfo(cryptoContext)) != null) {
                return certificateInfo;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Certificate info was not returned by %s. Continuing with remaining resolvers.", privateKeyResolver));
        }
        return null;
    }

    private boolean isInternalCryptoProviderConfiguredInConfigFile() {
        return StringUtils.isNotBlank((String)this.internalCryptoProviderClassName);
    }

    private boolean isExternalCryptoProviderConfiguredInConfigFile() {
        return StringUtils.isNotBlank((String)this.externalCryptoProviderClassName);
    }

    private void failIfInternalCryptoInputsAreNotValid(byte[] data, String algorithm, String operation) throws CryptoException {
        if (data == null) {
            throw new CryptoException(String.format("Content provided for the %s operation can't be null", operation));
        }
        if (StringUtils.isBlank((String)algorithm)) {
            throw new CryptoException("Algorithm can't be empty");
        }
    }

    private void failIfExternalCryptoInputIsInvalid(byte[] data, String algorithm, CryptoContext cryptoContext, String operation) throws CryptoException {
        if (data == null) {
            throw new CryptoException(String.format("Content provided for the %s operation can't be null", operation));
        }
        if (StringUtils.isBlank((String)algorithm)) {
            throw new CryptoException("Algorithm can't be empty");
        }
        if (cryptoContext == null) {
            throw new CryptoException("Crypto context can't be null");
        }
    }

    private void failIfSignatureVerificationInputIsInvalid(byte[] data, byte[] signature, String algorithm, CryptoContext cryptoContext) throws CryptoException {
        String operation = "'Signature Validation'";
        if (signature == null) {
            throw new CryptoException(String.format("Signature provided for the %s operation can't be null", operation));
        }
        this.failIfExternalCryptoInputIsInvalid(data, algorithm, cryptoContext, operation);
    }

    private void failIfHybridEncryptOperationInputsAreInvalid(byte[] data, String symmetricAlgorithm, String asymmetricAlgorithm, CryptoContext cryptoContext) throws CryptoException {
        if (StringUtils.isBlank((String)symmetricAlgorithm)) {
            String errorMessage = String.format("'%s' symmetric algorithm can't be empty.", symmetricAlgorithm);
            throw new CryptoException(errorMessage);
        }
        this.failIfExternalCryptoInputIsInvalid(data, asymmetricAlgorithm, cryptoContext, "'External Encrypt'");
    }

    private void failIfHybridDecryptOperationInputsAreInvalid(HybridEncryptionOutput hybridEncryptionOutput, String symmetricAlgorithm, String asymmetricAlgorithm, CryptoContext cryptoContext) throws CryptoException {
        if (StringUtils.isBlank((String)symmetricAlgorithm)) {
            String errorMessage = String.format("'%s' symmetric algorithm can't be empty.", symmetricAlgorithm);
            throw new CryptoException(errorMessage);
        }
        if (hybridEncryptionOutput == null) {
            String errorMessage = String.format("Decryption data input can't be null.", new Object[0]);
            throw new CryptoException(errorMessage);
        }
        if (StringUtils.isBlank((String)asymmetricAlgorithm)) {
            String errorMessage = String.format("'%s' asymmetric algorithm can't be empty.", asymmetricAlgorithm);
            throw new CryptoException(errorMessage);
        }
        if (cryptoContext == null) {
            String errorMessage = "Crypto context can't be null.";
            throw new CryptoException(errorMessage);
        }
    }

    private void failIfInternalCryptoInputsAreNotValid(byte[] data, String algorithm, String internalCryptoProviderType, String operation) throws CryptoException {
        if (data == null) {
            throw new CryptoException(String.format("Content provided for the %s operation can't be null", operation));
        }
        if (StringUtils.isBlank((String)algorithm)) {
            throw new CryptoException("Algorithm can't be empty");
        }
        if (StringUtils.isBlank((String)internalCryptoProviderType)) {
            throw new CryptoException("Internal Crypto Provider type can't be empty");
        }
    }

    private InternalCryptoProvider getMostSuitableInternalProvider(String internalCryptoProviderType) throws CryptoException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Looking for the most suitable internal crypto provider.");
        }
        if (StringUtils.isNotBlank((String)internalCryptoProviderType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Preferred internal crypto provider received from registered providers is '%s'.", internalCryptoProviderType));
            }
            return this.internalCryptoProviders.get(internalCryptoProviderType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Preferred internal crypto provider is fetched from default provider configurations.", internalCryptoProviderType));
        }
        return this.getMostSuitableInternalProvider();
    }
}

