/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.services;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.extensions.services.RXTStoragePathService;

public class RXTStoragePathServiceImpl
extends AbstractAdmin
implements RXTStoragePathService {
    private static Map<Integer, Map<String, String>> tenantMap = new HashMap<Integer, Map<String, String>>();

    @Override
    public String getStoragePath(String mediaType) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantMap.get(tenantId) != null) {
            return tenantMap.get(tenantId).get(mediaType);
        }
        return null;
    }

    @Override
    public void removeStoragePath(String mediaType) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantMap.get(tenantId) != null && tenantMap.get(tenantId).get(mediaType) != null) {
            tenantMap.get(tenantId).remove(mediaType);
        }
    }

    @Override
    public void addStoragePath(String mediaType, String storagePath) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        storagePath = this.getCompletePath(storagePath);
        if (tenantMap.get(tenantId) != null) {
            Map<String, String> pathMap = tenantMap.get(tenantId);
            pathMap.put(mediaType, storagePath);
            tenantMap.put(tenantId, pathMap);
        } else {
            HashMap<String, String> pathMap = new HashMap<String, String>();
            pathMap.put(mediaType, storagePath);
            tenantMap.put(tenantId, pathMap);
        }
    }

    private String getCompletePath(String storagePath) {
        String path = "/_system/governance";
        if (!storagePath.startsWith(path)) {
            storagePath = path + storagePath;
        }
        return storagePath;
    }
}

