/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;

public class SchemaValidator {
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";

    public static WSDLValidationInfo validate(XMLInputSource xmlInputSource) throws Exception {
        XMLGrammarPreparser preparser = new XMLGrammarPreparser();
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        preparser.setFeature(NAMESPACES_FEATURE_ID, true);
        preparser.setFeature(VALIDATION_FEATURE_ID, true);
        preparser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        WSDLValidationInfo validationInfo = new WSDLValidationInfo();
        preparser.setErrorHandler((XMLErrorHandler)new ErrorHandler(validationInfo));
        preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", xmlInputSource);
        return validationInfo;
    }

    private static class ErrorHandler
    implements XMLErrorHandler {
        WSDLValidationInfo validationInfo;

        private ErrorHandler(WSDLValidationInfo validationInfo) {
            this.validationInfo = validationInfo;
        }

        public void error(String domain, String key, XMLParseException exception) throws XNIException {
            this.validationInfo.addValidationMessage("Error: " + exception.getMessage());
        }

        public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
            this.validationInfo.addValidationMessage("Fatal Error: " + exception.getMessage());
        }

        public void warning(String domain, String key, XMLParseException exception) throws XNIException {
            this.validationInfo.addValidationMessage("Warning: " + exception.getMessage());
        }
    }
}

