/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.xml.sax.InputSource;

public class SchemaFileProcessor {
    private Registry registry;
    private ArrayList schemaPath;
    private List<Association> associationsBuffer = new ArrayList<Association>();
    private int i;

    public SchemaFileProcessor(Registry registry) {
        this.registry = registry;
        this.schemaPath = new ArrayList();
    }

    public String saveSchemaFileToRegistry(String location, String registryBasePath, boolean processIncludes, Resource metadata) throws RegistryException {
        return this.saveSchemaFileToRegistry(location, new HashMap(), registryBasePath, processIncludes, metadata);
    }

    public String saveSchemaFileToRegistry(String location, Map processedSchemaMap, String registryBasePath, boolean processIncludes, Resource metadata) throws RegistryException {
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        InputSource inputSource = new InputSource(location);
        XmlSchema xmlSchema = xmlSchemaCollection.read(inputSource, null);
        String baseUri = xmlSchema.getSourceURI();
        String xsdFileName = baseUri.substring(baseUri.lastIndexOf("/") + 1);
        String savedName = xsdFileName.substring(0, xsdFileName.indexOf(".")) + ".xsd";
        this.calculateNewSchemaNames(xmlSchema, processedSchemaMap, new HashSet(), false, processIncludes);
        this.saveSchemaFileToRegistry(xmlSchema, processedSchemaMap, null, new HashSet(), false, registryBasePath, processIncludes, metadata);
        return savedName;
    }

    public void calculateNewSchemaNames(XmlSchema xmlSchema, Map processedSchemaMap, Set visitedSchemas, boolean isWSDLInlineSchema, boolean processIncludes) {
        if (processIncludes) {
            XmlSchemaObjectCollection includes = xmlSchema.getIncludes();
            visitedSchemas.add(xmlSchema.getSourceURI());
            if (includes != null) {
                Iterator iter = includes.getIterator();
                while (iter.hasNext()) {
                    XmlSchemaExternal xmlSchemaExternal;
                    XmlSchema innerSchema;
                    String sourceURI;
                    Object externalComponent = iter.next();
                    if (!(externalComponent instanceof XmlSchemaExternal) || processedSchemaMap.containsKey(sourceURI = (innerSchema = (xmlSchemaExternal = (XmlSchemaExternal)externalComponent).getSchema()).getSourceURI()) || visitedSchemas.contains(sourceURI)) continue;
                    this.calculateNewSchemaNames(innerSchema, processedSchemaMap, visitedSchemas, false, processIncludes);
                }
            }
        }
        if (!isWSDLInlineSchema) {
            String baseUri = xmlSchema.getSourceURI();
            String xsdFileName = baseUri.substring(baseUri.lastIndexOf("/") + 1);
            String fileNameToSave = xsdFileName.substring(0, xsdFileName.indexOf(".")) + ".xsd";
            while (processedSchemaMap.containsValue(fileNameToSave)) {
                fileNameToSave = xsdFileName.substring(0, xsdFileName.indexOf(".")) + ++this.i + ".xsd";
            }
            processedSchemaMap.put(baseUri, fileNameToSave);
        }
    }

    public void saveSchemaFileToRegistry(XmlSchema xmlSchema, Map processedSchemaMap, Map changeSchemaNames, Set visitedSchemas, boolean isWSDLInlineSchema, String registryBasePath, boolean processIncludes, Resource metadata) throws RegistryException {
        ArrayList<String> associations = new ArrayList<String>();
        if (processIncludes) {
            XmlSchemaObjectCollection includes = xmlSchema.getIncludes();
            visitedSchemas.add(xmlSchema.getSourceURI());
            if (includes != null) {
                Iterator iter = includes.getIterator();
                while (iter.hasNext()) {
                    Object externalComponent = iter.next();
                    if (!(externalComponent instanceof XmlSchemaExternal)) continue;
                    XmlSchemaExternal xmlSchemaExternal = (XmlSchemaExternal)externalComponent;
                    String sourceURI = xmlSchemaExternal.getSchema().getSourceURI();
                    if (!visitedSchemas.contains(sourceURI)) {
                        this.saveSchemaFileToRegistry(xmlSchemaExternal.getSchema(), processedSchemaMap, null, visitedSchemas, false, registryBasePath, processIncludes, null);
                    }
                    String newLocation = (String)processedSchemaMap.get(sourceURI);
                    if (isWSDLInlineSchema) {
                        changeSchemaNames.put(xmlSchemaExternal.getSchemaLocation(), newLocation);
                    }
                    xmlSchemaExternal.setSchemaLocation(newLocation);
                    String innerFileNameToSave = (String)processedSchemaMap.get(sourceURI);
                    String innerXSDPath = this.getXSDPath(registryBasePath, innerFileNameToSave);
                    associations.add(innerXSDPath);
                }
            }
        }
        if (!isWSDLInlineSchema) {
            String fileNameToSave = (String)processedSchemaMap.get(xmlSchema.getSourceURI());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xmlSchema.write((OutputStream)byteArrayOutputStream);
            byte[] xsdContent = byteArrayOutputStream.toByteArray();
            ResourceImpl xsdResource = new ResourceImpl();
            if (metadata != null) {
                xsdResource.setMediaType(metadata.getMediaType());
                xsdResource.setDescription(metadata.getDescription());
            }
            xsdResource.setContent((Object)xsdContent);
            String xsdPath = this.getXSDPath(registryBasePath, fileNameToSave);
            String targetNamespace = xmlSchema.getTargetNamespace();
            xsdResource.addProperty("targetNamespace", targetNamespace);
            this.registry.put(xsdPath, (Resource)xsdResource);
            this.schemaPath.add(xsdPath);
            for (Object e : associations) {
                String associationPath = (String)e;
                this.associationsBuffer.add(new Association(xsdPath, associationPath, "depends"));
            }
        }
    }

    private String getXSDPath(String registryBasePath, String fileNameToSave) {
        String xsdPath = "/".equals(registryBasePath) ? "/" + fileNameToSave : registryBasePath + "/" + fileNameToSave;
        return xsdPath;
    }

    public void persistAssociations() throws RegistryException {
        for (Association association : this.associationsBuffer) {
            this.registry.addAssociation(association.getSourcePath(), association.getDestinationPath(), association.getAssociationType());
        }
    }

    public ArrayList getSchemaPath() {
        return this.schemaPath;
    }
}

