/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.services.Utils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class RESTServiceUtils {
    private static final Log log = LogFactory.getLog(RESTServiceUtils.class);
    private static final String OVERVIEW = "overview";
    private static final String NAME = "name";
    private static final String CONTEXT = "context";
    private static final String VERSION = "version";
    private static final String TRANSPORTS = "transports";
    private static final String DESCRIPTION = "description";
    private static final String URI_TEMPLATE = "uritemplate";
    private static final String URL_PATTERN = "urlPattern";
    private static final String AUTH_TYPE = "authType";
    private static final String HTTP_VERB = "httpVerb";
    private static final String ENDPOINT_URL = "endpointURL";
    private static final String WADL = "wadl";
    private static final String PATH_SEPERATOR = "/";
    private static final String METHOD = "method";
    private static final String PATH = "path";
    private static final String RESOURCE = "resource";
    private static final String INTERFACE = "interface";
    private static final String SWAGGER = "swagger";
    private static final String INTERFACE_ELEMENT_LOCAL_NAME = "interface";
    private static OMFactory factory = OMAbstractFactory.getOMFactory();
    private static OMNamespace namespace = factory.createOMNamespace("http://www.wso2.org/governance/metadata", "");
    private static String commonRestServiceLocation;
    private static String commonEndpointLocation;

    public static OMElement createRestServiceArtifact(JsonObject swaggerDocObject, String swaggerVersion, String endpointURL, List<JsonObject> resourceObjects, String swaggerPath) throws RegistryException {
        if (swaggerDocObject == null || swaggerVersion == null) {
            throw new IllegalArgumentException("Arguments are invalid. cannot create the REST service artifact. ");
        }
        OMElement data = factory.createOMElement("metadata", namespace);
        OMElement overview = factory.createOMElement(OVERVIEW, namespace);
        OMElement name = factory.createOMElement(NAME, namespace);
        OMElement context = factory.createOMElement(CONTEXT, namespace);
        OMElement apiVersion = factory.createOMElement(VERSION, namespace);
        OMElement endpoint = factory.createOMElement(ENDPOINT_URL, namespace);
        OMElement transports = factory.createOMElement(TRANSPORTS, namespace);
        OMElement description = factory.createOMElement(DESCRIPTION, namespace);
        List<OMElement> uriTemplates = null;
        JsonObject infoObject = swaggerDocObject.get("info").getAsJsonObject();
        String apiName = RESTServiceUtils.getChildElementText(infoObject, "title").replaceAll("\\s", "");
        name.setText(apiName);
        context.setText(PATH_SEPERATOR + apiName);
        description.setText(RESTServiceUtils.getChildElementText(infoObject, DESCRIPTION));
        endpoint.setText(endpointURL);
        if ("2.0".equals(swaggerVersion)) {
            apiVersion.setText(RESTServiceUtils.getChildElementText(infoObject, VERSION));
            transports.setText(RESTServiceUtils.getChildElementText(swaggerDocObject, "schemes"));
            uriTemplates = RESTServiceUtils.createURITemplateFromSwagger2(swaggerDocObject);
        } else if ("1.2".equals(swaggerVersion)) {
            apiVersion.setText(RESTServiceUtils.getChildElementText(swaggerDocObject, "apiVersion"));
            uriTemplates = RESTServiceUtils.createURITemplateFromSwagger12(resourceObjects);
        }
        overview.addChild((OMNode)name);
        overview.addChild((OMNode)context);
        overview.addChild((OMNode)apiVersion);
        overview.addChild((OMNode)description);
        overview.addChild((OMNode)endpoint);
        data.addChild((OMNode)overview);
        OMElement interfaceElement = factory.createOMElement("interface", namespace);
        OMElement swagger = factory.createOMElement(SWAGGER, namespace);
        swagger.setText(swaggerPath);
        interfaceElement.addChild((OMNode)swagger);
        interfaceElement.addChild((OMNode)transports);
        data.addChild((OMNode)interfaceElement);
        if (uriTemplates != null) {
            for (OMElement uriTemplate : uriTemplates) {
                data.addChild((OMNode)uriTemplate);
            }
        }
        return data;
    }

    public static OMElement createRestServiceArtifact(JsonObject swaggerDocObject, String swaggerVersion, String endpointURL, List<JsonObject> resourceObjects, String swaggerPath, String documentVersion) throws RegistryException {
        if (swaggerDocObject == null || swaggerVersion == null) {
            throw new IllegalArgumentException("Arguments are invalid. cannot create the REST service artifact. ");
        }
        OMElement data = factory.createOMElement("metadata", namespace);
        OMElement overview = factory.createOMElement(OVERVIEW, namespace);
        OMElement name = factory.createOMElement(NAME, namespace);
        OMElement context = factory.createOMElement(CONTEXT, namespace);
        OMElement apiVersion = factory.createOMElement(VERSION, namespace);
        OMElement endpoint = factory.createOMElement(ENDPOINT_URL, namespace);
        OMElement transports = factory.createOMElement(TRANSPORTS, namespace);
        OMElement description = factory.createOMElement(DESCRIPTION, namespace);
        List<OMElement> uriTemplates = null;
        JsonObject infoObject = swaggerDocObject.get("info").getAsJsonObject();
        String apiName = RESTServiceUtils.getChildElementText(infoObject, "title").replaceAll("\\s", "");
        name.setText(apiName);
        context.setText(PATH_SEPERATOR + apiName);
        description.setText(RESTServiceUtils.getChildElementText(infoObject, DESCRIPTION));
        endpoint.setText(endpointURL);
        if ("2.0".equals(swaggerVersion)) {
            apiVersion.setText(documentVersion);
            transports.setText(RESTServiceUtils.getChildElementText(swaggerDocObject, "schemes"));
            uriTemplates = RESTServiceUtils.createURITemplateFromSwagger2(swaggerDocObject);
        } else if ("1.2".equals(swaggerVersion)) {
            apiVersion.setText(documentVersion);
            uriTemplates = RESTServiceUtils.createURITemplateFromSwagger12(resourceObjects);
        }
        overview.addChild((OMNode)name);
        overview.addChild((OMNode)context);
        overview.addChild((OMNode)apiVersion);
        overview.addChild((OMNode)description);
        overview.addChild((OMNode)endpoint);
        data.addChild((OMNode)overview);
        OMElement interfaceElement = factory.createOMElement("interface", namespace);
        OMElement swagger = factory.createOMElement(SWAGGER, namespace);
        swagger.setText(swaggerPath);
        interfaceElement.addChild((OMNode)swagger);
        interfaceElement.addChild((OMNode)transports);
        data.addChild((OMNode)interfaceElement);
        if (uriTemplates != null) {
            for (OMElement uriTemplate : uriTemplates) {
                data.addChild((OMNode)uriTemplate);
            }
        }
        return data;
    }

    public static OMElement createRestServiceArtifact(OMElement wadlElement, String wadlName, String version, String wadlPath) {
        if (wadlElement == null) {
            throw new IllegalArgumentException("WADL content cannot be null.");
        }
        OMElement data = factory.createOMElement("metadata", namespace);
        OMElement overview = factory.createOMElement(OVERVIEW, namespace);
        OMElement name = factory.createOMElement(NAME, namespace);
        OMElement context = factory.createOMElement(CONTEXT, namespace);
        OMElement apiVersion = factory.createOMElement(VERSION, namespace);
        OMElement endpoint = factory.createOMElement(ENDPOINT_URL, namespace);
        OMElement transports = factory.createOMElement(TRANSPORTS, namespace);
        List<OMElement> uriTemplates = null;
        String serviceName = wadlName.contains(".") ? wadlName.substring(0, wadlName.lastIndexOf(".")) : wadlName;
        name.setText(serviceName);
        context.setText(PATH_SEPERATOR + serviceName);
        apiVersion.setText(version);
        OMNamespace wadlNamespace = wadlElement.getNamespace();
        String wadlNamespaceURI = wadlNamespace.getNamespaceURI();
        String wadlNamespacePrefix = wadlNamespace.getPrefix();
        OMElement resourcesElement = wadlElement.getFirstChildWithName(new QName(wadlNamespaceURI, "resources", wadlNamespacePrefix));
        if (resourcesElement != null) {
            String endpointUrl = resourcesElement.getAttributeValue(new QName("base"));
            endpoint.setText(endpointUrl);
            if (endpointUrl != null && endpointUrl.contains("://")) {
                transports.setText(endpointUrl.substring(0, endpointUrl.indexOf("://")));
            }
            uriTemplates = RESTServiceUtils.createURITemplateFromWADL(resourcesElement);
        } else {
            log.warn((Object)"WADL does not contains any resource paths. ");
        }
        overview.addChild((OMNode)name);
        overview.addChild((OMNode)context);
        overview.addChild((OMNode)apiVersion);
        overview.addChild((OMNode)endpoint);
        data.addChild((OMNode)overview);
        OMElement interfaceElement = factory.createOMElement("interface", namespace);
        OMElement wadl = factory.createOMElement(WADL, namespace);
        wadl.setText(wadlPath);
        interfaceElement.addChild((OMNode)wadl);
        interfaceElement.addChild((OMNode)transports);
        data.addChild((OMNode)interfaceElement);
        if (uriTemplates != null) {
            for (OMElement uriTemplate : uriTemplates) {
                data.addChild((OMNode)uriTemplate);
            }
        }
        return data;
    }

    public static String addServiceToRegistry(RequestContext requestContext, OMElement serviceInfoElement) throws RegistryException {
        if (requestContext == null || serviceInfoElement == null) {
            throw new IllegalArgumentException("Some or all of the arguments may be null. Cannot add the rest service to registry. ");
        }
        Registry registry = requestContext.getRegistry();
        Resource serviceResource = requestContext.getResource();
        if (serviceResource == null) {
            serviceResource = new ResourceImpl();
        }
        serviceResource.setMediaType("application/vnd.wso2-restservice+xml");
        OMElement overview = serviceInfoElement.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", OVERVIEW));
        String serviceVersion = overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", VERSION)).getText();
        String apiName = overview.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", NAME)).getText();
        serviceVersion = serviceVersion == null ? "1.0.0" : serviceVersion;
        String serviceProvider = CarbonContext.getThreadLocalCarbonContext().getUsername();
        String pathExpression = RESTServiceUtils.getRestServicePath(requestContext, serviceInfoElement, apiName, serviceProvider);
        if (registry.resourceExists(pathExpression)) {
            OMElement oldServiceContentElement;
            Resource oldResource = registry.get(pathExpression);
            Object resourceContent = oldResource.getContent();
            String oldServiceInfo = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(oldServiceInfo));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                oldServiceContentElement = builder.getDocumentElement();
            }
            catch (XMLStreamException e) {
                StringBuilder msg = new StringBuilder("Error in parsing the service content of the service. Path: ").append(requestContext.getResourcePath().getPath()).append(".");
                log.error((Object)msg.toString());
                throw new RegistryException(msg.toString(), (Throwable)e);
            }
            if (serviceInfoElement.equals(oldServiceContentElement)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Old service content is similar to the updated service content. Skipping further processing.");
                }
                requestContext.setProcessingComplete(true);
            }
            String oldSwaggerUrl = RESTServiceUtils.getDefinitionURL(oldServiceContentElement, SWAGGER);
            String oldWadlUrl = RESTServiceUtils.getDefinitionURL(oldServiceContentElement, WADL);
            String servicePath = CommonUtil.getRegistryPath(registry.getRegistryContext(), requestContext.getResourcePath().getPath());
            if (StringUtils.isNotBlank((String)oldSwaggerUrl) && !oldSwaggerUrl.equals(RESTServiceUtils.getDefinitionURL(serviceInfoElement, SWAGGER))) {
                registry.removeAssociation(servicePath, oldSwaggerUrl, "depends");
                registry.removeAssociation(oldSwaggerUrl, servicePath, "usedBy");
            }
            if (StringUtils.isNotBlank((String)oldWadlUrl) && !oldWadlUrl.equals(RESTServiceUtils.getDefinitionURL(serviceInfoElement, WADL))) {
                registry.removeAssociation(servicePath, oldWadlUrl, "depends");
                registry.removeAssociation(oldWadlUrl, servicePath, "usedBy");
            }
        }
        serviceResource.setProperty(VERSION, serviceVersion);
        serviceResource.setProperty("resource.source", "Auto");
        serviceResource.setContent((Object)RegistryUtils.encodeString((String)serviceInfoElement.toString()));
        String resourceId = serviceResource.getUUID();
        resourceId = resourceId == null ? UUID.randomUUID().toString() : resourceId;
        serviceResource.setUUID(resourceId);
        registry.put(pathExpression, serviceResource);
        EndpointUtils.saveEndpointsFromServices(requestContext, pathExpression, serviceInfoElement, registry, requestContext.getSystemRegistry());
        String defaultLifeCycle = CommonUtil.getDefaultLifecycle(registry, "restservice");
        CommonUtil.applyDefaultLifeCycle(registry, serviceResource, pathExpression, defaultLifeCycle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("REST Service created at " + pathExpression));
        }
        return pathExpression;
    }

    public static String getDefinitionURL(OMElement serviceInfoElement, String localName) {
        if (serviceInfoElement == null) {
            throw new IllegalArgumentException("serviceInfoElement is null. Cannot read content.");
        }
        OMElement interfaceElement = serviceInfoElement.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", "interface", ""));
        if (interfaceElement != null) {
            OMElement element = interfaceElement.getFirstChildWithName(new QName("http://www.wso2.org/governance/metadata", localName, ""));
            return element != null ? (!"null".equals(element.getText().trim()) ? element.getText().trim() : null) : null;
        }
        return null;
    }

    private static String getRestServicePath(RequestContext requestContext, OMElement data, String serviceName, String serviceProvider) {
        String pathExpression = Utils.getRxtService().getStoragePath("application/vnd.wso2-restservice+xml");
        pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, NAME, serviceName);
        pathExpression = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)CommonUtil.getPathFromPathExpression(pathExpression, data, requestContext.getResource().getProperties()));
        pathExpression = CommonUtil.getPathFromPathExpression(pathExpression, requestContext.getResource().getProperties(), null);
        String servicePath = pathExpression = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)CommonUtil.replaceExpressionOfPath(pathExpression, "provider", serviceProvider));
        if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
            servicePath = CommonUtil.getRegistryPath(requestContext.getRegistry().getRegistryContext(), pathExpression);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving current session local paths, key: " + servicePath + " | value: " + pathExpression));
            }
            CurrentSession.getLocalPathMap().put(servicePath, pathExpression);
        }
        return servicePath;
    }

    public static String addEndpointToRegistry(RequestContext requestContext, OMElement endpointElement, String endpointPath) throws RegistryException {
        if (requestContext == null || endpointElement == null || endpointPath == null) {
            throw new IllegalArgumentException("Some or all of the arguments may be null. Cannot add the endpoint to registry. ");
        }
        endpointPath = RESTServiceUtils.getEndpointPath(requestContext, endpointElement, endpointPath);
        Registry registry = requestContext.getRegistry();
        ResourceImpl endpointResource = new ResourceImpl();
        endpointResource.setMediaType("application/vnd.wso2-endpoint+xml");
        endpointResource.setContent((Object)RegistryUtils.encodeString((String)endpointElement.toString()));
        endpointResource.setProperties(RESTServiceUtils.copyProperties(requestContext));
        String resourceId = endpointResource.getUUID();
        resourceId = resourceId == null ? UUID.randomUUID().toString() : resourceId;
        endpointResource.setUUID(resourceId);
        registry.put(endpointPath, (Resource)endpointResource);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Endpoint created at " + endpointPath));
        }
        return endpointPath;
    }

    private static String getEndpointPath(RequestContext requestContext, OMElement endpointElement, String endpointPath) {
        String pathExpression = Utils.getRxtService().getStoragePath("application/vnd.wso2-endpoint+xml");
        pathExpression = CommonUtil.getPathFromPathExpression(pathExpression, endpointElement, requestContext.getResource().getProperties());
        String endpointRegistryPath = endpointPath = CommonUtil.replaceExpressionOfPath(pathExpression, NAME, endpointPath);
        if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
            endpointRegistryPath = CommonUtil.getRegistryPath(requestContext.getRegistry().getRegistryContext(), endpointPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving current session local paths, key: " + endpointRegistryPath + " | value: " + endpointPath));
            }
            CurrentSession.getLocalPathMap().put(endpointRegistryPath, endpointPath);
        }
        return endpointRegistryPath;
    }

    private static String getChildElementText(JsonObject object, String key) {
        JsonElement element = object.get(key);
        if (element != null && element.isJsonArray()) {
            if (((JsonArray)element).size() == 1) {
                return object.get(key).getAsString();
            }
            StringBuffer sb = new StringBuffer();
            JsonArray elements = (JsonArray)object.get(key);
            for (int i = 0; i < elements.size(); ++i) {
                JsonPrimitive ob = (JsonPrimitive)elements.get(i);
                sb.append(ob.getAsString());
                if (i >= elements.size() - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        if (element != null && (element.isJsonObject() || element.isJsonPrimitive())) {
            return object.get(key).getAsString();
        }
        return null;
    }

    private static List<OMElement> createURITemplateFromSwagger12(List<JsonObject> resourceObjects) {
        ArrayList<OMElement> uriTemplates = new ArrayList<OMElement>();
        for (JsonObject resourceObject : resourceObjects) {
            JsonArray pathResources = resourceObject.getAsJsonArray("apis");
            for (JsonElement pathResource : pathResources) {
                JsonObject path = pathResource.getAsJsonObject();
                String pathText = path.get(PATH).getAsString();
                JsonArray methods = path.getAsJsonArray("operations");
                for (JsonElement method : methods) {
                    JsonObject methodObj = method.getAsJsonObject();
                    OMElement uriTemplateElement = factory.createOMElement(URI_TEMPLATE, namespace);
                    OMElement urlPatternElement = factory.createOMElement(URL_PATTERN, namespace);
                    OMElement httpVerbElement = factory.createOMElement(HTTP_VERB, namespace);
                    OMElement authTypeElement = factory.createOMElement(AUTH_TYPE, namespace);
                    urlPatternElement.setText(pathText);
                    httpVerbElement.setText(methodObj.get(METHOD).getAsString());
                    uriTemplateElement.addChild((OMNode)urlPatternElement);
                    uriTemplateElement.addChild((OMNode)httpVerbElement);
                    uriTemplateElement.addChild((OMNode)authTypeElement);
                    uriTemplates.add(uriTemplateElement);
                }
            }
        }
        return uriTemplates;
    }

    private static List<OMElement> createURITemplateFromSwagger2(JsonObject swaggerDocObject) {
        ArrayList<OMElement> uriTemplates = new ArrayList<OMElement>();
        JsonObject paths = swaggerDocObject.get("paths").getAsJsonObject();
        Set pathSet = paths.entrySet();
        for (Map.Entry path : pathSet) {
            JsonObject urlPattern = ((JsonElement)path.getValue()).getAsJsonObject();
            String pathText = path.getKey().toString();
            Set operationSet = urlPattern.entrySet();
            for (Map.Entry operationEntry : operationSet) {
                OMElement uriTemplateElement = factory.createOMElement(URI_TEMPLATE, namespace);
                OMElement urlPatternElement = factory.createOMElement(URL_PATTERN, namespace);
                OMElement httpVerbElement = factory.createOMElement(HTTP_VERB, namespace);
                OMElement authTypeElement = factory.createOMElement(AUTH_TYPE, namespace);
                urlPatternElement.setText(pathText);
                httpVerbElement.setText(operationEntry.getKey().toString());
                uriTemplateElement.addChild((OMNode)urlPatternElement);
                uriTemplateElement.addChild((OMNode)httpVerbElement);
                uriTemplateElement.addChild((OMNode)authTypeElement);
                uriTemplates.add(uriTemplateElement);
            }
        }
        return uriTemplates;
    }

    private static List<OMElement> createURITemplateFromWADL(OMElement resourcesElement) {
        ArrayList<OMElement> uriTemplates = new ArrayList<OMElement>();
        Iterator resources = resourcesElement.getChildrenWithLocalName(RESOURCE);
        while (resources.hasNext()) {
            OMElement resource = (OMElement)resources.next();
            String path = resource.getAttributeValue(new QName(PATH));
            path = path.endsWith(PATH_SEPERATOR) ? path : path + PATH_SEPERATOR;
            Iterator methods = resource.getChildrenWithLocalName(METHOD);
            uriTemplates.addAll(RESTServiceUtils.getUriTemplateElementFromMethods(path, methods));
            Iterator subResources = resource.getChildrenWithLocalName(RESOURCE);
            while (subResources.hasNext()) {
                OMElement subResource = (OMElement)subResources.next();
                String subPath = subResource.getAttributeValue(new QName(PATH));
                subPath = subPath.startsWith(PATH_SEPERATOR) ? subPath.substring(1) : subPath;
                Iterator subMethods = resource.getChildrenWithLocalName(METHOD);
                uriTemplates.addAll(RESTServiceUtils.getUriTemplateElementFromMethods(subPath, subMethods));
            }
        }
        return uriTemplates;
    }

    private static List<OMElement> getUriTemplateElementFromMethods(String resourcePath, Iterator methods) {
        ArrayList<OMElement> uriTemplates = new ArrayList<OMElement>();
        while (methods.hasNext()) {
            OMElement method = (OMElement)methods.next();
            String httpVerb = method.getAttributeValue(new QName(NAME));
            OMElement uriTemplateElement = factory.createOMElement(URI_TEMPLATE, namespace);
            OMElement urlPatternElement = factory.createOMElement(URL_PATTERN, namespace);
            OMElement httpVerbElement = factory.createOMElement(HTTP_VERB, namespace);
            OMElement authTypeElement = factory.createOMElement(AUTH_TYPE, namespace);
            urlPatternElement.setText(resourcePath);
            httpVerbElement.setText(httpVerb);
            uriTemplateElement.addChild((OMNode)urlPatternElement);
            uriTemplateElement.addChild((OMNode)httpVerbElement);
            uriTemplateElement.addChild((OMNode)authTypeElement);
            uriTemplates.add(uriTemplateElement);
        }
        return uriTemplates;
    }

    private static String getChrootedServiceLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + commonRestServiceLocation));
    }

    private static String getChrootedEndpointLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + commonEndpointLocation));
    }

    public static void setCommonRestServiceLocation(String restServiceLocation) {
        commonRestServiceLocation = restServiceLocation;
    }

    public static void setCommonEndpointLocation(String endpointLocation) {
        commonEndpointLocation = endpointLocation;
    }

    private static Properties copyProperties(RequestContext requestContext) {
        Properties properties = requestContext.getResource().getProperties();
        Properties copiedProperties = new Properties();
        if (properties != null) {
            List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String key = (String)e.getKey();
                if (linkProperties.contains(key) || key.startsWith(RESOURCE) || key.startsWith("registry")) continue;
                copiedProperties.put(key, (List)e.getValue());
            }
        }
        return copiedProperties;
    }
}

