/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class RecursiveDeleteHandler
extends Handler {
    private static ThreadLocal<Boolean> deleteInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public void delete(RequestContext requestContext) throws RegistryException {
        Resource resource = requestContext.getResource();
        if (resource instanceof Collection) {
            if (!RecursiveDeleteHandler.isDeleteLockAvailable()) {
                return;
            }
            RecursiveDeleteHandler.acquireDeleteLock();
            try {
                this.deleteRecursively(requestContext.getRegistry(), (org.wso2.carbon.registry.api.Resource)resource);
                requestContext.setProcessingComplete(true);
            }
            finally {
                RecursiveDeleteHandler.releaseDeleteLock();
            }
        }
    }

    private void deleteRecursively(Registry registry, org.wso2.carbon.registry.api.Resource resource) throws RegistryException {
        if (resource instanceof Collection) {
            for (String childResource : ((Collection)resource).getChildren()) {
                this.deleteRecursively(registry, (org.wso2.carbon.registry.api.Resource)registry.get(childResource));
            }
        }
        registry.delete(resource.getPath());
    }

    public static boolean isDeleteLockAvailable() {
        return deleteInProgress.get() == false;
    }

    public static void acquireDeleteLock() {
        deleteInProgress.set(true);
    }

    public static void releaseDeleteLock() {
        deleteInProgress.set(false);
    }
}

