/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ArtifactCleanUpHandler
extends Handler {
    private static final Log log = LogFactory.getLog(ArtifactCleanUpHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Association[] associations;
            Registry registry = requestContext.getRegistry();
            ResourcePath resourcePath = requestContext.getResourcePath();
            if (resourcePath == null) {
                throw new RegistryException("The resource path is not available.");
            }
            HashSet<String> associatedRes = new HashSet<String>();
            for (Association association : associations = registry.getAllAssociations(resourcePath.getPath())) {
                associatedRes.add(association.getDestinationPath());
                registry.removeAssociation(resourcePath.getPath(), association.getDestinationPath(), association.getAssociationType());
            }
            HashSet<String> allAssociatedRes = new HashSet<String>(associatedRes);
            for (String path : associatedRes) {
                Association[] allAssociations;
                for (Association association : allAssociations = registry.getAllAssociations(path)) {
                    allAssociatedRes.add(association.getDestinationPath());
                    registry.removeAssociation(path, association.getDestinationPath(), association.getAssociationType());
                }
            }
            for (String path : allAssociatedRes) {
                try {
                    registry.delete(path);
                }
                catch (RegistryException ex) {
                    log.error((Object)"Unable to delete associated resource", (Throwable)ex);
                }
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

