/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.aspects;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.Repository;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class DefaultLifecycle
extends Aspect {
    public static final String PHASE_CREATED = "created";
    public static final String PHASE_DEVELOPED = "developed";
    public static final String PHASE_TESTED = "tested";
    public static final String PHASE_DEPLOYED = "deployed";
    private static final String ORIGINAL_PATH = "originalPath";
    static final String[] phases = new String[]{"created", "developed", "tested", "deployed"};
    public static final String PHASE_PROPERTY = "DefaultLifecycle.phase";
    public static final String ACTION = "promote";
    private static List<String> promote = new ArrayList<String>();

    public void associate(Resource resource, Registry registry) throws RegistryException {
        resource.setProperty(PHASE_PROPERTY, PHASE_CREATED);
    }

    public void dissociate(RequestContext context) {
        context.getResource().removeProperty(PHASE_PROPERTY);
    }

    public void invoke(RequestContext context, String action) throws RegistryException {
        int i;
        String currentPhase;
        if (!ACTION.equals(action)) {
            throw new RegistryException("Unsupported lifecycle action '" + action + "'.  Only valid action is '" + ACTION + "'");
        }
        RegistryContext registryContext = context.getRegistry().getRegistryContext();
        Repository repository = registryContext.getRepository();
        Resource resource = context.getResource();
        String originalPath = resource.getProperty(ORIGINAL_PATH);
        if (originalPath == null) {
            resource.setProperty(ORIGINAL_PATH, resource.getPath());
            originalPath = resource.getPath();
            repository.put(originalPath, resource);
        }
        if ((currentPhase = resource.getProperty(PHASE_PROPERTY)) == null) {
            throw new RegistryException("DefaultLifecycle: Resource '" + resource.getPath() + "' has no phase property");
        }
        for (i = 0; i < phases.length && !phases[i].equals(currentPhase); ++i) {
        }
        if (i == phases.length) {
            throw new RegistryException("Resource " + resource.getPath() + " is in an invalid lifecycle phase ('" + currentPhase + "')");
        }
        if (i == phases.length - 1) {
            throw new RegistryException("Promotion disallowed - resource is at the end of the DefaultLifecycle");
        }
        String nextPhase = phases[i + 1];
        String newResourcePath = "/" + nextPhase + originalPath;
        repository.copy(new ResourcePath(resource.getPath()), new ResourcePath(newResourcePath));
        Resource newResource = repository.get(newResourcePath);
        newResource.setProperty(PHASE_PROPERTY, nextPhase);
        repository.put(newResourcePath, newResource);
    }

    public String[] getAvailableActions(RequestContext context) {
        return promote.toArray(new String[1]);
    }

    static {
        promote.add(ACTION);
    }
}

