/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy.wsxacml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.Base64;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xacml.profile.saml.impl.XACMLAuthzDecisionQueryTypeImplBuilder;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.entitlement.proxy.AbstractEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.Attribute;
import org.wso2.carbon.identity.entitlement.proxy.XACMLRequetBuilder;
import org.wso2.carbon.identity.entitlement.proxy.exception.EntitlementProxyException;
import org.wso2.carbon.identity.entitlement.proxy.wsxacml.X509CredentialImpl;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;

public class WSXACMLEntitlementServiceClient
extends AbstractEntitlementServiceClient {
    private static final Log log = LogFactory.getLog(WSXACMLEntitlementServiceClient.class);
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    public static final String ISSUER_URL = "https://identity.carbon.wso2.org";
    public static final String DOCUMENT_BUILDER_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    public static final String DOCUMENT_BUILDER_FACTORY_IMPL = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static boolean isBootStrapped = false;
    public static final String URN_OASIS_NAMES_TC_XACML_2_0_CONTEXT_SCHEMA_OS = "urn:oasis:names:tc:xacml:2.0:context:schema:os";
    private static OMNamespace xacmlContextNS = OMAbstractFactory.getOMFactory().createOMNamespace("urn:oasis:names:tc:xacml:2.0:context:schema:os", "xacml-context");
    HttpTransportProperties.Authenticator authenticator;
    private String serverUrl;

    public WSXACMLEntitlementServiceClient(String serverUrl, String userName, String password) {
        this.serverUrl = serverUrl;
        this.authenticator = new HttpTransportProperties.Authenticator();
        this.authenticator.setUsername(userName);
        this.authenticator.setPassword(password);
        this.authenticator.setPreemptiveAuthentication(true);
    }

    public static void doBootstrap() {
        if (!isBootStrapped) {
            try {
                SAMLInitializer.doBootstrap();
                isBootStrapped = true;
            }
            catch (InitializationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML2 library", (Throwable)e);
            }
        }
    }

    private static void setXACMLNamespace(Iterator iterator) {
        while (iterator.hasNext()) {
            OMElement omElemnt2 = (OMElement)iterator.next();
            omElemnt2.setNamespace(xacmlContextNS);
            if (!omElemnt2.getChildElements().hasNext()) continue;
            WSXACMLEntitlementServiceClient.setXACMLNamespace(omElemnt2.getChildElements());
        }
    }

    private static Issuer createIssuer() {
        IssuerBuilder issuer = (IssuerBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuerObject = issuer.buildObject();
        issuerObject.setValue(ISSUER_URL);
        issuerObject.setSPProvidedID("SPPProvierId");
        return issuerObject;
    }

    @Override
    public String getDecision(Attribute[] attributes, String appId) throws Exception {
        try {
            String xacmlRequest = XACMLRequetBuilder.buildXACML3Request(attributes);
            String xacmlAuthzDecisionQuery = this.buildSAMLXACMLAuthzDecisionQuery(xacmlRequest);
            ServiceClient sc = new ServiceClient();
            Options opts = new Options();
            opts.setTo(new EndpointReference(this.serverUrl + "ws-xacml"));
            opts.setAction("XACMLAuthzDecisionQuery");
            opts.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)this.authenticator);
            opts.setManageSession(true);
            sc.setOptions(opts);
            OMElement samlResponseElement = sc.sendReceive(AXIOMUtil.stringToOM((String)xacmlAuthzDecisionQuery));
            String samlResponse = samlResponseElement.toString();
            String result = this.extractXACMLResponse(samlResponse);
            sc.cleanupTransport();
            return result;
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while getting decision using SAML.", (Throwable)e);
            throw new Exception("Error occurred while getting decision using SAML.", e);
        }
    }

    @Override
    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, String domainId, String appId) throws Exception {
        return false;
    }

    @Override
    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, Attribute[] attributes, String domainId, String appId) throws Exception {
        return false;
    }

    @Override
    public List<String> getResourcesForAlias(String alias, String appId) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getActionableResourcesForAlias(String alias, String appId) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getActionableChildResourcesForAlias(String alias, String parentResource, String action, String appId) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getActionsForResource(String alias, String resources, String appId) throws Exception {
        return new ArrayList<String>();
    }

    private String extractXACMLResponse(String samlResponse) throws EntitlementProxyException {
        Response samlResponseObject = null;
        ResponseType xacmlResponse = null;
        WSXACMLEntitlementServiceClient.doBootstrap();
        Init.init();
        try {
            samlResponseObject = (Response)this.unmarshall(samlResponse);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while unmarshalling the SAML Response!", (Throwable)e);
            throw new EntitlementProxyException("Error occurred while unmarshalling the SAML Response!", e);
        }
        String xacmlResponseString = null;
        if (this.validateIssuer(samlResponseObject.getIssuer())) {
            if (this.validateSignature(samlResponseObject.getSignature())) {
                List assertionList = samlResponseObject.getAssertions();
                Assertion assertion1 = (Assertion)assertionList.get(0);
                if (this.validateIssuer(assertion1.getIssuer())) {
                    xacmlResponse = ((XACMLAuthzDecisionStatementType)assertion1.getStatements(XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20).get(0)).getResponse();
                    try {
                        xacmlResponseString = XMLUtils.toOM((Element)xacmlResponse.getDOM()).toString().replaceAll("xacml-context:", "");
                    }
                    catch (Exception e) {
                        log.error((Object)"Error occurred while converting the SAML Response DOM to OMElement", (Throwable)e);
                        throw new EntitlementProxyException("Error occurred while converting the SAML Response DOM to OMElement", e);
                    }
                } else {
                    log.debug((Object)"The submitted issuer is not valid for assertion.");
                }
            } else {
                log.debug((Object)"The submitted signature is not valid for the saml response.");
            }
        } else {
            log.debug((Object)"The submitted issuer is not valid for the saml response.");
        }
        return xacmlResponseString;
    }

    private boolean validateIssuer(Issuer issuer) {
        boolean isValidated = false;
        if (ISSUER_URL.equals(issuer.getValue()) && "SPPProvider".equals(issuer.getSPProvidedID())) {
            isValidated = true;
        }
        return isValidated;
    }

    private boolean validateSignature(Signature signature) throws EntitlementProxyException {
        boolean isSignatureValid = false;
        try {
            SignatureValidator.validate((Signature)signature, (Credential)this.getPublicX509CredentialImpl());
            isSignatureValid = true;
        }
        catch (SignatureException e) {
            log.warn((Object)"Signature validation failed.", (Throwable)e);
        }
        return isSignatureValid;
    }

    private X509CredentialImpl getPublicX509CredentialImpl() throws EntitlementProxyException {
        X509CredentialImpl credentialImpl = null;
        java.security.cert.X509Certificate cert = this.createBasicCredentials().getEntityCertificate();
        credentialImpl = new X509CredentialImpl(cert);
        return credentialImpl;
    }

    private String buildSAMLXACMLAuthzDecisionQuery(String xacmlRequest) throws EntitlementProxyException {
        RequestType request = null;
        WSXACMLEntitlementServiceClient.doBootstrap();
        String xacmlAuthzDecisionQueryString = null;
        try {
            request = (RequestType)this.unmarshall(this.formatRequest(xacmlRequest));
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while unmarshalling the XACML Request!", (Throwable)e);
            throw new EntitlementProxyException("Error occurred while unmarshalling the XACML Request!", e);
        }
        XACMLAuthzDecisionQueryTypeImplBuilder xacmlauthz = (XACMLAuthzDecisionQueryTypeImplBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(XACMLAuthzDecisionQueryType.TYPE_NAME_XACML20);
        XACMLAuthzDecisionQueryType xacmlAuthzDecisionQuery = (XACMLAuthzDecisionQueryType)xacmlauthz.buildObject(XACMLAuthzDecisionQueryType.TYPE_NAME_XACML20);
        DateTime currentTime = new DateTime();
        xacmlAuthzDecisionQuery.setRequest(request);
        xacmlAuthzDecisionQuery.setInputContextOnly(Boolean.valueOf(true));
        xacmlAuthzDecisionQuery.setReturnContext(Boolean.valueOf(false));
        xacmlAuthzDecisionQuery.setIssueInstant(currentTime);
        xacmlAuthzDecisionQuery.setIssuer(WSXACMLEntitlementServiceClient.createIssuer());
        try {
            xacmlAuthzDecisionQuery = this.setSignature(xacmlAuthzDecisionQuery, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", (X509Credential)this.createBasicCredentials());
        }
        catch (Exception e) {
            log.error((Object)"Error while building SAMLXACMLAuthzDecisionQuery from the given xacml request", (Throwable)e);
            throw new EntitlementProxyException("Error while building SAMLXACMLAuthzDecisionQuery from the given xacml request", e);
        }
        if (xacmlAuthzDecisionQuery != null) {
            try {
                xacmlAuthzDecisionQueryString = this.marshall((XMLObject)xacmlAuthzDecisionQuery);
                xacmlAuthzDecisionQueryString = xacmlAuthzDecisionQueryString.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "").replace("\n", "");
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while marshalling XACMLAuthzDecisionQuery.", (Throwable)e);
                throw new EntitlementProxyException("Error occurred while marshalling XACMLAuthzDecisionQuery.", e);
            }
        }
        return xacmlAuthzDecisionQueryString;
    }

    private String formatRequest(String xacmlRequest) throws EntitlementProxyException {
        xacmlRequest = xacmlRequest.replace("\n", "");
        OMElement omElemnt = null;
        try {
            omElemnt = AXIOMUtil.stringToOM((String)xacmlRequest);
            omElemnt.setNamespace(xacmlContextNS);
            Iterator childIterator = omElemnt.getChildElements();
            WSXACMLEntitlementServiceClient.setXACMLNamespace(childIterator);
            return omElemnt.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while formatting the XACML request", (Throwable)e);
            throw new EntitlementProxyException("Error occurred while formatting the XACML request", e);
        }
    }

    private XMLObject unmarshall(String xmlString) throws EntitlementProxyException {
        try {
            WSXACMLEntitlementServiceClient.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            try {
                documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException e) {
                log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd or secure-processing.");
            }
            SecurityManager securityManager = new SecurityManager();
            securityManager.setEntityExpansionLimit(0);
            documentBuilderFactory.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(xmlString.trim().getBytes(Charset.forName("UTF-8"))));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (Exception e) {
            log.error((Object)"Error in constructing XML(SAML or XACML) Object from the encoded String", (Throwable)e);
            throw new EntitlementProxyException("Error in constructing XML(SAML or XACML) from the encoded String", e);
        }
    }

    private String marshall(XMLObject xmlObject) throws EntitlementProxyException {
        try {
            WSXACMLEntitlementServiceClient.doBootstrap();
            System.setProperty(DOCUMENT_BUILDER_FACTORY, DOCUMENT_BUILDER_FACTORY_IMPL);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return new String(byteArrayOutputStrm.toByteArray(), Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            log.error((Object)"Error Serializing the SAML Response");
            throw new EntitlementProxyException("Error Serializing the SAML Response", e);
        }
    }

    private XACMLAuthzDecisionQueryType setSignature(XACMLAuthzDecisionQueryType xacmlAuthzDecisionQueryType, String signatureAlgorithm, X509Credential cred) throws EntitlementProxyException {
        WSXACMLEntitlementServiceClient.doBootstrap();
        try {
            Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            try {
                KeyInfo keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data data = (X509Data)this.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate cert = (X509Certificate)this.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                String value = Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
                cert.setValue(value);
                data.getX509Certificates().add(cert);
                keyInfo.getX509Datas().add(data);
                signature.setKeyInfo(keyInfo);
            }
            catch (CertificateEncodingException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Certificate Encoding Exception occurred : ", (Throwable)e);
                }
                throw new EntitlementProxyException("Error getting the certificate.");
            }
            xacmlAuthzDecisionQueryType.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)xacmlAuthzDecisionQueryType);
            marshaller.marshall((XMLObject)xacmlAuthzDecisionQueryType);
            Init.init();
            Signer.signObjects(signatureList);
            return xacmlAuthzDecisionQueryType;
        }
        catch (Exception e) {
            throw new EntitlementProxyException("Error When signing the assertion.", e);
        }
    }

    private BasicX509Credential createBasicCredentials() {
        PrivateKey issuerPK = null;
        Certificate certificate = null;
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String ksPassword = serverConfig.getFirstProperty("Security.KeyStore.Password");
        String ksLocation = serverConfig.getFirstProperty("Security.KeyStore.Location");
        String keyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
        String ksType = serverConfig.getFirstProperty("Security.KeyStore.Type");
        String privateKeyPassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
        try {
            FileInputStream fis = new FileInputStream(ksLocation);
            BufferedInputStream bis = new BufferedInputStream(fis);
            KeyStore keyStore = KeyStore.getInstance(ksType);
            keyStore.load(bis, ksPassword.toCharArray());
            bis.close();
            issuerPK = (PrivateKey)keyStore.getKey(keyAlias, privateKeyPassword.toCharArray());
            certificate = keyStore.getCertificate(keyAlias);
        }
        catch (KeyStoreException e) {
            log.error((Object)"Error in getting a keystore.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Error in reading the keystore file from given the location.", (Throwable)e);
        }
        catch (CertificateException e) {
            log.error((Object)"Error in creating a X.509 certificate.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Error in loading the keystore.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error in reading keystore file.", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            log.error((Object)"Error in getting the private key.", (Throwable)e);
        }
        BasicX509Credential basicCredential = new BasicX509Credential((java.security.cert.X509Certificate)certificate, issuerPK);
        return basicCredential;
    }

    private XMLObject buildXMLObject(QName objectQName) throws EntitlementProxyException {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new EntitlementProxyException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }
}

