/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy.thrift;

import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.wso2.carbon.identity.entitlement.proxy.exception.EntitlementProxyException;
import org.wso2.carbon.identity.entitlement.proxy.generatedCode.AuthenticatorService;

public class Authenticator {
    private String userName;
    private String password;
    private String serverUrl;
    private String sessionId;

    public Authenticator(String userName, String password, String serverUrl) throws EntitlementProxyException {
        this.userName = userName;
        this.password = password;
        this.serverUrl = serverUrl;
        if (!this.authenticate()) {
            throw new EntitlementProxyException("Authentication Failed");
        }
    }

    private boolean authenticate() throws EntitlementProxyException {
        boolean isAuthenticated;
        try {
            THttpClient client = new THttpClient(this.serverUrl);
            TCompactProtocol protocol = new TCompactProtocol((TTransport)client);
            AuthenticatorService.Client authClient = new AuthenticatorService.Client((TProtocol)protocol);
            client.open();
            this.sessionId = authClient.authenticate(this.userName, this.password);
            client.close();
            isAuthenticated = true;
        }
        catch (Exception e) {
            throw new EntitlementProxyException("Error while authenticating with ThriftAuthenticator", e);
        }
        return isAuthenticated;
    }

    public String getSessionId(boolean isExpired) throws EntitlementProxyException {
        if (isExpired) {
            this.authenticate();
        }
        return this.sessionId;
    }
}

