/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy.soap.basicAuth;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wso2.carbon.identity.entitlement.proxy.AbstractEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.Attribute;
import org.wso2.carbon.identity.entitlement.proxy.XACMLRequetBuilder;
import org.wso2.carbon.identity.entitlement.proxy.exception.EntitlementProxyException;
import org.wso2.carbon.identity.entitlement.proxy.soap.util.EntitlementServiceStubFactory;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceStub;
import org.wso2.carbon.identity.entitlement.stub.dto.EntitledAttributesDTO;
import org.wso2.carbon.identity.entitlement.stub.dto.EntitledResultSetDTO;

public class BasicAuthEntitlementServiceClient
extends AbstractEntitlementServiceClient {
    private static final String ENTITLEMENT_SERVICE_NAME = "EntitlementService";
    private static final Log log = LogFactory.getLog(BasicAuthEntitlementServiceClient.class);
    private static final String DEFAULT_CLIENT_REPO = "repository" + File.separator + "deployment" + File.separator + "client";
    private static final String DEFAULT_AXIS2_XML = "repository" + File.separator + "conf" + File.separator + "axis2" + File.separator + "axis2_blocking_client.xml";
    private static final int MAX_CONNECTIONS_PER_HOST = 200;
    private static final String XACML_DECISION_PERMIT = "Permit";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_CATEGORY_ACCESS_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    public static final String URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ACTION = "urn:oasis:names:tc:xacml:3.0:attribute-category:action";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_ACTION_ACTION_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
    public static final String URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_RESOURCE = "urn:oasis:names:tc:xacml:3.0:attribute-category:resource";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_RESOURCE_RESOURCE_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    public static final String URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ENVIRONMENT = "urn:oasis:names:tc:xacml:3.0:attribute-category:environment";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_ENVIRONMENT_ENVIRONMENT_ID = "urn:oasis:names:tc:xacml:1.0:environment:environment-id";
    private String serverUrl;
    private GenericObjectPool serviceStubPool;
    private HttpTransportProperties.Authenticator authenticator;
    private ConfigurationContext configurationContext;

    public BasicAuthEntitlementServiceClient(String serverUrl, String userName, String password) {
        this.serverUrl = serverUrl;
        this.authenticator = new HttpTransportProperties.Authenticator();
        this.authenticator.setUsername(userName);
        this.authenticator.setPassword(password);
        this.authenticator.setPreemptiveAuthentication(true);
        try {
            this.initConfigurationContext();
        }
        catch (AxisFault e) {
            log.error((Object)"Error initializing Axis2 configuration context", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error initializing default Axis2 configuration context", (Throwable)e);
        }
    }

    private void initConfigurationContext() throws Exception {
        MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpClient httpClient = new HttpClient((HttpConnectionManager)multiThreadedHttpConnectionManager);
        File configFile = new File(DEFAULT_AXIS2_XML);
        if (!configFile.exists()) {
            this.configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
            this.configurationContext.setProperty("defaultMaxConnectionsPerHost", (Object)200);
        } else {
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)DEFAULT_CLIENT_REPO, (String)DEFAULT_AXIS2_XML);
        }
        this.configurationContext.setProperty("CACHED_HTTP_CLIENT", (Object)httpClient);
        this.configurationContext.setProperty("REUSE_HTTP_CLIENT", (Object)"true");
        HashMap transportsOut = this.configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription transportOutDescription : transportsOut.values()) {
            if (!"http".equals(transportOutDescription.getName()) && !"https".equals(transportOutDescription.getName())) continue;
            transportOutDescription.getSender().init(this.configurationContext, transportOutDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDecision(Attribute[] attributes, String appId) throws Exception {
        EntitlementServiceStub stub = null;
        try {
            String xacmlRequest = XACMLRequetBuilder.buildXACML3Request(attributes);
            stub = this.getEntitlementStub(this.serverUrl);
            String string = this.getDecision(xacmlRequest, stub);
            return string;
        }
        finally {
            if (stub != null) {
                stub._getServiceClient().cleanupTransport();
                this.serviceStubPool.returnObject((Object)stub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, String domainId, String appId) throws Exception {
        Attribute subjectAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_CATEGORY_ACCESS_SUBJECT, subjectType, "string", alias);
        Attribute actionAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ACTION, URN_OASIS_NAMES_TC_XACML_1_0_ACTION_ACTION_ID, "string", actionId);
        Attribute resourceAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_RESOURCE, URN_OASIS_NAMES_TC_XACML_1_0_RESOURCE_RESOURCE_ID, "string", resourceId);
        Attribute environmentAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ENVIRONMENT, URN_OASIS_NAMES_TC_XACML_1_0_ENVIRONMENT_ENVIRONMENT_ID, "string", domainId);
        Attribute[] tempArr = new Attribute[]{subjectAttribute, actionAttribute, resourceAttribute, environmentAttribute};
        String xacmlRequest = XACMLRequetBuilder.buildXACML3Request(tempArr);
        EntitlementServiceStub stub = null;
        try {
            stub = this.getEntitlementStub(this.serverUrl);
            String result = this.getDecision(xacmlRequest, stub);
            boolean bl = result.contains(XACML_DECISION_PERMIT);
            return bl;
        }
        finally {
            if (stub != null) {
                stub._getServiceClient().cleanupTransport();
                this.serviceStubPool.returnObject((Object)stub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, Attribute[] attributes, String domainId, String appId) throws Exception {
        Attribute[] attrs = new Attribute[attributes.length + 4];
        attrs[0] = new Attribute(URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_CATEGORY_ACCESS_SUBJECT, subjectType, "string", alias);
        for (int i = 0; i < attributes.length; ++i) {
            attrs[i + 1] = new Attribute(URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_CATEGORY_ACCESS_SUBJECT, attributes[i].getType(), attributes[i].getId(), attributes[i].getValue());
        }
        attrs[attrs.length - 3] = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ACTION, URN_OASIS_NAMES_TC_XACML_1_0_ACTION_ACTION_ID, "string", actionId);
        attrs[attrs.length - 2] = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_RESOURCE, URN_OASIS_NAMES_TC_XACML_1_0_RESOURCE_RESOURCE_ID, "string", resourceId);
        attrs[attrs.length - 1] = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ENVIRONMENT, URN_OASIS_NAMES_TC_XACML_1_0_ENVIRONMENT_ENVIRONMENT_ID, "string", domainId);
        String xacmlRequest = XACMLRequetBuilder.buildXACML3Request(attrs);
        EntitlementServiceStub stub = null;
        try {
            stub = this.getEntitlementStub(this.serverUrl);
            String result = this.getDecision(xacmlRequest, stub);
            boolean bl = result.contains(XACML_DECISION_PERMIT);
            return bl;
        }
        finally {
            if (stub != null) {
                stub._getServiceClient().cleanupTransport();
                this.serviceStubPool.returnObject((Object)stub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getResourcesForAlias(String alias, String appId) throws Exception {
        EntitlementServiceStub stub = null;
        try {
            stub = this.getEntitlementStub(this.serverUrl);
            List<String> list = this.getResources(this.getEntitledAttributes(alias, null, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", null, false, stub));
            return list;
        }
        finally {
            if (stub != null) {
                stub._getServiceClient().cleanupTransport();
                this.serviceStubPool.returnObject((Object)stub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getActionableResourcesForAlias(String alias, String appId) throws Exception {
        EntitlementServiceStub stub = null;
        try {
            stub = this.getEntitlementStub(this.serverUrl);
            List<String> list = this.getResources(this.getEntitledAttributes(alias, null, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", null, true, stub));
            return list;
        }
        finally {
            if (stub != null) {
                stub._getServiceClient().cleanupTransport();
                this.serviceStubPool.returnObject((Object)stub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getActionsForResource(String alias, String resource, String appId) throws Exception {
        EntitlementServiceStub stub = null;
        try {
            stub = this.getEntitlementStub(this.serverUrl);
            List<String> list = this.getActions(this.getEntitledAttributes(alias, resource, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", null, false, stub));
            return list;
        }
        finally {
            if (stub != null) {
                stub._getServiceClient().cleanupTransport();
                this.serviceStubPool.returnObject((Object)stub);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getActionableChildResourcesForAlias(String alias, String parentResource, String action, String appId) throws Exception {
        EntitlementServiceStub stub = null;
        try {
            stub = this.getEntitlementStub(this.serverUrl);
            List<String> list = this.getResources(this.getEntitledAttributes(alias, parentResource, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", action, true, stub));
            return list;
        }
        finally {
            if (stub != null) {
                stub._getServiceClient().cleanupTransport();
                this.serviceStubPool.returnObject((Object)stub);
            }
        }
    }

    private EntitlementServiceStub getEntitlementStub(String serverUrl) throws Exception {
        if (this.configurationContext == null) {
            throw new EntitlementProxyException("Cannot initialize EntitlementServiceStub with null Axis2 configuration context.");
        }
        if (this.serviceStubPool == null) {
            this.serviceStubPool = new GenericObjectPool((PoolableObjectFactory)new EntitlementServiceStubFactory(this.configurationContext, serverUrl + ENTITLEMENT_SERVICE_NAME, this.authenticator));
        }
        return (EntitlementServiceStub)this.serviceStubPool.borrowObject();
    }

    private String getDecision(String request, EntitlementServiceStub stub) throws Exception {
        return stub.getDecision(request);
    }

    private EntitledAttributesDTO[] getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch, EntitlementServiceStub stub) throws Exception {
        EntitledResultSetDTO results = stub.getEntitledAttributes(subjectName, resourceName, subjectId, action, enableChildSearch);
        return results.getEntitledAttributesDTOs();
    }

    private List<String> getResources(EntitledAttributesDTO[] entitledAttrs) {
        ArrayList<String> list = new ArrayList<String>();
        if (entitledAttrs != null) {
            for (EntitledAttributesDTO dto : entitledAttrs) {
                list.add(dto.getResourceName());
            }
        }
        return list;
    }

    private List<String> getActions(EntitledAttributesDTO[] entitledAttrs) {
        ArrayList<String> list = new ArrayList<String>();
        if (entitledAttrs != null) {
            for (EntitledAttributesDTO dto : entitledAttrs) {
                list.add(dto.getAction());
            }
        }
        return list;
    }
}

