/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy.soap.authenticationAdmin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.entitlement.proxy.AbstractEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.Attribute;
import org.wso2.carbon.identity.entitlement.proxy.XACMLRequetBuilder;
import org.wso2.carbon.identity.entitlement.proxy.soap.authenticationAdmin.Authenticator;
import org.wso2.carbon.identity.entitlement.stub.EntitlementPolicyAdminServiceStub;
import org.wso2.carbon.identity.entitlement.stub.EntitlementServiceStub;
import org.wso2.carbon.identity.entitlement.stub.dto.EntitledAttributesDTO;
import org.wso2.carbon.identity.entitlement.stub.dto.EntitledResultSetDTO;

public class SOAPEntitlementServiceClient
extends AbstractEntitlementServiceClient {
    public static final String ACCESS_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    public static final String ACTION = "urn:oasis:names:tc:xacml:3.0:attribute-category:action";
    public static final String ACTION_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
    public static final String RESOURCE = "urn:oasis:names:tc:xacml:3.0:attribute-category:resource";
    public static final String RESOURCE_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    public static final String CATEGORY_ENVIRONMENT = "urn:oasis:names:tc:xacml:3.0:attribute-category:environment";
    public static final String ENVIRONMENT_ID = "urn:oasis:names:tc:xacml:1.0:environment:environment-id";
    private Map<String, EntitlementServiceStub> entitlementStub = new ConcurrentHashMap<String, EntitlementServiceStub>();
    private Map<String, EntitlementPolicyAdminServiceStub> policyAdminStub = new ConcurrentHashMap<String, EntitlementPolicyAdminServiceStub>();
    private Map<String, Authenticator> authenticators = new ConcurrentHashMap<String, Authenticator>();
    private String serverUrl;
    private String userName;
    private String password;
    private boolean reuseSession = true;
    private String authorizedCookie;

    public SOAPEntitlementServiceClient(String serverUrl, String username, String password, boolean reuseSession) {
        this.serverUrl = serverUrl;
        this.userName = username;
        this.password = password;
        this.reuseSession = reuseSession;
    }

    public SOAPEntitlementServiceClient(String serverUrl, String authorizedCookie, boolean reuseSession) {
        this.serverUrl = serverUrl;
        this.authorizedCookie = authorizedCookie;
        this.reuseSession = reuseSession;
    }

    @Override
    public String getDecision(Attribute[] attributes, String appId) throws Exception {
        String xacmlRequest = XACMLRequetBuilder.buildXACML3Request(attributes);
        EntitlementServiceStub stub = this.getEntitlementStub(this.serverUrl);
        Authenticator authenticator = this.getAuthenticator(this.serverUrl, this.userName, this.password, this.authorizedCookie);
        String result = this.getDecision(xacmlRequest, stub, authenticator);
        stub._getServiceClient().cleanupTransport();
        return result;
    }

    @Override
    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, String domainId, String appId) throws Exception {
        Attribute subjectAttribute = new Attribute(ACCESS_SUBJECT, subjectType, "string", alias);
        Attribute actionAttribute = new Attribute(ACTION, ACTION_ID, "string", actionId);
        Attribute resourceAttribute = new Attribute(RESOURCE, RESOURCE_ID, "string", resourceId);
        Attribute environmentAttribute = new Attribute(CATEGORY_ENVIRONMENT, ENVIRONMENT_ID, "string", domainId);
        Attribute[] tempArr = new Attribute[]{subjectAttribute, actionAttribute, resourceAttribute, environmentAttribute};
        String xacmlRequest = XACMLRequetBuilder.buildXACML3Request(tempArr);
        EntitlementServiceStub stub = this.getEntitlementStub(this.serverUrl);
        Authenticator authenticator = this.getAuthenticator(this.serverUrl, this.userName, this.password, this.authorizedCookie);
        String result = this.getDecision(xacmlRequest, stub, authenticator);
        stub._getServiceClient().cleanupTransport();
        return result.contains("Permit");
    }

    @Override
    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, Attribute[] attributes, String domainId, String appId) throws Exception {
        Attribute[] attrs = new Attribute[attributes.length + 4];
        attrs[0] = new Attribute(ACCESS_SUBJECT, subjectType, "string", alias);
        for (int i = 0; i < attributes.length; ++i) {
            attrs[i + 1] = new Attribute(ACCESS_SUBJECT, attributes[i].getType(), attributes[i].getId(), attributes[i].getValue());
        }
        attrs[attrs.length - 3] = new Attribute(ACTION, ACTION_ID, "string", actionId);
        attrs[attrs.length - 2] = new Attribute(RESOURCE, RESOURCE_ID, "string", resourceId);
        attrs[attrs.length - 1] = new Attribute(CATEGORY_ENVIRONMENT, ENVIRONMENT_ID, "string", domainId);
        String xacmlRequest = XACMLRequetBuilder.buildXACML3Request(attrs);
        EntitlementServiceStub stub = this.getEntitlementStub(this.serverUrl);
        Authenticator authenticator = this.getAuthenticator(this.serverUrl, this.userName, this.password, this.authorizedCookie);
        String result = this.getDecision(xacmlRequest, stub, authenticator);
        stub._getServiceClient().cleanupTransport();
        return result.contains("Permit");
    }

    @Override
    public List<String> getResourcesForAlias(String alias, String appId) throws Exception {
        EntitlementServiceStub stub = this.getEntitlementStub(this.serverUrl);
        Authenticator authenticator = this.getAuthenticator(this.serverUrl, this.userName, this.password, this.authorizedCookie);
        List<String> results = this.getResources(this.getEntitledAttributes(alias, null, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", null, false, stub, authenticator));
        stub._getServiceClient().cleanupTransport();
        return results;
    }

    @Override
    public List<String> getActionableResourcesForAlias(String alias, String appId) throws Exception {
        EntitlementServiceStub stub = this.getEntitlementStub(this.serverUrl);
        Authenticator authenticator = this.getAuthenticator(this.serverUrl, this.userName, this.password, this.authorizedCookie);
        List<String> results = this.getResources(this.getEntitledAttributes(alias, null, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", null, true, stub, authenticator));
        stub._getServiceClient().cleanupTransport();
        return results;
    }

    @Override
    public List<String> getActionsForResource(String alias, String resource, String appId) throws Exception {
        EntitlementServiceStub stub = this.getEntitlementStub(this.serverUrl);
        Authenticator authenticator = this.getAuthenticator(this.serverUrl, this.userName, this.password, this.authorizedCookie);
        List<String> results = this.getActions(this.getEntitledAttributes(alias, resource, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", null, false, stub, authenticator));
        stub._getServiceClient().cleanupTransport();
        return results;
    }

    @Override
    public List<String> getActionableChildResourcesForAlias(String alias, String parentResource, String action, String appId) throws Exception {
        EntitlementServiceStub stub = this.getEntitlementStub(this.serverUrl);
        Authenticator authenticator = this.getAuthenticator(this.serverUrl, this.userName, this.password, this.authorizedCookie);
        List<String> results = this.getResources(this.getEntitledAttributes(alias, parentResource, "urn:oasis:names:tc:xacml:1.0:subject:subject-id", action, true, stub, authenticator));
        stub._getServiceClient().cleanupTransport();
        return results;
    }

    private Authenticator getAuthenticator(String serverUrl, String userName, String password, String authorizedCookie) throws Exception {
        if (this.reuseSession && this.authenticators.containsKey(serverUrl)) {
            return this.authenticators.get(serverUrl);
        }
        Authenticator authenticator = null;
        if (StringUtils.isNotEmpty((String)authorizedCookie)) {
            authenticator = new Authenticator(authorizedCookie, serverUrl + "AuthenticationAdmin");
        } else if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)password)) {
            authenticator = new Authenticator(userName, password, serverUrl + "AuthenticationAdmin");
        }
        this.setAuthCookie(false, (Stub)this.getEntitlementStub(serverUrl), authenticator);
        this.setAuthCookie(false, (Stub)this.getEntitlementAdminStub(serverUrl), authenticator);
        this.authenticators.put(serverUrl, authenticator);
        return authenticator;
    }

    private EntitlementServiceStub getEntitlementStub(String serverUrl) throws Exception {
        if (this.entitlementStub.containsKey(serverUrl)) {
            return this.entitlementStub.get(serverUrl);
        }
        ConfigurationContext configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        HashMap transportsOut = configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription transportOutDescription : transportsOut.values()) {
            transportOutDescription.getSender().init(configurationContext, transportOutDescription);
        }
        EntitlementServiceStub stub = new EntitlementServiceStub(configurationContext, serverUrl + "EntitlementService");
        this.entitlementStub.put(serverUrl, stub);
        return stub;
    }

    private EntitlementPolicyAdminServiceStub getEntitlementAdminStub(String serverUrl) throws Exception {
        if (this.policyAdminStub.containsKey(serverUrl)) {
            return this.policyAdminStub.get(serverUrl);
        }
        ConfigurationContext configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        HashMap transportsOut = configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription transportOutDescription : transportsOut.values()) {
            transportOutDescription.getSender().init(configurationContext, transportOutDescription);
        }
        EntitlementPolicyAdminServiceStub stub = new EntitlementPolicyAdminServiceStub(configurationContext, serverUrl + "EntitlementPolicyAdminService");
        this.policyAdminStub.put(serverUrl, stub);
        return stub;
    }

    private String getDecision(String request, EntitlementServiceStub stub, Authenticator authenticator) throws Exception {
        try {
            return stub.getDecision(request);
        }
        catch (AxisFault e) {
            if ("50977".equals(e.getFaultCode().getLocalPart())) {
                this.setAuthCookie(true, (Stub)stub, authenticator);
                return stub.getDecision(request);
            }
            throw e;
        }
    }

    private EntitledAttributesDTO[] getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch, EntitlementServiceStub stub, Authenticator authenticator) throws Exception {
        EntitledResultSetDTO results;
        try {
            results = stub.getEntitledAttributes(subjectName, resourceName, subjectId, action, enableChildSearch);
        }
        catch (AxisFault e) {
            if ("50977".equals(e.getFaultCode().getLocalPart())) {
                this.setAuthCookie(true, (Stub)stub, authenticator);
                results = stub.getEntitledAttributes(subjectName, resourceName, subjectId, action, enableChildSearch);
            }
            throw e;
        }
        return results.getEntitledAttributesDTOs();
    }

    private List<String> getResources(EntitledAttributesDTO[] entitledAttrs) {
        ArrayList<String> list = new ArrayList<String>();
        if (entitledAttrs != null) {
            for (EntitledAttributesDTO dto : entitledAttrs) {
                list.add(dto.getResourceName());
            }
        }
        return list;
    }

    private List<String> getActions(EntitledAttributesDTO[] entitledAttrs) {
        ArrayList<String> list = new ArrayList<String>();
        if (entitledAttrs != null) {
            for (EntitledAttributesDTO dto : entitledAttrs) {
                list.add(dto.getAction());
            }
        }
        return list;
    }

    private void setAuthCookie(boolean isExpired, Stub stub, Authenticator authenticator) throws Exception {
        ServiceClient client = stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)authenticator.getCookie(isExpired));
    }
}

