/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy.soap.authenticationAdmin;

import java.util.HashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.identity.entitlement.proxy.exception.EntitlementProxyException;

public class Authenticator {
    private String userName;
    private String password;
    private String serverUrl;
    private String cookie;
    private String authorizedCookie;

    public Authenticator(String userName, String password, String serverUrl) throws Exception {
        this.userName = userName;
        this.password = password;
        this.serverUrl = serverUrl;
        if (!this.authenticate()) {
            throw new EntitlementProxyException("Authentication Failed");
        }
    }

    public Authenticator(String authorizedCookie, String serverUrl) throws Exception {
        this.authorizedCookie = authorizedCookie;
        this.serverUrl = serverUrl;
        if (!this.authenticate()) {
            throw new EntitlementProxyException("Authentication Failed");
        }
    }

    private boolean authenticate() throws Exception {
        ConfigurationContext configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
        HashMap transportsOut = configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription transportOutDescription : transportsOut.values()) {
            transportOutDescription.getSender().init(configurationContext, transportOutDescription);
        }
        boolean isAuthenticated = false;
        if (StringUtils.isNotEmpty((String)this.userName) && StringUtils.isNotEmpty((String)this.password)) {
            AuthenticationAdminStub authAdmin = new AuthenticationAdminStub(configurationContext, this.serverUrl);
            isAuthenticated = authAdmin.login(this.userName, this.password, "localhost");
            this.cookie = (String)authAdmin._getServiceClient().getServiceContext().getProperty("Cookie");
            authAdmin._getServiceClient().cleanupTransport();
        } else if (StringUtils.isNotEmpty((String)this.authorizedCookie)) {
            isAuthenticated = true;
            this.cookie = this.authorizedCookie;
        }
        return isAuthenticated;
    }

    public String getCookie(boolean isExpired) throws Exception {
        if (isExpired) {
            this.authenticate();
        }
        return this.cookie;
    }
}

