/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy;

import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.proxy.Attribute;

public class XACMLRequetBuilder {
    private static final Log log = LogFactory.getLog(XACMLRequetBuilder.class);
    public static final String CORE_SCHEMA = "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17";
    public static final String ATTRIBUTE_ID = "AttributeId";
    public static final String XMLSCHEMA = "http://www.w3.org/2001/XMLSchema#";

    private XACMLRequetBuilder() {
    }

    public static String buildXACML3Request(Attribute[] attributes) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement requestXML = factory.createOMElement("Request", null);
        requestXML.addAttribute("xmlns", CORE_SCHEMA, null);
        requestXML.addAttribute("CombinedDecision", "false", null);
        requestXML.addAttribute("ReturnPolicyIdList", "false", null);
        HashSet<String> catagorySet = new HashSet<String>();
        block2: for (Attribute attribute : attributes) {
            if (!catagorySet.contains(attribute.getCategory())) {
                catagorySet.add(attribute.getCategory());
                OMElement attributesXML = factory.createOMElement("Attributes", null);
                attributesXML.addAttribute("Category", attribute.getCategory(), null);
                HashSet<String> attributeSet = new HashSet<String>();
                if (!attributeSet.contains(attribute.getId())) {
                    attributeSet.add(attribute.getId());
                    OMElement attributeXML = factory.createOMElement("Attribute", null);
                    attributeXML.addAttribute(ATTRIBUTE_ID, attribute.getId(), null);
                    attributeXML.addAttribute("IncludeInResult", "false", null);
                    OMElement attributeValueXML = factory.createOMElement("AttributeValue", null);
                    attributeValueXML.addAttribute("DataType", XMLSCHEMA + attribute.getType(), null);
                    attributeValueXML.setText(attribute.getValue());
                    attributeXML.addChild((OMNode)attributeValueXML);
                    attributesXML.addChild((OMNode)attributeXML);
                } else {
                    Iterator itr = attributesXML.getChildElements();
                    while (itr.hasNext()) {
                        OMElement attributeXML = (OMElement)itr.next();
                        if (!attribute.getId().equals(attributeXML.getAttributeValue(new QName(ATTRIBUTE_ID)))) continue;
                        OMElement attributeValueXML = factory.createOMElement("AttributeValue", null);
                        attributeValueXML.addAttribute("DataType", XMLSCHEMA + attribute.getType(), null);
                        attributeValueXML.setText(attribute.getValue());
                        attributeXML.addChild((OMNode)attributeValueXML);
                        break;
                    }
                }
                requestXML.addChild((OMNode)attributesXML);
                if (!StringUtils.isNotEmpty((String)attribute.getContent())) continue;
                try {
                    OMElement omContent = AXIOMUtil.stringToOM((String)attribute.getContent());
                    OMElement contentValueXML = factory.createOMElement("Content", null);
                    contentValueXML.addChild((OMNode)omContent.getFirstElement());
                    attributesXML.addChild((OMNode)contentValueXML);
                }
                catch (XMLStreamException e) {
                    log.error((Object)"Error in generating XACML Content element", (Throwable)e);
                }
                continue;
            }
            Iterator itr = requestXML.getChildElements();
            while (itr.hasNext()) {
                OMElement attributesXML = (OMElement)itr.next();
                if (!attribute.getCategory().equals(attributesXML.getAttributeValue(new QName("Category")))) continue;
                HashSet<String> attributeSet = new HashSet<String>();
                Iterator itr1 = attributesXML.getChildElements();
                while (itr1.hasNext()) {
                    attributeSet.add(((OMElement)itr1.next()).getAttributeValue(new QName(ATTRIBUTE_ID)));
                }
                if (!attributeSet.contains(attribute.getId())) {
                    attributeSet.add(attribute.getId());
                    OMElement attributeXML = factory.createOMElement("Attribute", null);
                    attributeXML.addAttribute(ATTRIBUTE_ID, attribute.getId(), null);
                    attributeXML.addAttribute("IncludeInResult", "false", null);
                    OMElement attributeValueXML = factory.createOMElement("AttributeValue", null);
                    attributeValueXML.addAttribute("DataType", XMLSCHEMA + attribute.getType(), null);
                    attributeValueXML.setText(attribute.getValue());
                    attributeXML.addChild((OMNode)attributeValueXML);
                    attributesXML.addChild((OMNode)attributeXML);
                    continue block2;
                }
                Iterator itr2 = attributesXML.getChildElements();
                while (itr2.hasNext()) {
                    OMElement attributeXML = (OMElement)itr2.next();
                    if (!attribute.getId().equals(attributeXML.getAttributeValue(new QName(ATTRIBUTE_ID)))) continue;
                    OMElement attributeValueXML = factory.createOMElement("AttributeValue", null);
                    attributeValueXML.addAttribute("DataType", XMLSCHEMA + attribute.getType(), null);
                    attributeValueXML.setText(attribute.getValue());
                    attributeXML.addChild((OMNode)attributeValueXML);
                    continue block2;
                }
                break block4;
            }
        }
        return requestXML.toString();
    }
}

