/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.proxy.AbstractEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.exception.EntitlementProxyException;
import org.wso2.carbon.identity.entitlement.proxy.soap.authenticationAdmin.SOAPEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.soap.basicAuth.BasicAuthEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.thrift.ThriftEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.wsxacml.WSXACMLEntitlementServiceClient;

public class PEPProxyFactory {
    private static final Log log = LogFactory.getLog(PEPProxyFactory.class);
    public static final String USER_NAME = "userName";
    public static final String PASSWORD = "password";
    public static final String REUSE_SESSION = "reuseSession";
    public static final String SERVER_URL = "serverUrl";
    public static final String THRIFT_HOST = "thriftHost";
    public static final String THRIFT_PORT = "thriftPort";
    public static final String AUTHORIZED_COOKIE = "authorizedCookie";

    private PEPProxyFactory() {
    }

    public static Map<String, AbstractEntitlementServiceClient> getAppToPDPClientMap(Map<String, Map<String, String>> appToPDPClientConfigMap) throws EntitlementProxyException {
        HashMap<String, AbstractEntitlementServiceClient> appToPDPClientMap = new HashMap<String, AbstractEntitlementServiceClient>();
        Set<String> appList = appToPDPClientConfigMap.keySet();
        for (String appId : appList) {
            String serverUrl;
            Map<String, String> appConfig = appToPDPClientConfigMap.get(appId);
            String client = appConfig.get("client");
            if (client == null || client.trim().length() == 0) {
                log.debug((Object)"Using BasicAuthEntitlementServiceClient by default");
                client = "basicAuth";
            }
            if (!("json".equals(client) || "soap".equals(client) || "thrift".equals(client) || "basicAuth".equals(client) || "wsXacml".equals(client))) {
                throw new EntitlementProxyException("Invalid client. Should be json, soap, thrift or wsXacml");
            }
            if ("soap".equals(client)) {
                if (appConfig.get(SERVER_URL) == null || appConfig.get(SERVER_URL).length() == 0) {
                    throw new EntitlementProxyException("serverUrl cannot be null or empty");
                }
                serverUrl = appConfig.get(SERVER_URL).trim();
                if (!serverUrl.endsWith("/")) {
                    serverUrl = serverUrl + "/";
                }
                boolean reuseSession = true;
                if (appConfig.get(REUSE_SESSION) != null) {
                    reuseSession = Boolean.parseBoolean(appConfig.get(REUSE_SESSION));
                }
                if (StringUtils.isNotEmpty((String)appConfig.get(AUTHORIZED_COOKIE))) {
                    appToPDPClientMap.put(appId, new SOAPEntitlementServiceClient(serverUrl, appConfig.get(AUTHORIZED_COOKIE), reuseSession));
                    continue;
                }
                if (StringUtils.isNotEmpty((String)appConfig.get(USER_NAME)) && StringUtils.isNotEmpty((String)appConfig.get(PASSWORD))) {
                    appToPDPClientMap.put(appId, new SOAPEntitlementServiceClient(serverUrl, appConfig.get(USER_NAME), appConfig.get(PASSWORD), reuseSession));
                    continue;
                }
                throw new EntitlementProxyException("Authentication failed. Either authorized cookie or username/password required to proceed.");
            }
            if ("basicAuth".equals(client)) {
                if (appConfig.get(SERVER_URL) == null || appConfig.get(SERVER_URL).length() == 0) {
                    throw new EntitlementProxyException("serverUrl cannot be null or empty");
                }
                serverUrl = appConfig.get(SERVER_URL).trim();
                if (!serverUrl.endsWith("/")) {
                    serverUrl = serverUrl + "/";
                }
                if (appConfig.get(USER_NAME) == null || appConfig.get(USER_NAME).length() == 0) {
                    throw new EntitlementProxyException("userName cannot be null or empty");
                }
                if (appConfig.get(PASSWORD) == null || appConfig.get(PASSWORD).length() == 0) {
                    throw new EntitlementProxyException("password cannot be null or empty");
                }
                appToPDPClientMap.put(appId, new BasicAuthEntitlementServiceClient(serverUrl, appConfig.get(USER_NAME), appConfig.get(PASSWORD)));
                continue;
            }
            if ("thrift".equals(client)) {
                if (appConfig.get(SERVER_URL) == null || appConfig.get(SERVER_URL).length() == 0) {
                    throw new EntitlementProxyException("serverUrl cannot be null or empty");
                }
                serverUrl = appConfig.get(SERVER_URL).trim();
                if (!serverUrl.endsWith("/")) {
                    serverUrl = serverUrl + "/";
                }
                if (appConfig.get(USER_NAME) == null || appConfig.get(USER_NAME).length() == 0) {
                    throw new EntitlementProxyException("userName cannot be null or empty");
                }
                if (appConfig.get(PASSWORD) == null || appConfig.get(PASSWORD).length() == 0) {
                    throw new EntitlementProxyException("password cannot be null or empty");
                }
                if (appConfig.get(THRIFT_HOST) == null || appConfig.get(THRIFT_HOST).length() == 0) {
                    throw new EntitlementProxyException("thriftHost cannot be null or empty");
                }
                int thriftPort = appConfig.get(THRIFT_PORT) == null || appConfig.get(THRIFT_PORT).length() == 0 ? 10500 : Integer.parseInt(appConfig.get(THRIFT_PORT));
                boolean reuseSession = true;
                if (appConfig.get(REUSE_SESSION) != null) {
                    reuseSession = Boolean.parseBoolean(appConfig.get(REUSE_SESSION));
                }
                appToPDPClientMap.put(appId, new ThriftEntitlementServiceClient(serverUrl, appConfig.get(USER_NAME), appConfig.get(PASSWORD), appConfig.get(THRIFT_HOST), thriftPort, reuseSession));
                continue;
            }
            if (!"wsXacml".equals(client)) continue;
            if (appConfig.get(SERVER_URL) == null || appConfig.get(SERVER_URL).length() == 0) {
                throw new EntitlementProxyException("serverUrl cannot be null or empty");
            }
            serverUrl = appConfig.get(SERVER_URL).trim();
            if (!serverUrl.endsWith("/")) {
                serverUrl = serverUrl + "/";
            }
            if (appConfig.get(USER_NAME) == null || appConfig.get(USER_NAME).length() == 0) {
                throw new EntitlementProxyException("userName cannot be null or empty");
            }
            if (appConfig.get(PASSWORD) == null || appConfig.get(PASSWORD).length() == 0) {
                throw new EntitlementProxyException("password cannot be null or empty");
            }
            appToPDPClientMap.put(appId, new WSXACMLEntitlementServiceClient(serverUrl, appConfig.get(USER_NAME), appConfig.get(PASSWORD)));
        }
        return appToPDPClientMap;
    }
}

