/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy;

import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.wso2.carbon.identity.entitlement.proxy.IdentityCacheEntry;
import org.wso2.carbon.identity.entitlement.proxy.IdentityCacheKey;

class PEPProxyCache {
    private SimpleCache<String, EntitlementDecision> simpleCache;
    private boolean isCarbonCache = false;
    private int invalidationInterval = 0;

    PEPProxyCache(String enableCaching, int invalidationInterval, int maxEntries) {
        if ("simple".equalsIgnoreCase(enableCaching)) {
            this.simpleCache = new SimpleCache(maxEntries);
            this.invalidationInterval = invalidationInterval;
        } else if ("carbon".equalsIgnoreCase(enableCaching)) {
            this.isCarbonCache = true;
        }
    }

    private Cache<IdentityCacheKey, IdentityCacheEntry> getCommonCache() {
        CacheManager manager = Caching.getCacheManagerFactory().getCacheManager("DECISION_CACHE");
        return manager.getCache("DECISION_CACHE");
    }

    void put(String key, String entry) {
        Cache<IdentityCacheKey, IdentityCacheEntry> carbonCache;
        if (this.simpleCache != null) {
            EntitlementDecision entitlementDecision = new EntitlementDecision(entry, Calendar.getInstance().getTimeInMillis());
            this.simpleCache.put(key, entitlementDecision);
        } else if (this.isCarbonCache && (carbonCache = this.getCommonCache()) != null) {
            IdentityCacheKey identityKey = new IdentityCacheKey(key);
            IdentityCacheEntry identityEntry = new IdentityCacheEntry(entry);
            carbonCache.put((Object)identityKey, (Object)identityEntry);
        }
    }

    String get(String key) {
        IdentityCacheKey identityKey;
        IdentityCacheEntry identityCacheEntry;
        Cache<IdentityCacheKey, IdentityCacheEntry> carbonCache;
        if (this.simpleCache != null) {
            EntitlementDecision entitlementDecision = (EntitlementDecision)this.simpleCache.get(key);
            if (entitlementDecision != null && entitlementDecision.getCachedTime() + (long)this.invalidationInterval > Calendar.getInstance().getTimeInMillis()) {
                return entitlementDecision.getResponse();
            }
        } else if (this.isCarbonCache && (carbonCache = this.getCommonCache()) != null && (identityCacheEntry = (IdentityCacheEntry)carbonCache.get((Object)(identityKey = new IdentityCacheKey(key)))) != null) {
            return identityCacheEntry.getCacheEntry();
        }
        return null;
    }

    void clear() {
        Cache<IdentityCacheKey, IdentityCacheEntry> carbonCache;
        if (this.simpleCache != null) {
            this.simpleCache = new SimpleCache(((SimpleCache)this.simpleCache).maxEntries);
        } else if (this.isCarbonCache && (carbonCache = this.getCommonCache()) != null) {
            carbonCache.removeAll();
        }
    }

    private class EntitlementDecision {
        private String response;
        private long cachedTime;

        EntitlementDecision(String response, long cachedTime) {
            this.response = response;
            this.cachedTime = cachedTime;
        }

        public String getResponse() {
            return this.response;
        }

        public long getCachedTime() {
            return this.cachedTime;
        }
    }

    private class SimpleCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -6958380913702000534L;
        private int maxEntries;

        public SimpleCache(int maxEntries) {
            super(maxEntries + 1, 1.0f, false);
            this.maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxEntries;
        }
    }
}

