/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.identity.entitlement.proxy.AbstractEntitlementServiceClient;
import org.wso2.carbon.identity.entitlement.proxy.Attribute;
import org.wso2.carbon.identity.entitlement.proxy.PEPProxyCache;
import org.wso2.carbon.identity.entitlement.proxy.PEPProxyConfig;
import org.wso2.carbon.identity.entitlement.proxy.PEPProxyFactory;
import org.wso2.carbon.identity.entitlement.proxy.exception.EntitlementProxyException;

public class PEPProxy {
    public static final String SIMPLE = "simple";
    public static final String CARBON = "carbon";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_CATEGORY_ACCESS_SUBJECT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_SUBJECT_ID = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
    public static final String URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ACTION = "urn:oasis:names:tc:xacml:3.0:attribute-category:action";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_ACTION_ACTION_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
    public static final String URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_RESOURCE = "urn:oasis:names:tc:xacml:3.0:attribute-category:resource";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_RESOURCE_RESOURCE_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";
    public static final String URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ENVIRONMENT = "urn:oasis:names:tc:xacml:3.0:attribute-category:environment";
    public static final String URN_OASIS_NAMES_TC_XACML_1_0_ENVIRONMENT_ENVIRONMENT_ID = "urn:oasis:names:tc:xacml:1.0:environment:environment-id";
    private String defaultAppId;
    private Map<String, AbstractEntitlementServiceClient> appToPDPClientMap;
    private PEPProxyCache cache;

    public PEPProxy(PEPProxyConfig config) throws EntitlementProxyException {
        this.defaultAppId = config.getDefaultAppId();
        if (config.getCacheType() != null && (SIMPLE.equals(config.getCacheType()) || CARBON.equals(config.getCacheType()))) {
            this.cache = new PEPProxyCache(config.getCacheType(), config.getInvalidationInterval(), config.getMaxCacheEntries());
        }
        this.appToPDPClientMap = PEPProxyFactory.getAppToPDPClientMap(config.getAppToPDPClientConfigMap());
    }

    public String getDecision(Attribute[] attributes) throws Exception {
        return this.getDecision(attributes, this.defaultAppId);
    }

    public String getDecision(Attribute[] attributes, String appId) throws Exception {
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        AbstractEntitlementServiceClient appProxy = this.appToPDPClientMap.get(appId);
        if (this.cache != null) {
            String key = this.generateKey(attributes);
            String decision = this.cache.get(key);
            if (decision != null) {
                return decision;
            }
            decision = appProxy.getDecision(attributes, appId);
            this.cache.put(key, decision);
            return decision;
        }
        return appProxy.getDecision(attributes, appId);
    }

    public String getDecision(String subject, String resource, String action, String environment) throws Exception {
        return this.getDecision(subject, resource, action, environment, this.defaultAppId);
    }

    public String getDecision(String subject, String resource, String action, String environment, String appId) throws Exception {
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        Attribute subjectAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_CATEGORY_ACCESS_SUBJECT, URN_OASIS_NAMES_TC_XACML_1_0_SUBJECT_SUBJECT_ID, "string", subject);
        Attribute actionAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ACTION, URN_OASIS_NAMES_TC_XACML_1_0_ACTION_ACTION_ID, "string", action);
        Attribute resourceAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_RESOURCE, URN_OASIS_NAMES_TC_XACML_1_0_RESOURCE_RESOURCE_ID, "string", resource);
        Attribute environmentAttribute = new Attribute(URN_OASIS_NAMES_TC_XACML_3_0_ATTRIBUTE_CATEGORY_ENVIRONMENT, URN_OASIS_NAMES_TC_XACML_1_0_ENVIRONMENT_ENVIRONMENT_ID, "string", environment);
        Attribute[] tempArr = new Attribute[]{subjectAttribute, actionAttribute, resourceAttribute, environmentAttribute};
        return this.getDecision(tempArr, appId);
    }

    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, String domainId) throws Exception {
        return this.subjectCanActOnResource(subjectType, alias, actionId, resourceId, domainId, this.defaultAppId);
    }

    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, String domainId, String appId) throws Exception {
        AbstractEntitlementServiceClient appProxy = null;
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        appProxy = this.appToPDPClientMap.get(appId);
        return appProxy.subjectCanActOnResource(subjectType, alias, actionId, resourceId, domainId, appId);
    }

    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, Attribute[] attributes, String domainId) throws Exception {
        return this.subjectCanActOnResource(subjectType, alias, actionId, resourceId, attributes, domainId, this.defaultAppId);
    }

    public boolean subjectCanActOnResource(String subjectType, String alias, String actionId, String resourceId, Attribute[] attributes, String domainId, String appId) throws Exception {
        AbstractEntitlementServiceClient appProxy = null;
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        appProxy = this.appToPDPClientMap.get(appId);
        return appProxy.subjectCanActOnResource(subjectType, alias, actionId, resourceId, attributes, domainId, appId);
    }

    public List<String> getActionableChildResourcesForAlias(String alias, String parentResource, String action) throws Exception {
        return this.getActionableChildResourcesForAlias(alias, parentResource, action, this.defaultAppId);
    }

    public List<String> getActionableChildResourcesForAlias(String alias, String parentResource, String action, String appId) throws Exception {
        AbstractEntitlementServiceClient appProxy = null;
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        appProxy = this.appToPDPClientMap.get(appId);
        return appProxy.getActionableChildResourcesForAlias(alias, parentResource, action, appId);
    }

    public List<String> getResourcesForAlias(String alias) throws Exception {
        return this.getResourcesForAlias(alias, this.defaultAppId);
    }

    public List<String> getResourcesForAlias(String alias, String appId) throws Exception {
        AbstractEntitlementServiceClient appProxy = null;
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        appProxy = this.appToPDPClientMap.get(appId);
        return appProxy.getResourcesForAlias(alias, appId);
    }

    public List<String> getActionableResourcesForAlias(String alias) throws Exception {
        return this.getActionableResourcesForAlias(alias, this.defaultAppId);
    }

    public List<String> getActionableResourcesForAlias(String alias, String appId) throws Exception {
        AbstractEntitlementServiceClient appProxy = null;
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        appProxy = this.appToPDPClientMap.get(appId);
        return appProxy.getActionableResourcesForAlias(alias, appId);
    }

    public List<String> getActionsForResource(String alias, String resources) throws Exception {
        return this.getActionsForResource(alias, resources, this.defaultAppId);
    }

    public List<String> getActionsForResource(String alias, String resources, String appId) throws Exception {
        AbstractEntitlementServiceClient appProxy = null;
        if (!this.appToPDPClientMap.containsKey(appId)) {
            throw new EntitlementProxyException("Invalid App Id");
        }
        appProxy = this.appToPDPClientMap.get(appId);
        return appProxy.getActionsForResource(alias, resources, appId);
    }

    private String generateKey(Attribute[] attributes) {
        int key = 1;
        key = 11 * key + (attributes == null ? 0 : Arrays.hashCode(attributes));
        key = 31 * key + (this.defaultAppId == null ? 0 : this.defaultAppId.hashCode());
        return Integer.toString(key);
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }
}

