/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.proxy;

import java.io.Serializable;
import java.security.Key;
import java.util.Arrays;
import java.util.Date;

public class IdentityCacheEntry
implements Serializable {
    private static final long serialVersionUID = 7239122598310553180L;
    private String cacheEntry;
    private String[] cacheEntryArray;
    private int hashEntry;
    private long cacheInterval;
    private boolean cacheClearing;
    private Key secretKey;
    private Date date;

    public IdentityCacheEntry(String cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    public IdentityCacheEntry(int hashEntry) {
        this.hashEntry = hashEntry;
    }

    public IdentityCacheEntry(boolean cacheClearing) {
        this.cacheClearing = cacheClearing;
    }

    public IdentityCacheEntry(String cacheEntry, long cacheInterval) {
        this.cacheEntry = cacheEntry;
        this.cacheInterval = cacheInterval;
    }

    public IdentityCacheEntry(String[] cacheEntryArray) {
        this.cacheEntryArray = Arrays.copyOf(cacheEntryArray, cacheEntryArray.length);
    }

    public IdentityCacheEntry(String cacheEntry, Key secretKey, Date date) {
        this.cacheEntry = cacheEntry;
        this.secretKey = secretKey;
        if (date != null) {
            this.date = new Date(date.getTime());
        }
    }

    public String getCacheEntry() {
        return this.cacheEntry;
    }

    public int getHashEntry() {
        return this.hashEntry;
    }

    public long getCacheInterval() {
        return this.cacheInterval;
    }

    public boolean isCacheClearing() {
        return this.cacheClearing;
    }

    public String[] getCacheEntryArray() {
        if (this.cacheEntryArray != null) {
            return (String[])this.cacheEntryArray.clone();
        }
        return new String[0];
    }

    public Key getSecretKey() {
        return this.secretKey;
    }

    public Date getDate() {
        if (this.date != null) {
            return new Date(this.date.getTime());
        }
        return null;
    }
}

