/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.ui.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.ui.UIAdaptorException;
import org.wso2.carbon.event.output.adapter.ui.UIEventAdapterFactory;
import org.wso2.carbon.event.output.adapter.ui.UIOutputAuthorizationService;
import org.wso2.carbon.event.output.adapter.ui.UIOutputCallbackControllerService;
import org.wso2.carbon.event.output.adapter.ui.internal.DefaultUIOutputAuthorizationServiceImpl;
import org.wso2.carbon.event.output.adapter.ui.internal.UIOutputCallbackControllerServiceImpl;
import org.wso2.carbon.event.output.adapter.ui.internal.ds.UIEventAdaptorServiceInternalValueHolder;
import org.wso2.carbon.event.stream.core.EventStreamService;

@Component(name="output.Ui.AdapterService.component", immediate=true)
public class UILocalEventAdapterDS {
    private static final Log log = LogFactory.getLog(UILocalEventAdapterDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            UIEventAdapterFactory uiEventAdapterFactory = new UIEventAdapterFactory();
            context.getBundleContext().registerService(OutputEventAdapterFactory.class.getName(), (Object)uiEventAdapterFactory, null);
            UIOutputCallbackControllerServiceImpl UIOutputCallbackRegisterServiceImpl = new UIOutputCallbackControllerServiceImpl();
            context.getBundleContext().registerService(UIOutputCallbackControllerService.class.getName(), (Object)UIOutputCallbackRegisterServiceImpl, null);
            UIEventAdaptorServiceInternalValueHolder.registerUIOutputCallbackRegisterServiceInternal(UIOutputCallbackRegisterServiceImpl);
            context.getBundleContext().registerService(UIOutputAuthorizationService.class.getName(), (Object)new DefaultUIOutputAuthorizationServiceImpl(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully deployed the output ui adapter service");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create the output ui adapter service ", (Throwable)e);
        }
    }

    @Reference(name="ui.event.adapter.externsion", service=UIOutputAuthorizationService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUIOutputAuthorizationService")
    protected void setUIOutputAuthorizationService(UIOutputAuthorizationService authorizationService) {
        try {
            UIEventAdaptorServiceInternalValueHolder.registerAuthorizationService(authorizationService);
        }
        catch (UIAdaptorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void unsetUIOutputAuthorizationService(UIOutputAuthorizationService authorizationService) {
        UIEventAdaptorServiceInternalValueHolder.unresgiterAuthorizationService(authorizationService.getAuthorizationServiceName());
    }

    @Reference(name="eventStreamManager.service", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        UIEventAdaptorServiceInternalValueHolder.setEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        UIEventAdaptorServiceInternalValueHolder.setEventStreamService(null);
    }
}

