/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.ui.internal;

import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.ui.SessionHolder;
import org.wso2.carbon.event.output.adapter.ui.UIOutputCallbackControllerService;
import org.wso2.carbon.event.output.adapter.ui.internal.ds.UIEventAdaptorServiceInternalValueHolder;

public class UIOutputCallbackControllerServiceImpl
implements UIOutputCallbackControllerService {
    private ConcurrentHashMap<Integer, ConcurrentHashMap<String, CopyOnWriteArrayList<SessionHolder>>> outputEventAdaptorSessionMap = new ConcurrentHashMap();

    @Override
    public void subscribeWebsocket(String streamName, String version, SessionHolder session) {
        CopyOnWriteArrayList<SessionHolder> adapterSpecificSessions;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (version == null || " ".equals(version)) {
            version = "1.0.0";
        }
        String streamId = streamName + ":" + version;
        ConcurrentHashMap<String, CopyOnWriteArrayList<SessionHolder>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap == null) {
            tenantSpecificAdaptorMap = new ConcurrentHashMap();
            if (null != this.outputEventAdaptorSessionMap.putIfAbsent(tenantId, tenantSpecificAdaptorMap)) {
                tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
            }
        }
        if ((adapterSpecificSessions = tenantSpecificAdaptorMap.get(streamId)) == null && null != tenantSpecificAdaptorMap.putIfAbsent(streamId, adapterSpecificSessions = new CopyOnWriteArrayList())) {
            adapterSpecificSessions = tenantSpecificAdaptorMap.get(streamId);
        }
        adapterSpecificSessions.add(session);
    }

    public CopyOnWriteArrayList<SessionHolder> getSessions(int tenantId, String streamId) {
        ConcurrentHashMap<String, CopyOnWriteArrayList<SessionHolder>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap != null) {
            return tenantSpecificAdaptorMap.get(streamId);
        }
        return null;
    }

    public LinkedBlockingDeque<Object> getEvents(int tenanId, String streamName, String version) {
        ConcurrentHashMap<String, LinkedBlockingDeque<Object>> tenantSpecificStreamMap = UIEventAdaptorServiceInternalValueHolder.getTenantSpecificStreamEventMap().get(tenanId);
        if (tenantSpecificStreamMap != null) {
            String streamId = streamName + ":" + version;
            return tenantSpecificStreamMap.get(streamId);
        }
        return null;
    }

    @Override
    public void unsubscribeWebsocket(String streamName, String version, String sessionId) {
        CopyOnWriteArrayList<SessionHolder> adapterSpecificSessions;
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (version == null || " ".equals(version)) {
            version = "1.0.0";
        }
        String id = streamName + ":" + version;
        ConcurrentHashMap<String, CopyOnWriteArrayList<SessionHolder>> tenantSpecificAdaptorMap = this.outputEventAdaptorSessionMap.get(tenantId);
        if (tenantSpecificAdaptorMap != null && (adapterSpecificSessions = tenantSpecificAdaptorMap.get(id)) != null) {
            SessionHolder sessionToRemove = null;
            for (SessionHolder thisSession : adapterSpecificSessions) {
                if (!sessionId.equals(thisSession.getId())) continue;
                sessionToRemove = thisSession;
                break;
            }
            if (sessionToRemove != null) {
                adapterSpecificSessions.remove(sessionToRemove);
            }
        }
    }

    @Override
    public JsonObject retrieveEvents(String streamName, String version, String lastUpdatedTime) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        LinkedBlockingDeque<Object> allEvents = this.getEvents(tenantId, streamName, version);
        if (allEvents != null) {
            JsonObject eventsData = new JsonObject();
            Boolean firstFilteredValue = true;
            long sentTimeStamp = Long.parseLong(lastUpdatedTime);
            StringBuilder allEventsAsString = new StringBuilder("[");
            Iterator<Object> iterator = allEvents.descendingIterator();
            while (iterator.hasNext()) {
                Object[] eventValues = (Object[])iterator.next();
                long eventTimeStamp = (Long)eventValues[1];
                if (sentTimeStamp >= eventTimeStamp) continue;
                if (!firstFilteredValue.booleanValue()) {
                    allEventsAsString.append(",");
                }
                firstFilteredValue = false;
                String eventString = (String)eventValues[0];
                allEventsAsString.append(eventString);
            }
            allEventsAsString.append("]");
            if (allEvents.size() != 0) {
                Object[] lastObj = (Object[])allEvents.getLast();
                Object lastEventTime = lastObj[1];
                eventsData.addProperty("lastEventTime", String.valueOf(lastEventTime));
            }
            eventsData.addProperty("events", allEventsAsString.toString());
            return eventsData;
        }
        return null;
    }
}

