/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.ui;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.event.output.adapter.core.EventAdapterUtil;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapter;
import org.wso2.carbon.event.output.adapter.core.OutputEventAdapterConfiguration;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterException;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.output.adapter.ui.SessionHolder;
import org.wso2.carbon.event.output.adapter.ui.UIAdaptorException;
import org.wso2.carbon.event.output.adapter.ui.UIOutputAuthorizationService;
import org.wso2.carbon.event.output.adapter.ui.internal.UIOutputCallbackControllerServiceImpl;
import org.wso2.carbon.event.output.adapter.ui.internal.ds.UIEventAdaptorServiceInternalValueHolder;

public class UIEventAdapter
implements OutputEventAdapter {
    private static final Log log = LogFactory.getLog(UIEventAdapter.class);
    private OutputEventAdapterConfiguration eventAdapterConfiguration;
    private Map<String, String> globalProperties;
    private String streamId;
    private UIOutputAuthorizationService authorizationService;
    private int queueSize;
    private LinkedBlockingDeque<Object> streamSpecificEvents;
    private static ThreadPoolExecutor executorService;
    private int tenantId;
    private boolean doLogDroppedMessage;

    public UIEventAdapter(OutputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.doLogDroppedMessage = true;
    }

    public void init() throws OutputEventAdapterException {
        String adapterName;
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (executorService == null) {
            int minThread = this.globalProperties.get("minThread") != null ? Integer.parseInt(this.globalProperties.get("minThread")) : 8;
            int maxThread = this.globalProperties.get("maxThread") != null ? Integer.parseInt(this.globalProperties.get("maxThread")) : 100;
            long defaultKeepAliveTime = this.globalProperties.get("keepAliveTimeInMillis") != null ? (long)Integer.parseInt(this.globalProperties.get("keepAliveTimeInMillis")) : 20000L;
            int jobQueSize = this.globalProperties.get("jobQueueSize") != null ? Integer.parseInt(this.globalProperties.get("jobQueueSize")) : 2000;
            executorService = new ThreadPoolExecutor(minThread, maxThread, defaultKeepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(jobQueSize));
        }
        this.streamId = this.eventAdapterConfiguration.getOutputStreamIdOfWso2eventMessageFormat();
        if (this.streamId == null || this.streamId.isEmpty()) {
            throw new OutputEventAdapterRuntimeException("UI event adapter needs a output stream id");
        }
        ConcurrentHashMap<Integer, ConcurrentHashMap<String, String>> tenantSpecifcEventOutputAdapterMap = UIEventAdaptorServiceInternalValueHolder.getTenantSpecificOutputEventStreamAdapterMap();
        ConcurrentHashMap<String, String> streamSpecifAdapterMap = tenantSpecifcEventOutputAdapterMap.get(this.tenantId);
        if (streamSpecifAdapterMap == null) {
            streamSpecifAdapterMap = new ConcurrentHashMap();
            if (null != tenantSpecifcEventOutputAdapterMap.putIfAbsent(this.tenantId, streamSpecifAdapterMap)) {
                streamSpecifAdapterMap = tenantSpecifcEventOutputAdapterMap.get(this.tenantId);
            }
        }
        if ((adapterName = streamSpecifAdapterMap.get(this.streamId)) != null) {
            throw new OutputEventAdapterException("An Output ui event adapter \"" + adapterName + "\" is already exist for stream id \"" + this.streamId + "\"");
        }
        streamSpecifAdapterMap.put(this.streamId, this.eventAdapterConfiguration.getName());
        ConcurrentHashMap<Integer, ConcurrentHashMap<String, LinkedBlockingDeque<Object>>> tenantSpecificStreamMap = UIEventAdaptorServiceInternalValueHolder.getTenantSpecificStreamEventMap();
        ConcurrentHashMap<String, LinkedBlockingDeque<Object>> streamSpecificEventsMap = tenantSpecificStreamMap.get(this.tenantId);
        if (streamSpecificEventsMap == null) {
            streamSpecificEventsMap = new ConcurrentHashMap();
            if (null != tenantSpecificStreamMap.putIfAbsent(this.tenantId, streamSpecificEventsMap)) {
                streamSpecificEventsMap = tenantSpecificStreamMap.get(this.tenantId);
            }
        }
        this.streamSpecificEvents = streamSpecificEventsMap.get(this.streamId);
        if (this.streamSpecificEvents == null) {
            this.streamSpecificEvents = new LinkedBlockingDeque();
            if (null != streamSpecificEventsMap.putIfAbsent(this.streamId, this.streamSpecificEvents)) {
                this.streamSpecificEvents = streamSpecificEventsMap.get(this.streamId);
            }
        }
        if (this.globalProperties.get("eventQueueSize") != null) {
            try {
                this.queueSize = Integer.parseInt(this.globalProperties.get("eventQueueSize"));
            }
            catch (NumberFormatException e) {
                log.error((Object)("String does not have the appropriate format for conversion." + e.getMessage()));
                this.queueSize = 30;
            }
        } else {
            this.queueSize = 30;
        }
        this.authorizationService = UIEventAdaptorServiceInternalValueHolder.getAuthorizationService(null);
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        throw new TestConnectionNotSupportedException("Test connection is not available");
    }

    public void connect() {
    }

    public void publish(Object message, Map<String, String> dynamicProperties) {
        int i;
        Event event = (Event)message;
        StringBuilder eventBuilder = new StringBuilder("[");
        if (this.streamSpecificEvents.size() == this.queueSize) {
            this.streamSpecificEvents.removeFirst();
        }
        eventBuilder.append(event.getTimeStamp());
        if (event.getMetaData() != null) {
            eventBuilder.append(",");
            Object[] metaData = event.getMetaData();
            for (i = 0; i < metaData.length; ++i) {
                eventBuilder.append("\"");
                eventBuilder.append(metaData[i]);
                eventBuilder.append("\"");
                if (i == metaData.length - 1) continue;
                eventBuilder.append(",");
            }
        }
        if (event.getCorrelationData() != null) {
            Object[] correlationData = event.getCorrelationData();
            eventBuilder.append(",");
            for (i = 0; i < correlationData.length; ++i) {
                eventBuilder.append("\"");
                eventBuilder.append(correlationData[i]);
                eventBuilder.append("\"");
                if (i == correlationData.length - 1) continue;
                eventBuilder.append(",");
            }
        }
        if (event.getPayloadData() != null) {
            Object[] payloadData = event.getPayloadData();
            eventBuilder.append(",");
            for (i = 0; i < payloadData.length; ++i) {
                eventBuilder.append("\"");
                eventBuilder.append(payloadData[i]);
                eventBuilder.append("\"");
                if (i == payloadData.length - 1) continue;
                eventBuilder.append(",");
            }
        }
        eventBuilder.append("]");
        String eventString = eventBuilder.toString();
        Object[] eventValues = new Object[]{eventString, System.currentTimeMillis()};
        this.streamSpecificEvents.add(eventValues);
        try {
            executorService.execute(new WebSocketSender(eventString));
        }
        catch (RejectedExecutionException e) {
            EventAdapterUtil.logAndDrop((String)this.eventAdapterConfiguration.getName(), (Object)message, (String)"Job queue is full", (Throwable)e, (Log)log, (int)this.tenantId);
        }
    }

    public void disconnect() {
    }

    public void destroy() {
        ConcurrentHashMap<String, LinkedBlockingDeque<Object>> tenantSpecificStreamEventMap;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        ConcurrentHashMap<String, String> tenantSpecificAdapterMap = UIEventAdaptorServiceInternalValueHolder.getTenantSpecificOutputEventStreamAdapterMap().get(tenantId);
        if (tenantSpecificAdapterMap != null && this.streamId != null) {
            tenantSpecificAdapterMap.remove(this.streamId);
        }
        if ((tenantSpecificStreamEventMap = UIEventAdaptorServiceInternalValueHolder.getTenantSpecificStreamEventMap().get(tenantId)) != null && this.streamId != null) {
            tenantSpecificStreamEventMap.remove(this.streamId);
        }
    }

    public boolean isPolled() {
        return true;
    }

    private class WebSocketSender
    implements Runnable {
        private String message;

        public WebSocketSender(String message) {
            this.message = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UIOutputCallbackControllerServiceImpl uiOutputCallbackControllerServiceImpl = UIEventAdaptorServiceInternalValueHolder.getUIOutputCallbackRegisterServiceImpl();
            CopyOnWriteArrayList<SessionHolder> sessions = uiOutputCallbackControllerServiceImpl.getSessions(UIEventAdapter.this.tenantId, UIEventAdapter.this.streamId);
            if (sessions != null) {
                UIEventAdapter.this.doLogDroppedMessage = true;
                Iterator<SessionHolder> iterator = sessions.iterator();
                while (iterator.hasNext()) {
                    SessionHolder session;
                    SessionHolder sessionHolder = session = iterator.next();
                    synchronized (sessionHolder) {
                        try {
                            JSONArray eventJson = new JSONArray(this.message);
                            if (UIEventAdapter.this.authorizationService.authorizeSubscription(eventJson, session.getFilterProps(), session.getUsername(), session.getTenantId())) {
                                session.sendText(this.message);
                            }
                        }
                        catch (IOException | JSONException | UIAdaptorException e) {
                            EventAdapterUtil.logAndDrop((String)UIEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"Cannot send to endpoint", (Throwable)e, (Log)log, (int)UIEventAdapter.this.tenantId);
                        }
                    }
                }
            } else if (UIEventAdapter.this.doLogDroppedMessage) {
                EventAdapterUtil.logAndDrop((String)UIEventAdapter.this.eventAdapterConfiguration.getName(), (Object)this.message, (String)"No clients registered", (Log)log, (int)UIEventAdapter.this.tenantId);
                UIEventAdapter.this.doLogDroppedMessage = false;
            }
        }
    }
}

