/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.web.WebSocketHostObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.event.output.adapter.ui.JaggerySessionHolder;
import org.wso2.carbon.event.output.adapter.ui.internal.ds.UIEventAdaptorServiceInternalValueHolder;
import org.wso2.carbon.event.stream.core.exception.EventStreamConfigurationException;

public class JaggeryWebSocketHelper {
    private static final Log log = LogFactory.getLog(JaggeryWebSocketHelper.class);
    private static final String FILTER_PROP_NAME = "name";
    private static final String FILTER_PROP_VALUE = "value";
    private static final String CORRELATATION = "correlation_";
    private static final String META = "meta_";
    private static final String NULL = "null";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void subscribeWebSocket(String streamName, String streamVersion, String filterProps, String username, String sessionId, int tenantId, Object webSocketHostObject) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            StreamDefinition streamDefinition = UIEventAdaptorServiceInternalValueHolder.getEventStreamService().getStreamDefinition(streamName, streamVersion);
            if (!filterProps.equalsIgnoreCase(NULL)) {
                UIEventAdaptorServiceInternalValueHolder.getUIOutputCallbackRegisterServiceImpl().subscribeWebsocket(streamName, streamVersion, new JaggerySessionHolder(sessionId, JaggeryWebSocketHelper.getFilterProps(streamDefinition, new JSONArray(filterProps)), username, tenantId, (WebSocketHostObject)webSocketHostObject));
            } else {
                UIEventAdaptorServiceInternalValueHolder.getUIOutputCallbackRegisterServiceImpl().subscribeWebsocket(streamName, streamVersion, new JaggerySessionHolder(sessionId, JaggeryWebSocketHelper.getFilterProps(streamDefinition, null), username, tenantId, (WebSocketHostObject)webSocketHostObject));
            }
        }
        catch (JSONException | EventStreamConfigurationException e) {
            log.error((Object)e.getMessage(), e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private static Map<Integer, String> getFilterProps(StreamDefinition streamDefinition, JSONArray filterPropsJson) throws JSONException {
        HashMap<Integer, String> filterProps = new HashMap<Integer, String>();
        if (filterPropsJson != null) {
            int metaDataOffset;
            int correlationDataOffset = metaDataOffset = 1;
            if (streamDefinition.getMetaData() != null) {
                correlationDataOffset += streamDefinition.getMetaData().size();
            }
            int payloadDataOffset = correlationDataOffset;
            if (streamDefinition.getCorrelationData() != null) {
                payloadDataOffset += streamDefinition.getCorrelationData().size();
            }
            for (int i = 0; i < filterPropsJson.length(); ++i) {
                JSONObject aFilter = (JSONObject)filterPropsJson.get(i);
                String filterName = (String)aFilter.get(FILTER_PROP_NAME);
                String filterValue = (String)aFilter.get(FILTER_PROP_VALUE);
                if (filterName == null || filterName.trim().isEmpty() || filterValue == null || filterValue.trim().isEmpty()) continue;
                int index = -1;
                if (filterName.startsWith(META)) {
                    filterName = filterName.replace(META, "");
                    index = JaggeryWebSocketHelper.getIndexOf(streamDefinition.getMetaData(), filterName);
                    if (index != -1) {
                        filterProps.put(metaDataOffset + index, filterValue);
                        continue;
                    }
                    log.warn((Object)("Filter property - " + filterName + " doesn't exists in the stream  - " + streamDefinition.getStreamId() + ", hence ignoring the filter property"));
                    continue;
                }
                if (filterName.startsWith(CORRELATATION)) {
                    filterName = filterName.replace(CORRELATATION, "");
                    index = JaggeryWebSocketHelper.getIndexOf(streamDefinition.getCorrelationData(), filterName);
                    if (index != -1) {
                        filterProps.put(correlationDataOffset + index, filterValue);
                        continue;
                    }
                    log.warn((Object)("Filter property - " + filterName + " doesn't exists in the stream  - " + streamDefinition.getStreamId() + ", hence ignoring the filter property"));
                    continue;
                }
                index = JaggeryWebSocketHelper.getIndexOf(streamDefinition.getPayloadData(), filterName);
                if (index != -1) {
                    filterProps.put(payloadDataOffset + index, filterValue);
                    continue;
                }
                log.warn((Object)("Filter property - " + filterName + " doesn't exists in the stream  - " + streamDefinition.getStreamId() + ", hence ignoring the filter property"));
            }
        }
        return filterProps;
    }

    private static int getIndexOf(List<Attribute> streamAttributes, String attributeName) {
        if (streamAttributes != null) {
            for (int i = 0; i < streamAttributes.size(); ++i) {
                if (!streamAttributes.get(i).getName().equalsIgnoreCase(attributeName)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribeWebsocket(String streamName, String streamVersion, String sessionId, int tenantId) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId);
            UIEventAdaptorServiceInternalValueHolder.getUIOutputCallbackRegisterServiceImpl().unsubscribeWebsocket(streamName, streamVersion, sessionId);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

