/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authz.service.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.authz.service.AuthorizationManager;
import org.wso2.carbon.identity.authz.service.handler.AuthorizationHandler;
import org.wso2.carbon.identity.authz.service.handler.ResourceHandler;
import org.wso2.carbon.identity.authz.service.internal.AuthorizationServiceHolder;
import org.wso2.carbon.identity.core.handler.HandlerComparator;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.authz.service", immediate=true)
public class AuthorizationServiceComponent {
    private static final Log log = LogFactory.getLog(AuthorizationServiceComponent.class);

    @Activate
    protected void activate(ComponentContext cxt) {
        try {
            cxt.getBundleContext().registerService(AuthorizationManager.class, (Object)AuthorizationManager.getInstance(), null);
            cxt.getBundleContext().registerService(AuthorizationHandler.class, (Object)new AuthorizationHandler(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"AuthorizationServiceComponent is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthorizationServiceComponent bundle is deactivated");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService acquired");
        }
        AuthorizationServiceHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        this.setRealmService(null);
    }

    @Reference(name="org.wso2.carbon.identity.authz.handler.authz", service=AuthorizationHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthorizationHandler")
    protected void setAuthorizationHandler(AuthorizationHandler authorizationHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"AuthorizationHandler acquired");
        }
        List<AuthorizationHandler> authorizationHandlerList = AuthorizationServiceHolder.getInstance().getAuthorizationHandlerList();
        authorizationHandlerList.add(authorizationHandler);
        Collections.sort(authorizationHandlerList, new HandlerComparator());
    }

    protected void unsetAuthorizationHandler(AuthorizationHandler authorizationHandler) {
        List<AuthorizationHandler> authorizationHandlerList = AuthorizationServiceHolder.getInstance().getAuthorizationHandlerList();
        authorizationHandlerList.remove((Object)authorizationHandler);
    }

    @Reference(name="org.wso2.carbon.identity.authz.handler.resource", service=ResourceHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetResourceHandler")
    protected void setResourceHandler(ResourceHandler resourceHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ResourceHandler acquired");
        }
        List<ResourceHandler> resourceHandlerList = AuthorizationServiceHolder.getInstance().getResourceHandlerList();
        resourceHandlerList.add(resourceHandler);
        Collections.sort(resourceHandlerList, new HandlerComparator());
    }

    protected void unsetResourceHandler(ResourceHandler resourceHandler) {
        this.setResourceHandler(null);
    }
}

