/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authz.service.handler;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.authz.service.AuthorizationContext;
import org.wso2.carbon.identity.authz.service.AuthorizationResult;
import org.wso2.carbon.identity.authz.service.AuthorizationStatus;
import org.wso2.carbon.identity.authz.service.exception.AuthzServiceServerException;
import org.wso2.carbon.identity.authz.service.internal.AuthorizationServiceHolder;
import org.wso2.carbon.identity.core.handler.AbstractIdentityHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class AuthorizationHandler
extends AbstractIdentityHandler {
    private static final Log log = LogFactory.getLog(AuthorizationHandler.class);
    private static final String RESOURCE_PERMISSION_NONE = "none";

    public AuthorizationResult handleAuthorization(AuthorizationContext authorizationContext) throws AuthzServiceServerException {
        AuthorizationResult authorizationResult = new AuthorizationResult(AuthorizationStatus.DENY);
        try {
            User user = authorizationContext.getUser();
            String userDomain = user.getTenantDomain();
            int tenantId = IdentityTenantUtil.getTenantId((String)userDomain);
            String permissionString = authorizationContext.getPermissionString();
            String[] allowedScopes = authorizationContext.getParameter("oauth2-allowed-scopes") == null ? null : (String[])authorizationContext.getParameter("oauth2-allowed-scopes");
            boolean validateScope = authorizationContext.getParameter("oauth2-validate-scopes") == null ? false : (Boolean)authorizationContext.getParameter("oauth2-validate-scopes");
            RealmService realmService = AuthorizationServiceHolder.getInstance().getRealmService();
            UserRealm tenantUserRealm = realmService.getTenantUserRealm(tenantId);
            if (this.isScopeValidationRequired(authorizationContext, validateScope)) {
                this.validateScopes(authorizationContext, authorizationResult, allowedScopes);
            } else if (StringUtils.isNotBlank((CharSequence)permissionString) || authorizationContext.getRequiredScopes().size() == 0) {
                this.validatePermissions(authorizationResult, user, permissionString, tenantUserRealm);
            }
        }
        catch (UserStoreException e) {
            String errorMessage = "Error occurred while trying to authorize, " + e.getMessage();
            log.error((Object)errorMessage);
            throw new AuthzServiceServerException(errorMessage, e);
        }
        return authorizationResult;
    }

    public void init(InitConfig initConfig) {
    }

    public String getName() {
        return "AuthorizationHandler";
    }

    public int getPriority() {
        return 100;
    }

    private void validatePermissions(AuthorizationResult authorizationResult, User user, String permissionString, UserRealm tenantUserRealm) throws UserStoreException {
        if (RESOURCE_PERMISSION_NONE.equalsIgnoreCase(permissionString)) {
            authorizationResult.setAuthorizationStatus(AuthorizationStatus.GRANT);
            return;
        }
        AuthorizationManager authorizationManager = tenantUserRealm.getAuthorizationManager();
        boolean isUserAuthorized = authorizationManager.isUserAuthorized(UserCoreUtil.addDomainToName((String)user.getUserName(), (String)user.getUserStoreDomain()), permissionString, "ui.execute");
        if (isUserAuthorized) {
            authorizationResult.setAuthorizationStatus(AuthorizationStatus.GRANT);
        }
    }

    private void validateScopes(AuthorizationContext authorizationContext, AuthorizationResult authorizationResult, String[] allowedScopes) {
        boolean granted = true;
        if (allowedScopes != null) {
            for (String scope : authorizationContext.getRequiredScopes()) {
                if (ArrayUtils.contains((Object[])allowedScopes, (Object)scope)) continue;
                granted = false;
                break;
            }
            if (granted) {
                authorizationResult.setAuthorizationStatus(AuthorizationStatus.GRANT);
            }
        }
    }

    private boolean isScopeValidationRequired(AuthorizationContext authorizationContext, boolean validateScope) {
        return validateScope && CollectionUtils.isNotEmpty(authorizationContext.getRequiredScopes());
    }
}

