/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authz.service;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.auth.service.handler.HandlerManager;
import org.wso2.carbon.identity.authz.service.AuthorizationContext;
import org.wso2.carbon.identity.authz.service.AuthorizationResult;
import org.wso2.carbon.identity.authz.service.AuthorizationStatus;
import org.wso2.carbon.identity.authz.service.exception.AuthzServiceServerException;
import org.wso2.carbon.identity.authz.service.handler.AuthorizationHandler;
import org.wso2.carbon.identity.authz.service.handler.ResourceHandler;
import org.wso2.carbon.identity.authz.service.internal.AuthorizationServiceHolder;
import org.wso2.carbon.identity.core.handler.IdentityHandler;
import org.wso2.carbon.identity.core.handler.InitConfig;

public class AuthorizationManager
implements IdentityHandler {
    private static AuthorizationManager authorizationManager = new AuthorizationManager();

    private AuthorizationManager() {
    }

    public static AuthorizationManager getInstance() {
        return authorizationManager;
    }

    public AuthorizationResult authorize(AuthorizationContext authorizationContext) throws AuthzServiceServerException {
        AuthorizationResult authorizationResult = new AuthorizationResult(AuthorizationStatus.DENY);
        boolean isResourceHandlerAvailableToHandleAuthorization = false;
        if (StringUtils.isEmpty((String)authorizationContext.getPermissionString()) && authorizationContext.getRequiredScopes().size() == 0) {
            ResourceHandler externalResourceHandler;
            List<ResourceHandler> gettingExternalResourceHandlerList = AuthorizationServiceHolder.getInstance().getResourceHandlerList();
            List externalResourceHandlers = HandlerManager.getInstance().sortHandlers(gettingExternalResourceHandlerList, true);
            Iterator iterator = externalResourceHandlers.iterator();
            while (iterator.hasNext() && !(isResourceHandlerAvailableToHandleAuthorization = (externalResourceHandler = (ResourceHandler)iterator.next()).handleResource(authorizationContext))) {
            }
        } else {
            isResourceHandlerAvailableToHandleAuthorization = true;
        }
        if (isResourceHandlerAvailableToHandleAuthorization) {
            List<AuthorizationHandler> getAuthorizationHandlerList = AuthorizationServiceHolder.getInstance().getAuthorizationHandlerList();
            AuthorizationHandler authorizationHandler = (AuthorizationHandler)HandlerManager.getInstance().getFirstPriorityHandler(getAuthorizationHandlerList, true);
            authorizationResult = authorizationHandler.handleAuthorization(authorizationContext);
        } else {
            authorizationResult.setAuthorizationStatus(AuthorizationStatus.GRANT);
        }
        return authorizationResult;
    }

    public void init(InitConfig initConfig) {
    }

    public String getName() {
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public int getPriority() {
        return 0;
    }
}

