/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.consent.mgt.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.PIICategoryValidity;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.consent.mgt.core.model.PurposePIICategory;
import org.wso2.carbon.consent.mgt.core.model.ReceiptInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptPurposeInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptServiceInput;
import org.wso2.carbon.identity.consent.mgt.exceptions.ConsentUtilityServiceException;
import org.wso2.carbon.identity.consent.mgt.internal.IdentityConsentDataHolder;

public class ConsentUtilityService {
    private static final Log log = LogFactory.getLog(ConsentUtilityService.class);

    public void validateReceiptPIIs(ReceiptInput receiptInput, List<Purpose> purposes) throws ConsentUtilityServiceException {
        if (purposes == null || receiptInput == null) {
            throw new IllegalArgumentException("Receipt Input and purposes should not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Validating receipt against purposes.");
        }
        List services = receiptInput.getServices();
        for (Purpose purpose : purposes) {
            purpose = this.fillPurpose(purpose);
            boolean purposeConsented = false;
            Set<Integer> mandatoryPIIs = this.getMandatoryPIIs(purpose);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mandatory PIIs for purpose : " + purpose.getName() + " : " + Arrays.toString(mandatoryPIIs.toArray())));
            }
            for (ReceiptServiceInput service : services) {
                List consentPurposes = service.getPurposes();
                for (ReceiptPurposeInput consentPurpose : consentPurposes) {
                    if (!Objects.equals(consentPurpose.getPurposeId(), purpose.getId())) continue;
                    purposeConsented = true;
                    List pIICategories = consentPurpose.getPiiCategory();
                    Set<Integer> consentedPIIs = this.getPIIs(pIICategories);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Consented PIIs: " + Arrays.toString(consentedPIIs.toArray())));
                    }
                    if (consentedPIIs.containsAll(mandatoryPIIs)) continue;
                    throw new ConsentUtilityServiceException("One or more mandatory attributes are missing in the given receipt");
                }
                if (purposeConsented || mandatoryPIIs.isEmpty()) continue;
                throw new ConsentUtilityServiceException("Consent receipt does not contain consent for purpose " + purpose.getName() + " with ID: " + purpose.getId() + ", which has mandatory PIIs");
            }
        }
    }

    public Set<String> filterPIIsFromReceipt(Set<String> keySet, ReceiptInput receipt) throws ConsentUtilityServiceException {
        if (keySet == null || receipt == null) {
            throw new ConsentUtilityServiceException("Key set and receipt should not be null");
        }
        List services = receipt.getServices();
        HashSet<String> consentedPIIs = new HashSet<String>();
        for (ReceiptServiceInput service : services) {
            List purposes = service.getPurposes();
            for (ReceiptPurposeInput consentPurpose : purposes) {
                List piiCategories = consentPurpose.getPiiCategory();
                for (PIICategoryValidity piiCategory : piiCategories) {
                    consentedPIIs.add(this.getPIIName(consentPurpose.getPurposeId(), piiCategory.getId()));
                }
            }
        }
        keySet.retainAll(consentedPIIs);
        return keySet;
    }

    public Set<Integer> getMandatoryPIIs(List<Purpose> purposes) throws ConsentUtilityServiceException {
        if (purposes == null) {
            throw new ConsentUtilityServiceException("Purposes list should not be null");
        }
        HashSet<Integer> mandatoryPIIs = new HashSet<Integer>();
        for (Purpose purpose : purposes) {
            Set<Integer> mandatoryPurposePIIs = this.getMandatoryPIIs(purpose);
            mandatoryPIIs.addAll(mandatoryPurposePIIs);
        }
        return mandatoryPIIs;
    }

    public Set<Integer> getMandatoryPIIs(Purpose purpose) throws ConsentUtilityServiceException {
        if (purpose == null) {
            throw new ConsentUtilityServiceException("Purposes List should not be null");
        }
        HashSet<Integer> mandatoryPIIs = new HashSet<Integer>();
        purpose = this.fillPurpose(purpose);
        List purposePIICategories = purpose.getPurposePIICategories();
        for (PurposePIICategory purposePIICategory : purposePIICategories) {
            if (!purposePIICategory.getMandatory().booleanValue()) continue;
            mandatoryPIIs.add(purposePIICategory.getId());
        }
        return mandatoryPIIs;
    }

    public Set<Integer> getUniquePIIs(List<Purpose> purposes) throws ConsentUtilityServiceException {
        if (purposes == null) {
            throw new ConsentUtilityServiceException("Purposes List should not be null");
        }
        HashSet<Integer> uniquePIIs = new HashSet<Integer>();
        for (Purpose purpose : purposes) {
            Set<Integer> piis = this.getPIIs(purpose);
            uniquePIIs.addAll(piis);
        }
        return uniquePIIs;
    }

    public List<Purpose> getFilledPurposes(List<Purpose> purposes) throws ConsentUtilityServiceException {
        if (purposes == null) {
            throw new IllegalArgumentException("Purposes List should not be null");
        }
        ArrayList<Purpose> filledPurposes = new ArrayList<Purpose>();
        for (Purpose purpose : purposes) {
            filledPurposes.add(this.fillPurpose(purpose));
        }
        return filledPurposes;
    }

    private Set<Integer> getPIIs(Purpose purpose) throws ConsentUtilityServiceException {
        HashSet<Integer> uniquePIIs = new HashSet<Integer>();
        purpose = this.fillPurpose(purpose);
        List purposePIICategories = purpose.getPurposePIICategories();
        for (PurposePIICategory purposePIICategory : purposePIICategories) {
            uniquePIIs.add(purposePIICategory.getId());
        }
        return uniquePIIs;
    }

    private Purpose fillPurpose(Purpose purpose) throws ConsentUtilityServiceException {
        ConsentManager consentManager = IdentityConsentDataHolder.getInstance().getConsentManager();
        if (purpose.getPurposePIICategories() != null && purpose.getPurposePIICategories().isEmpty()) {
            try {
                purpose = consentManager.getPurpose(purpose.getId().intValue());
            }
            catch (ConsentManagementException e) {
                throw new ConsentUtilityServiceException("Error while retrieving purpose with purpose ID: " + purpose.getId(), e);
            }
        }
        return purpose;
    }

    private Set<Integer> getPIIs(List<PIICategoryValidity> piiCategoryValidities) {
        HashSet<Integer> piis = new HashSet<Integer>();
        for (PIICategoryValidity piiCategoryValidity : piiCategoryValidities) {
            piis.add(piiCategoryValidity.getId());
        }
        return piis;
    }

    private String getPIIName(int purposeId, int pIIId) throws ConsentUtilityServiceException {
        ConsentManager consentManager = IdentityConsentDataHolder.getInstance().getConsentManager();
        try {
            Purpose purpose = consentManager.getPurpose(purposeId);
            List purposePIICategories = purpose.getPurposePIICategories();
            for (PurposePIICategory purposePIICategory : purposePIICategories) {
                if (purposePIICategory.getId() != pIIId) continue;
                return purposePIICategory.getName();
            }
        }
        catch (ConsentManagementException e) {
            throw new ConsentUtilityServiceException("Error while retrieving purpose with id:" + purposeId, e);
        }
        throw new ConsentUtilityServiceException("No PII can be found within given id: " + pIIId + "for purpose :" + purposeId);
    }
}

