/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.consent.mgt.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.PrivilegedConsentManager;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.PurposeCategory;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.consent.mgt.internal.IdentityConsentDataHolder;
import org.wso2.carbon.identity.core.AbstractIdentityTenantMgtListener;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;

public class TenantConsentMgtListener
extends AbstractIdentityTenantMgtListener {
    private static final Log log = LogFactory.getLog(TenantConsentMgtListener.class);
    private static final String DEFAULT_PURPOSE_CATEGORY = "DEFAULT";

    public void onTenantCreate(TenantInfoBean tenantInfoBean) throws StratosException {
        if (this.isSsoConsentManagementEnabled()) {
            this.addDefaultPurposeCategory(tenantInfoBean);
        }
    }

    public void onPreDelete(int tenantId) throws StratosException {
        if (log.isDebugEnabled()) {
            log.info((Object)("Deleting all consents of the tenant: " + tenantId));
        }
        this.deleteAllConsents(tenantId);
    }

    protected void deleteAllConsents(int tenantId) throws StratosException {
        try {
            PrivilegedConsentManager privilegedConsentManager = IdentityConsentDataHolder.getInstance().getPrivilegedConsentManager();
            privilegedConsentManager.deletePurposeCategories(tenantId);
            privilegedConsentManager.deletePIICategories(tenantId);
            privilegedConsentManager.deletePurposes(tenantId);
            privilegedConsentManager.deleteReceipts(tenantId);
        }
        catch (ConsentManagementException e) {
            throw new StratosException("Error in deleting consents of tenant:" + tenantId, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDefaultPurposeCategory(TenantInfoBean tenantInfoBean) throws StratosException {
        FrameworkUtils.startTenantFlow((String)tenantInfoBean.getTenantDomain());
        try {
            PurposeCategory defaultPurposeCategory = new PurposeCategory(DEFAULT_PURPOSE_CATEGORY, "Core functionality");
            try {
                PurposeCategory purposeCategory = IdentityConsentDataHolder.getInstance().getConsentManager().addPurposeCategory(defaultPurposeCategory);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Added default purpose category for tenant: %s. Default purpose category id: %d", tenantInfoBean.getTenantDomain(), purposeCategory.getId()));
                }
            }
            catch (ConsentManagementException e) {
                throw new StratosException("Error while adding default purpose category for tenant:" + tenantInfoBean.getTenantDomain(), (Throwable)e);
            }
        }
        finally {
            FrameworkUtils.endTenantFlow();
        }
    }

    protected boolean isSsoConsentManagementEnabled() {
        return IdentityConsentDataHolder.getInstance().getSSOConsentService().isSSOConsentManagementEnabled(null);
    }
}

