/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.consent.mgt.listener;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.mgt.listener.AbstractApplicationMgtListener;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.consent.mgt.IdentityConsentMgtUtils;
import org.wso2.carbon.identity.consent.mgt.internal.IdentityConsentDataHolder;
import org.wso2.carbon.identity.core.model.IdentityEventListenerConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.core.util.LambdaExceptionUtils;

public class ConsentDeletionAppMgtListener
extends AbstractApplicationMgtListener {
    private static final Log log = LogFactory.getLog(ConsentDeletionAppMgtListener.class);
    private static final String CONSENT_SEARCH_LIMIT_PROPERTY = "Consent.Search.Limit";
    protected final Properties properties = new Properties();
    private static int consentSearchLimit = 100;

    public boolean isEnable() {
        boolean isListenerEnabledFromConfigs = super.isEnable();
        boolean isConsentEnabledSystemWide = IdentityConsentMgtUtils.isConsentEnabled();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Is listener enabled from configs: " + isListenerEnabledFromConfigs));
            log.debug((Object)("Is consent enabled system wide: " + isConsentEnabledSystemWide));
        }
        if (isConsentEnabledSystemWide && isListenerEnabledFromConfigs) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Listener is enabled and consent is enabled system wide. Hence returning true for isEnabled");
            }
            return true;
        }
        return false;
    }

    public ConsentDeletionAppMgtListener() {
        if (this.buildConfig()) {
            return;
        }
        this.setConsentLimit();
    }

    public int getDefaultOrderId() {
        return 907;
    }

    public boolean doPostDeleteApplication(String applicationName, String tenantDomain, String userName) throws IdentityApplicationManagementException {
        ConsentManager consentManager = IdentityConsentDataHolder.getInstance().getConsentManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting consents on deletion of application: %s, in tenant domain: %s.", applicationName, tenantDomain));
        }
        try {
            List receiptListResponses = consentManager.searchReceipts(consentSearchLimit, 0, "*", tenantDomain, applicationName, null, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("%d number of consents found for application %s", receiptListResponses.size(), applicationName));
            }
            receiptListResponses.forEach(LambdaExceptionUtils.rethrowConsumer(receiptListResponse -> {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Deleting receipt with id : %s, issued for user: ", receiptListResponse.getConsentReceiptId(), receiptListResponse.getPiiPrincipalId()));
                }
                consentManager.deleteReceipt(receiptListResponse.getConsentReceiptId());
            }));
        }
        catch (ConsentManagementException e) {
            throw new IdentityApplicationManagementException("Error while deleting user consents for application " + applicationName, (Throwable)e);
        }
        return true;
    }

    private void setConsentLimit() {
        String consentSearchLimitProp = this.properties.getProperty(CONSENT_SEARCH_LIMIT_PROPERTY);
        if (consentSearchLimitProp != null) {
            try {
                consentSearchLimit = Integer.parseInt(consentSearchLimitProp.toString());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Consent search limit is set to: %d", consentSearchLimit));
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)("consentSearchLimit for ConsentDeletionAppMgtListener is not a parsable integer. Hence using default value: " + consentSearchLimit));
            }
        }
    }

    private boolean buildConfig() {
        IdentityEventListenerConfig identityEventListenerConfig = IdentityUtil.readEventListenerProperty((String)ApplicationMgtListener.class.getName(), (String)((Object)((Object)this)).getClass().getName());
        if (identityEventListenerConfig == null) {
            return true;
        }
        if (identityEventListenerConfig.getProperties() != null) {
            for (Map.Entry<Object, Object> property : identityEventListenerConfig.getProperties().entrySet()) {
                String key = (String)property.getKey();
                String value = (String)property.getValue();
                if (!this.properties.containsKey(key)) {
                    this.properties.setProperty(key, value);
                    continue;
                }
                log.warn((Object)("Property key " + key + " already exists. Cannot add property!!"));
            }
        }
        return false;
    }
}

