/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.consent.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.PrivilegedConsentManager;
import org.wso2.carbon.identity.application.authentication.framework.handler.request.impl.consent.SSOConsentService;
import org.wso2.carbon.identity.application.mgt.listener.ApplicationMgtListener;
import org.wso2.carbon.identity.consent.mgt.handler.ConsentDeletionUserEventHandler;
import org.wso2.carbon.identity.consent.mgt.internal.IdentityConsentDataHolder;
import org.wso2.carbon.identity.consent.mgt.listener.ConsentDeletionAppMgtListener;
import org.wso2.carbon.identity.consent.mgt.listener.TenantConsentMgtListener;
import org.wso2.carbon.identity.consent.mgt.services.ConsentUtilityService;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;

@Component(name="identity.consent.mgt.component", immediate=true)
public class IdentityConsentServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityConsentServiceComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            ctxt.getBundleContext().registerService(AbstractEventHandler.class.getName(), (Object)new ConsentDeletionUserEventHandler(), null);
            ctxt.getBundleContext().registerService(ApplicationMgtListener.class.getName(), (Object)new ConsentDeletionAppMgtListener(), null);
            ctxt.getBundleContext().registerService(TenantMgtListener.class.getName(), (Object)new TenantConsentMgtListener(), null);
            ctxt.getBundleContext().registerService(ConsentUtilityService.class.getName(), (Object)new ConsentUtilityService(), null);
        }
        catch (Throwable throwable) {
            log.error((Object)"Error while activating Identity Consent Service Component.", throwable);
        }
    }

    @Reference(name="consent.mgt.service", service=ConsentManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentMgtService")
    protected void setConsentMgtService(ConsentManager consentManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consent Manger is set in the Identity Consent Service component bundle.");
        }
        IdentityConsentDataHolder.getInstance().setConsentManager(consentManager);
    }

    protected void unsetConsentMgtService(ConsentManager consentManager) {
        IdentityConsentDataHolder.getInstance().setConsentManager(null);
    }

    @Reference(name="privileged.consent.manager", service=PrivilegedConsentManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetPrivilegedConsentManager")
    protected void setPrivilegedConsentManager(PrivilegedConsentManager consentManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Privileged Consent Manger is set in the Identity Consent Service component bundle.");
        }
        IdentityConsentDataHolder.getInstance().setPrivilegedConsentManager(consentManager);
    }

    protected void unsetPrivilegedConsentManager(PrivilegedConsentManager consentManager) {
        IdentityConsentDataHolder.getInstance().setPrivilegedConsentManager(null);
    }

    @Reference(name="identity.application.authentication.framework.component", service=SSOConsentService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSSOConsentService")
    protected void setSSOConsentService(SSOConsentService ssoConsentService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SSO Consent Service is set in the Identity Consent Service component bundle.");
        }
        IdentityConsentDataHolder.getInstance().setSSOConsentService(ssoConsentService);
    }

    protected void unsetSSOConsentService(SSOConsentService ssoConsentService) {
        IdentityConsentDataHolder.getInstance().setSSOConsentService(null);
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

