/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.consent.mgt.handler;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.PrivilegedConsentManager;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.ReceiptListResponse;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.consent.mgt.IdentityConsentMgtUtils;
import org.wso2.carbon.identity.consent.mgt.internal.IdentityConsentDataHolder;
import org.wso2.carbon.identity.core.bean.context.MessageContext;
import org.wso2.carbon.identity.core.handler.InitConfig;
import org.wso2.carbon.identity.core.util.LambdaExceptionUtils;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.bean.IdentityEventMessageContext;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ConsentDeletionUserEventHandler
extends AbstractEventHandler {
    private static final Log log = LogFactory.getLog(ConsentDeletionUserEventHandler.class);
    private int consentSearchLimit = 100;
    private static final String HANDLER_NAME = "user.consent.delete";
    private static final String SEARCH_LIMIT_PROPERTY = "user.consent.delete.receipt.search.limit";

    public boolean isEnabled(MessageContext messageContext) {
        boolean isHandlerEnabledFromConfig = super.isEnabled(messageContext);
        boolean isConsentEnabledSystemWide = IdentityConsentMgtUtils.isConsentEnabled();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Is handler enabled from configs: " + isHandlerEnabledFromConfig));
            log.debug((Object)("Is consent enabled system wide: " + isConsentEnabledSystemWide));
        }
        if (isConsentEnabledSystemWide && isHandlerEnabledFromConfig) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handler is enabled and consent is enabled system wide. Hence returning true for isEnabled");
            }
            return true;
        }
        return false;
    }

    public void init(InitConfig configuration) throws IdentityRuntimeException {
        super.init(configuration);
        String receiptSearchLimit = this.configs.getModuleProperties().getProperty(SEARCH_LIMIT_PROPERTY);
        try {
            this.consentSearchLimit = Integer.parseInt(receiptSearchLimit);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Configured receipt.search.limit cannot be parsed as an integer. Hence using default value: " + this.consentSearchLimit));
        }
    }

    public void handleEvent(Event event) throws IdentityEventException {
        IdentityEventMessageContext eventContext = new IdentityEventMessageContext(event);
        if (!this.isEnabled((MessageContext)eventContext)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ConsentDeletionUserEventHandler is disabled. Not handling the " + event.getEventName() + " event."));
            }
            return;
        }
        Map eventProperties = event.getEventProperties();
        String userName = (String)eventProperties.get("user-name");
        UserStoreManager userStoreManager = (UserStoreManager)eventProperties.get("userStoreManager");
        String domainName = userStoreManager.getRealmConfiguration().getUserStoreProperty("DomainName");
        String tenantDomain = this.getUserTenantDomain(eventProperties);
        String usernameWithUserStoreDomain = UserCoreUtil.addDomainToName((String)userName, (String)domainName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting consents for user: %s , in tenant domain :%s", usernameWithUserStoreDomain, tenantDomain));
        }
        PrivilegedConsentManager consentManager = IdentityConsentDataHolder.getInstance().getPrivilegedConsentManager();
        try {
            List receiptListResponses = consentManager.searchReceipts(this.consentSearchLimit, 0, usernameWithUserStoreDomain, null, "*", null);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Found %d receipts issued for user: %s, in tenant domain: %s", receiptListResponses.size(), usernameWithUserStoreDomain, tenantDomain));
            }
            receiptListResponses.forEach(LambdaExceptionUtils.rethrowConsumer(arg_0 -> ConsentDeletionUserEventHandler.lambda$handleEvent$0((ConsentManager)consentManager, arg_0)));
        }
        catch (ConsentManagementException e) {
            throw new IdentityEventException("Error while deleting consents for user " + userName, (Throwable)e);
        }
    }

    private String getUserTenantDomain(Map<String, Object> eventProperties) {
        return (String)eventProperties.get("tenant-domain");
    }

    public String getName() {
        return HANDLER_NAME;
    }

    private static /* synthetic */ void lambda$handleEvent$0(ConsentManager consentManager, ReceiptListResponse receiptListResponse) throws ConsentManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting receipt with ID : %s, issued for application %s", receiptListResponse.getConsentReceiptId(), receiptListResponse.getSpDisplayName()));
        }
        consentManager.deleteReceipt(receiptListResponse.getConsentReceiptId());
    }
}

