/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.util;

import java.io.IOException;
import java.security.KeyStore;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.sts.common.SecurityConfigParams;
import org.wso2.carbon.identity.sts.common.UserCredentialRetriever;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ServicePasswordCallbackHandler
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(ServicePasswordCallbackHandler.class);
    private String serviceGroupId = null;
    private String serviceId = null;
    private Registry registry = null;
    private UserRealm realm = null;
    private SecurityConfigParams configParams;

    public ServicePasswordCallbackHandler(SecurityConfigParams configParams, String serviceGroupId, String serviceId, Registry registry, UserRealm realm) throws RegistryException, SecurityConfigException {
        this.registry = registry;
        this.serviceId = serviceId;
        this.serviceGroupId = serviceGroupId;
        this.realm = realm;
        this.configParams = configParams;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        try {
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof WSPasswordCallback) {
                    passwordCallback = (WSPasswordCallback)callbacks[i];
                    username = passwordCallback.getIdentifer();
                    receivedPasswd = null;
                    switch (passwordCallback.getUsage()) {
                        case 1: 
                        case 3: {
                            password = this.getPrivateKeyPassword(username);
                            if (password == null) {
                                throw new UnsupportedCallbackException(callbacks[i], "User not available in a trusted store");
                            }
                            passwordCallback.setPassword(password);
                            break;
                        }
                        case 9: {
                            passwordCallback.setPassword(this.getServicePrincipalPassword());
                            break;
                        }
                        case 5: {
                            receivedPasswd = passwordCallback.getPassword();
                            try {
                                if (receivedPasswd != null && this.authenticateUser(username, receivedPasswd)) {
                                    domainName = UserCoreUtil.getDomainFromThreadLocal();
                                    usernameWithDomain = IdentityUtil.addDomainToName((String)username, (String)domainName);
                                    if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                                        ServicePasswordCallbackHandler.log.debug((Object)("Updating username with userstore domain. Updated username is :" + usernameWithDomain));
                                        ** break;
                                    }
                                } else {
                                    throw new UnsupportedCallbackException(callbacks[i], "check failed");
                                }
lbl28:
                                // 2 sources

                                passwordCallback.setIdentifier(usernameWithDomain);
                                break;
                            }
                            catch (Exception e) {
                                if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                                    ServicePasswordCallbackHandler.log.debug((Object)("Error when authenticating user : " + username + ", password provided : " + StringUtils.isNotEmpty((String)receivedPasswd)), (Throwable)e);
                                }
                                throw new UnsupportedCallbackException(callbacks[i], "Check failed : System error");
                            }
                        }
                        case 2: {
                            storedPassword = null;
                            domainName = IdentityUtil.extractDomainFromName((String)username);
                            if ("PRIMARY".equals(domainName)) {
                                if (this.realm.getUserStoreManager() instanceof UserCredentialRetriever) {
                                    userCredentialRetriever = (UserCredentialRetriever)this.realm.getUserStoreManager();
                                    storedPassword = userCredentialRetriever.getPassword(username);
                                } else if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                                    ServicePasswordCallbackHandler.log.debug((Object)"Can not set user password in callback because primary userstore class has not implemented UserCredentialRetriever interface.");
                                }
                            } else if (this.realm.getUserStoreManager().getSecondaryUserStoreManager(domainName) instanceof UserCredentialRetriever) {
                                userCredentialRetriever = (UserCredentialRetriever)this.realm.getUserStoreManager().getSecondaryUserStoreManager(domainName);
                                storedPassword = userCredentialRetriever.getPassword(UserCoreUtil.removeDomainFromName((String)username));
                            } else if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                                ServicePasswordCallbackHandler.log.debug((Object)("Can not set user password in callback because secondary userstore for domain:" + domainName + " has not implemented UserCredentialRetriever interface."));
                            }
                            if (storedPassword != null) {
                                try {
                                    if (!this.authenticateUser(username, storedPassword)) {
                                        if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                                            ServicePasswordCallbackHandler.log.debug((Object)"User is not authorized!");
                                        }
                                        throw new UnsupportedCallbackException(callbacks[i], "check failed");
                                    }
                                }
                                catch (Exception e) {
                                    if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                                        ServicePasswordCallbackHandler.log.debug((Object)("Error when authenticating user : " + username + ", password provided : " + StringUtils.isNotEmpty((String)receivedPasswd)), (Throwable)e);
                                    }
                                    throw new UnsupportedCallbackException(callbacks[i], "Check failed : System error");
                                }
                                passwordCallback.setPassword(storedPassword);
                                break;
                            }
                        }
                        default: {
                            passwordCallback.setPassword(receivedPasswd);
                        }
                    }
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
        }
        catch (IOException | UnsupportedCallbackException e) {
            if (ServicePasswordCallbackHandler.log.isDebugEnabled()) {
                ServicePasswordCallbackHandler.log.debug((Object)"Error in handling ServicePasswordCallbackHandler", (Throwable)e);
                throw e;
            }
            throw e;
        }
        catch (SecurityConfigException | UserStoreException e) {
            ServicePasswordCallbackHandler.log.error((Object)"Error in handling ServicePasswordCallbackHandler", e);
            throw new UnsupportedCallbackException(null, e.getMessage());
        }
        catch (Exception e) {
            ServicePasswordCallbackHandler.log.error((Object)"Error in handling ServicePasswordCallbackHandler", (Throwable)e);
            throw new UnsupportedCallbackException(null, e.getMessage());
        }
    }

    private String getServicePrincipalPassword() throws SecurityConfigException {
        String password = this.configParams.getServerPrincipalPassword();
        if (password != null) {
            if (this.configParams.isServerPrincipalPasswordEncrypted()) {
                password = this.getDecryptedPassword(password);
            }
            return password;
        }
        String msg = "Service principal password param not found";
        log.error((Object)msg);
        throw new SecurityConfigException(msg);
    }

    private String getDecryptedPassword(String encryptedString) throws SecurityConfigException {
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        try {
            return new String(cryptoUtil.base64DecodeAndDecrypt(encryptedString));
        }
        catch (CryptoException e) {
            String msg = "Unable to decode and decrypt password string.";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, (Throwable)e);
        }
    }

    public boolean authenticateUser(String user, String password) throws Exception {
        boolean isAuthenticated = false;
        boolean isAuthorized = false;
        try {
            if (this.realm.getUserStoreManager().getTenantId() != SecurityServiceHolder.getRealmService().getTenantManager().getTenantId(MultitenantUtils.getTenantDomain((String)user))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User : " + user + " trying access service which is deployed in different tenant domain"));
                }
                return false;
            }
            String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)user);
            isAuthenticated = this.realm.getUserStoreManager().authenticate(tenantAwareUserName, (Object)password);
            if (isAuthenticated) {
                String domain;
                int index = tenantAwareUserName.indexOf("/");
                if (index < 0 && (domain = UserCoreUtil.getDomainFromThreadLocal()) != null) {
                    tenantAwareUserName = domain + "/" + tenantAwareUserName;
                }
                if (!(isAuthorized = this.realm.getAuthorizationManager().isUserAuthorized(tenantAwareUserName, this.serviceGroupId + "/" + this.serviceId, "invoke-service")) && log.isDebugEnabled()) {
                    log.debug((Object)("Authorization failure for user : " + tenantAwareUserName));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication failure for user : " + tenantAwareUserName));
            }
            return isAuthorized;
        }
        catch (Exception e) {
            log.error((Object)"Error in authenticating user.", (Throwable)e);
            throw e;
        }
    }

    private String getPrivateKeyPassword(String username) throws IOException, Exception {
        String password;
        block7: {
            password = null;
            int tenantId = ((UserRegistry)this.registry).getTenantId();
            UserRegistry govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
            try {
                KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantId);
                if (!govRegistry.resourceExists("/repository/security/key-stores")) break block7;
                Collection collection = (Collection)govRegistry.get("/repository/security/key-stores");
                String[] ks = collection.getChildren();
                for (int i = 0; i < ks.length; ++i) {
                    String fullname = ks[i];
                    if (tenantId == -1234 && fullname.equals("/repository/security/key-stores/carbon-primary-ks")) {
                        KeyStore store = keyMan.getPrimaryKeyStore();
                        if (!store.containsAlias(username)) continue;
                        password = keyMan.getPrimaryPrivateKeyPasssword();
                    } else {
                        String name = fullname.substring(fullname.lastIndexOf("/") + 1);
                        KeyStore store = null;
                        store = keyMan.getKeyStore(name);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Load the keystore " + name));
                        }
                        if (store == null || !store.containsAlias(username)) continue;
                        Resource resource = govRegistry.get(ks[i]);
                        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
                        String encryptedPassword = resource.getProperty("privatekeyPass");
                        password = new String(cryptoUtil.base64DecodeAndDecrypt(encryptedPassword));
                    }
                    break;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error when getting PrivateKeyPassword.", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)"Error when getting PrivateKeyPassword.", (Throwable)e);
                throw e;
            }
        }
        return password;
    }
}

