/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.X509NameTokenizer;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.security.SecurityServiceHolder;

public class ServerCrypto
implements Crypto {
    public static final String PROP_ID_KEY_STORE = "org.wso2.carbon.security.crypto.keystore";
    public static final String PROP_ID_PRIVATE_STORE = "org.wso2.carbon.security.crypto.privatestore";
    public static final String PROP_ID_TRUST_STORES = "org.wso2.carbon.security.crypto.truststores";
    public static final String PROP_ID_CERT_PROVIDER = "org.wso2.carbon.security.crypto.cert.provider";
    public static final String PROP_ID_DEFAULT_ALIAS = "org.wso2.carbon.security.crypto.alias";
    public static final String PROP_ID_REGISTRY = "org.wso2.carbon.security.crypto.registry";
    public static final String PROP_ID_CACERT_PASS = "org.wso2.carbon.security.crypto.cacert.pass";
    public static final String PROP_ID_XKMS_SERVICE_PASS_PHRASE = "org.wso2.wsas.security.wso2wsas.crypto.xkms.pass";
    public static final String PROP_ID_TENANT_ID = "org.wso2.stratos.tenant.id";
    public static final String PROP_ID_XKMS_SERVICE_URL = "org.wso2.carbon.security.crypto.xkms.url";
    private static final String SKI_OID = "2.5.29.14";
    private static final Log log = LogFactory.getLog(ServerCrypto.class);
    private static CertificateFactory certFact = null;
    private Properties properties;
    private KeyStore keystore;
    private KeyStore cacerts;
    private List<KeyStore> trustStores;
    private Registry registry;
    private Boolean useXkms;

    public ServerCrypto(Properties prop) throws CredentialException, IOException {
        this(prop, ServerCrypto.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerCrypto(Properties prop, ClassLoader loader) throws CredentialException, IOException {
        block13: {
            this.properties = null;
            this.keystore = null;
            this.cacerts = null;
            this.trustStores = new ArrayList<KeyStore>();
            this.registry = null;
            boolean isSetDoomFalse = false;
            try {
                String trustStoreIds;
                String tenantIdString = (String)prop.get(PROP_ID_TENANT_ID);
                int tenantId = tenantIdString == null || tenantIdString.trim().length() == 0 ? CarbonContext.getThreadLocalCarbonContext().getTenantId() : Integer.parseInt(tenantIdString);
                SecurityServiceHolder.getTenantRegistryLoader().loadTenantRegistry(tenantId);
                if (DocumentBuilderFactoryImpl.isDOOMRequired()) {
                    DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
                    isSetDoomFalse = true;
                }
                this.registry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
                if (isSetDoomFalse) {
                    DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
                    isSetDoomFalse = false;
                }
                this.properties = prop;
                KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantId);
                String ksId = this.properties.getProperty(PROP_ID_PRIVATE_STORE);
                if (ksId != null) {
                    this.keystore = keyMan.getKeyStore(ksId);
                }
                if ((trustStoreIds = this.properties.getProperty(PROP_ID_TRUST_STORES)) != null && trustStoreIds.trim().length() != 0) {
                    String[] ids = trustStoreIds.trim().split(",");
                    this.trustStores = new ArrayList<KeyStore>(ids.length);
                    for (int i = 0; i < ids.length; ++i) {
                        String id = ids[i];
                        KeyStore tstks = keyMan.getKeyStore(id);
                        this.trustStores.add(i, tstks);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"error creating ServerCryto", (Throwable)e);
                throw new CredentialException(3, "secError00", (Throwable)e);
            }
            String cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            try (FileInputStream cacertsIs = new FileInputStream(cacertsPath);){
                String cacertsPasswd = this.properties.getProperty(PROP_ID_CACERT_PASS, "changeit");
                this.cacerts = KeyStore.getInstance(KeyStore.getDefaultType());
                this.cacerts.load(cacertsIs, cacertsPasswd.toCharArray());
            }
        }
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        return cert;
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        CertPath path;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        Iterator<? extends Certificate> iterator = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            certs[reverse ? l.size() - 1 - i : i] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            if (reverse) {
                list.add(0, certs[i]);
                continue;
            }
            list.add(certs[i]);
        }
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        if (alias == null) {
            throw new Exception("alias is null");
        }
        boolean b = this.keystore.isKeyEntry(alias);
        if (!b) {
            log.error((Object)("Cannot find key for alias: " + alias));
            throw new Exception("Cannot find key for alias: " + alias);
        }
        Key keyTmp = this.keystore.getKey(alias, password.toCharArray());
        if (!(keyTmp instanceof PrivateKey)) {
            throw new Exception("Key is not a private key, alias: " + alias);
        }
        return (PrivateKey)keyTmp;
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        Certificate[] certs = new Certificate[]{};
        Certificate cert = null;
        try {
            if (this.keystore != null && ((certs = this.keystore.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.keystore.getCertificate(alias);
            }
            if (certs == null && cert == null && this.trustStores != null) {
                KeyStore store;
                Iterator<KeyStore> trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (certs = (store = trustStoreIter.next()).getCertificateChain(alias)) == null) {
                    cert = store.getCertificate(alias);
                }
            }
            if (certs == null && cert == null && this.cacerts != null && ((certs = this.cacerts.getCertificateChain(alias)) == null || certs.length == 0)) {
                cert = this.cacerts.getCertificate(alias);
            }
            if (cert != null) {
                certs = new Certificate[]{cert};
            } else if (certs == null) {
                return new X509Certificate[0];
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        X509Certificate[] x509certs = new X509Certificate[]{};
        if (certs != null) {
            x509certs = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                x509certs[i] = (X509Certificate)certs[i];
            }
        }
        return x509certs;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        try {
            KeyStore store;
            Iterator<KeyStore> trustStoreIter;
            String alias = null;
            if (this.keystore != null && (alias = this.keystore.getCertificateAlias(cert)) == null) {
                alias = this.findAliasForCert(this.keystore, cert);
            }
            if (alias == null && this.trustStores != null) {
                trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (alias = (store = trustStoreIter.next()).getCertificateAlias(cert)) == null) {
                }
            }
            if (alias == null && this.trustStores != null) {
                trustStoreIter = this.trustStores.iterator();
                while (trustStoreIter.hasNext() && (alias = this.findAliasForCert(store = trustStoreIter.next(), cert)) == null) {
                }
            }
            if (alias == null && this.cacerts != null && (alias = this.cacerts.getCertificateAlias(cert)) == null) {
                alias = this.findAliasForCert(this.cacerts, cert);
            }
            if (alias != null) {
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    private String findAliasForCert(KeyStore ks, Certificate cert) throws KeyStoreException {
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            X509Certificate cert2 = (X509Certificate)ks.getCertificate(alias);
            if (!cert2.equals(cert)) continue;
            return alias;
        }
        return null;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        String alias;
        block1: {
            KeyStore ks;
            alias = this.getAliasForX509Cert(issuer, null, false, this.keystore);
            if (alias != null) break block1;
            Iterator<KeyStore> ite = this.trustStores.iterator();
            while (ite.hasNext() && (alias = this.getAliasForX509Cert(issuer, null, false, ks = ite.next())) == null) {
            }
        }
        return alias;
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        String alias;
        block1: {
            KeyStore ks;
            alias = this.getAliasForX509Cert(issuer, serialNumber, true, this.keystore);
            if (alias != null) break block1;
            Iterator<KeyStore> ite = this.trustStores.iterator();
            while (ite.hasNext() && (alias = this.getAliasForX509Cert(issuer, serialNumber, true, ks = ite.next())) == null) {
            }
        }
        return alias;
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                byte[] data = this.getSKIBytesFromCert(cert);
                if (data.length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String getDefaultX509Alias() {
        return this.properties.getProperty(PROP_ID_DEFAULT_ALIAS);
    }

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Support for RSA key only"});
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3) and no SHA1 message digest availabe"});
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public String getAliasForX509CertThumb(byte[] thumb) throws WSSecurityException {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new WSSecurityException(0, "noSHA1availabe");
        }
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate cert = certs[0];
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException e1) {
                    throw new WSSecurityException(7, "encodeError");
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumb)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (certFact == null) {
            try {
                String provider = this.properties.getProperty(PROP_ID_CERT_PROVIDER);
                certFact = provider == null || provider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider");
            }
        }
        return certFact;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        boolean result = this.validateCertPath(this.keystore, certs);
        if (!result) {
            Iterator<KeyStore> trustStoreIter = this.trustStores.iterator();
            while (!result) {
                result = this.validateCertPath(trustStoreIter.next(), certs);
            }
        }
        if (!result && this.cacerts != null) {
            result = this.validateCertPath(this.cacerts, certs);
        }
        return result;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        Vector<String> aliases = new Vector<String>();
        Vector subjectRDN = this.splitAndTrim(subjectDN);
        try {
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return new String[0];
                }
                X509Certificate cert = certs[0];
                Vector foundRDN = this.splitAndTrim(cert.getSubjectDN().getName());
                if (!subjectRDN.equals(foundRDN)) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        String[] result = new String[aliases.size()];
        for (int i = 0; i < aliases.size(); ++i) {
            result[i] = (String)aliases.get(i);
        }
        return result;
    }

    private String getAliasForX509Cert(String issuer, BigInteger serialNumber, boolean useSerialNumber, KeyStore ks) throws WSSecurityException {
        Vector issuerRDN = this.splitAndTrim(issuer);
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                Vector certRDN;
                X509Certificate cert;
                String alias = e.nextElement();
                X509Certificate[] certs = this.getCertificates(alias);
                if (certs == null || certs.length == 0) {
                    return null;
                }
                X509Certificate x509cert = cert = certs[0];
                if (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0 || !(certRDN = this.splitAndTrim(x509cert.getIssuerDN().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    private Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    private boolean validateCertPath(KeyStore ks, Certificate[] certs) throws WSSecurityException {
        try {
            List<Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            PKIXParameters param = new PKIXParameters(ks);
            param.setRevocationEnabled(false);
            String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
            CertPathValidator certPathValidator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            certPathValidator.validate(path, param);
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertPathValidatorException | CertificateException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        return true;
    }
}

