/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.util;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sts.common.SecurityConfigParams;

public class SecurityConfigParamBuilder {
    public static final QName SECURITY_CONFIG_QNAME = new QName("http://www.wso2.org/products/carbon/security", "CarbonSecConfig");
    private static QName propertyQName = new QName("http://www.wso2.org/products/carbon/security", "property");
    private static QName nameQName = new QName("name");
    private static QName encryptedQName = new QName("encrypted");
    private static QName trustQName = new QName("http://www.wso2.org/products/carbon/security", "Trust");
    private static QName authorizationQName = new QName("http://www.wso2.org/products/carbon/security", "Authorization");
    private static QName kerberosQName = new QName("http://www.wso2.org/products/carbon/security", "Kerberos");
    private static final Log log = LogFactory.getLog(SecurityConfigParamBuilder.class);

    private SecurityConfigParamBuilder() {
    }

    public static SecurityConfigParams getSecurityParams(OMElement config) {
        SecurityConfigParams securityConfigParams = new SecurityConfigParams();
        if (config != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Config Element : " + config.toString()));
            }
            Iterator iterator = config.getChildElements();
            while (iterator.hasNext()) {
                String value;
                String name;
                OMElement configCategoryElem = (OMElement)iterator.next();
                if (trustQName.equals(configCategoryElem.getQName())) {
                    Iterator trustPropsElem = configCategoryElem.getChildElements();
                    while (trustPropsElem.hasNext()) {
                        OMElement trustProperty = (OMElement)trustPropsElem.next();
                        if (!propertyQName.equals(trustProperty.getQName())) continue;
                        name = trustProperty.getAttributeValue(nameQName);
                        value = trustProperty.getText().trim();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trust Config property name : " + name + " value : " + value));
                        }
                        if ("org.wso2.carbon.security.crypto.privatestore".equals(name)) {
                            securityConfigParams.setPrivateStore(value);
                            continue;
                        }
                        if ("org.wso2.carbon.security.crypto.truststores".equals(name)) {
                            securityConfigParams.setTrustStores(value);
                            continue;
                        }
                        if (!"org.wso2.carbon.security.crypto.alias".equals(name)) continue;
                        securityConfigParams.setKeyAlias(value);
                    }
                    continue;
                }
                if (authorizationQName.equals(configCategoryElem.getQName())) {
                    Iterator authorizationPropsElem = configCategoryElem.getChildElements();
                    while (authorizationPropsElem.hasNext()) {
                        OMElement authorizationProperty = (OMElement)authorizationPropsElem.next();
                        if (!propertyQName.equals(authorizationProperty.getQName())) continue;
                        name = authorizationProperty.getAttributeValue(nameQName);
                        value = authorizationProperty.getText().trim();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Authorization Config property name : " + name + " value : " + value));
                        }
                        if (!"org.wso2.carbon.security.allowedroles".equals(name)) continue;
                        securityConfigParams.setAllowedRoles(value);
                    }
                    continue;
                }
                if (!kerberosQName.equals(configCategoryElem.getQName())) continue;
                Iterator kerberosPropsElem = configCategoryElem.getChildElements();
                while (kerberosPropsElem.hasNext()) {
                    OMElement kerberosProperty = (OMElement)kerberosPropsElem.next();
                    if (!propertyQName.equals(kerberosProperty.getQName())) continue;
                    name = kerberosProperty.getAttributeValue(nameQName);
                    value = kerberosProperty.getText().trim();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Kerberos Config property name : " + name + " value : " + value));
                    }
                    if (!"service.principal.password".equals(name)) continue;
                    securityConfigParams.setServerPrincipalPassword(value);
                    if (kerberosProperty.getAttribute(encryptedQName) == null) continue;
                    securityConfigParams.setServerPrincipalPasswordEncrypted(Boolean.parseBoolean(kerberosProperty.getAttributeValue(encryptedQName)));
                }
            }
        }
        return securityConfigParams;
    }
}

