/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.sts.service;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.identity.sts.common.config.SecurityServiceAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.service.KeyStoreData;
import org.wso2.carbon.security.sts.service.STSAdminServiceInterface;
import org.wso2.carbon.security.sts.service.util.TrustedServiceData;

public class STSAdminServiceImpl
extends AbstractAdmin
implements STSAdminServiceInterface {
    private static final Log log = LogFactory.getLog(STSAdminServiceImpl.class);

    public void addTrustedService(String serviceAddress, String certAlias) throws SecurityConfigException {
        try {
            AxisService stsService = this.getAxisConfig().getService("wso2carbon-sts");
            Parameter origParam = stsService.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam == null) {
                throw new AxisFault("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            }
            OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
            SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
            samlConfig.addTrustedServiceEndpointAddress(serviceAddress, certAlias);
            this.setSTSParameter(samlConfig);
            this.persistTrustedService("wso2carbon-sts", "wso2carbon-sts", serviceAddress, certAlias);
        }
        catch (Exception e) {
            log.error((Object)"Error while adding a trusted service", (Throwable)e);
            throw new SecurityConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeTrustedService(String serviceAddress) throws SecurityConfigException {
        try {
            AxisService stsService = this.getAxisConfig().getService("wso2carbon-sts");
            Parameter origParam = stsService.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam == null) {
                throw new AxisFault("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            }
            OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
            SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
            samlConfig.getTrustedServices().remove(serviceAddress);
            this.setSTSParameter(samlConfig);
            this.removeTrustedService("wso2carbon-sts", "wso2carbon-sts", serviceAddress);
        }
        catch (Exception e) {
            log.error((Object)"Error while removing a trusted service", (Throwable)e);
            throw new SecurityConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public TrustedServiceData[] getTrustedServices() throws SecurityConfigException {
        try {
            AxisService service = this.getAxisConfig().getService("wso2carbon-sts");
            Parameter origParam = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam != null) {
                OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
                SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
                Map trustedServicesMap = samlConfig.getTrustedServices();
                ArrayList<TrustedServiceData> serviceBag = new ArrayList<TrustedServiceData>();
                Set entrySet = trustedServicesMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    String address = (String)entry.getKey();
                    String alias = (String)entry.getValue();
                    serviceBag.add(new TrustedServiceData(address, alias));
                }
                return serviceBag.toArray(new TrustedServiceData[serviceBag.size()]);
            }
            throw new SecurityConfigException("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving trusted services", (Throwable)e);
            throw new SecurityConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public String getProofKeyType() throws SecurityConfigException {
        try {
            AxisService service = this.getAxisConfig().getService("wso2carbon-sts");
            Parameter origParam = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam != null) {
                OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
                SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
                return samlConfig.getProofKeyType();
            }
            throw new SecurityConfigException("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving proof key type", (Throwable)e);
            throw new SecurityConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public void setProofKeyType(String keyType) throws SecurityConfigException {
        try {
            AxisService service = this.getAxisConfig().getService("wso2carbon-sts");
            Parameter origParam = service.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            if (origParam == null) {
                throw new AxisFault("missing parameter : " + SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
            }
            OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
            SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
            samlConfig.setProofKeyType(keyType);
            this.setSTSParameter(samlConfig);
        }
        catch (Exception e) {
            log.error((Object)"Error setting proof key type", (Throwable)e);
            throw new SecurityConfigException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getCertAliasOfPrimaryKeyStore() throws SecurityConfigException {
        KeyStoreData[] keyStores = this.getKeyStores();
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        KeyStoreData primaryKeystore = null;
        for (KeyStoreData keyStore : keyStores) {
            if (keyStore == null) continue;
            if (tenantId == -1234) {
                if (!KeyStoreUtil.isPrimaryStore((String)keyStore.getKeyStoreName())) continue;
                primaryKeystore = keyStore;
                break;
            }
            if (!keyStore.getPrivateStore()) continue;
            primaryKeystore = keyStore;
            break;
        }
        if (primaryKeystore != null) {
            return this.getStoreEntries(primaryKeystore.getKeyStoreName());
        }
        throw new SecurityConfigException("Primary Keystore cannot be found.");
    }

    private void setSTSParameter(SAMLTokenIssuerConfig samlConfig) throws AxisFault {
        new SecurityServiceAdmin(this.getAxisConfig(), this.getConfigSystemRegistry()).setServiceParameterElement("wso2carbon-sts", samlConfig.getParameter());
    }

    private KeyStoreData[] getKeyStores() throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        boolean isSuperTenant = CarbonContext.getThreadLocalCarbonContext().getTenantId() == -1234;
        return admin.getKeyStores(isSuperTenant);
    }

    private String[] getStoreEntries(String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        return admin.getStoreEntries(keyStoreName);
    }

    private void persistTrustedService(String groupName, String serviceName, String trustedService, String certAlias) throws SecurityConfigException {
        try {
            String resourcePath = "/repository/axis2/service-groups/" + groupName + "/services/" + serviceName + "/trustedServices";
            Registry registry = this.getConfigSystemRegistry();
            if (registry != null) {
                Resource resource = registry.resourceExists(resourcePath) ? registry.get(resourcePath) : registry.newResource();
                if (resource.getProperty(trustedService) != null) {
                    resource.removeProperty(trustedService);
                }
                resource.addProperty(trustedService, certAlias);
                registry.put(resourcePath, resource);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while adding trusted service for STS", (Throwable)e);
            throw new SecurityConfigException("Error occured while adding trusted service for STS", (Throwable)e);
        }
    }

    private void removeTrustedService(String groupName, String serviceName, String trustedService) throws SecurityConfigException {
        try {
            String resourcePath = "/repository/axis2/service-groups/" + groupName + "/services/" + serviceName + "/trustedServices";
            Registry registry = this.getConfigSystemRegistry();
            if (registry != null && registry.resourceExists(resourcePath)) {
                Resource resource = registry.get(resourcePath);
                if (resource.getProperty(trustedService) != null) {
                    resource.removeProperty(trustedService);
                }
                registry.put(resourcePath, resource);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occured while removing trusted service for STS", (Throwable)e);
            throw new SecurityConfigException("Error occured while adding trusted service for STS", (Throwable)e);
        }
    }
}

