/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.sts.common.config.SecurityConfigAdmin;
import org.wso2.carbon.identity.sts.common.internal.SecurityAxis2ConfigurationContextObserver;
import org.wso2.carbon.identity.sts.common.sts.service.STSAdminServiceImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.security.sts.service.STSAdminServiceInterface;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="security.sts.common.mgt.service.component", immediate=true)
public class SecurityMgtServiceComponent {
    private static String POX_SECURITY_MODULE = "POXSecurityModule";
    private static final Log log = LogFactory.getLog(SecurityMgtServiceComponent.class);
    private static ConfigurationContextService configContextService = null;
    private static RealmService realmService;
    private static RegistryService registryService;

    public static ConfigurationContext getServerConfigurationContext() {
        return configContextService.getServerConfigContext();
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            ConfigurationContext mainConfigCtx = configContextService.getServerConfigContext();
            AxisConfiguration mainAxisConfig = mainConfigCtx.getAxisConfiguration();
            BundleContext bundleCtx = ctxt.getBundleContext();
            String enablePoxSecurity = ServerConfiguration.getInstance().getFirstProperty("EnablePoxSecurity");
            if (enablePoxSecurity == null || "true".equals(enablePoxSecurity)) {
                mainAxisConfig.engageModule(POX_SECURITY_MODULE);
            } else {
                log.info((Object)"POX Security Disabled");
            }
            bundleCtx.registerService(SecurityConfigAdmin.class.getName(), (Object)new SecurityConfigAdmin(mainAxisConfig, (Registry)registryService.getConfigSystemRegistry(), null), null);
            bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new SecurityAxis2ConfigurationContextObserver(), null);
            bundleCtx.registerService(STSAdminServiceInterface.class, (Object)new STSAdminServiceImpl(), null);
            log.debug((Object)"Security Mgt bundle is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate SecurityMgtServiceComponent", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        try {
            AxisConfiguration serverAxisConfig = configContextService.getServerConfigContext().getAxisConfiguration();
            if (serverAxisConfig != null) {
                serverAxisConfig.disengageModule(serverAxisConfig.getModule(POX_SECURITY_MODULE));
            }
            log.debug((Object)"Security Mgt bundle is deactivated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to deactivate SecurityMgtServiceComponent", e);
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the ConfigurationContext");
        }
        configContextService = contextService;
        SecurityServiceHolder.setConfigurationContextService((ConfigurationContextService)contextService);
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RegistryService");
        }
        SecurityMgtServiceComponent.registryService = registryService;
        SecurityServiceHolder.setRegistryService((RegistryService)registryService);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RealmService");
        }
        SecurityMgtServiceComponent.realmService = realmService;
        SecurityServiceHolder.setRealmService((RealmService)realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RealmService");
        }
        SecurityMgtServiceComponent.realmService = null;
        SecurityServiceHolder.setRealmService(null);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ConfigurationContext");
        }
        configContextService = null;
        SecurityServiceHolder.setConfigurationContextService((ConfigurationContextService)contextService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RegistryService");
        }
        SecurityMgtServiceComponent.registryService = registryService;
        SecurityServiceHolder.setRegistryService((RegistryService)registryService);
    }

    @Reference(name="registry.loader.default", service=TenantRegistryLoader.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTenantRegistryLoader")
    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is set in the SAML SSO bundle");
        }
        SecurityServiceHolder.setTenantRegistryLoader((TenantRegistryLoader)tenantRegistryLoader);
    }

    protected void unsetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is unset in the SAML SSO bundle");
        }
        SecurityServiceHolder.setTenantRegistryLoader(null);
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }
}

