/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.sts.common.identity.provider.IdentityAttributeService;
import org.wso2.carbon.identity.sts.common.identity.provider.IdentityAttributeServiceStore;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.provider.sts.component", immediate=true)
public class IdentityProviderSTSServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityProviderSTSServiceComponent.class);
    private static ConfigurationContext configContext;
    private static RealmService realmService;
    private static RegistryService registryService;
    private static ApplicationManagementService applicationManagementService;

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ReleamService is set in Identity Provider STS Service Bundle");
        }
        IdentityProviderSTSServiceComponent.realmService = realmService;
    }

    public static ConfigurationContext getConfigContext() {
        return configContext;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static ApplicationManagementService getApplicationManagementService() {
        return applicationManagementService;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        IdentityProviderSTSServiceComponent.registryService = registryService;
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Identity Provider STS Service bundle");
        }
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Provider STS Service bundle is activated");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Provider STS Service bundle is deactivated");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        IdentityProviderSTSServiceComponent.registryService = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Identity Provider STS Service bundle");
        }
    }

    @Reference(name="identity.application.management.component", service=ApplicationManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationMgtService")
    protected void setApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService set in Identity Provider STS Service bundle");
        }
        applicationManagementService = applicationMgtService;
    }

    protected void unsetApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService unset in Identity Provider STS Service bundle");
        }
        applicationManagementService = null;
    }

    protected void unsetUserRealmDelegating(UserRealm userRealmDelegating) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DelegatingUserRealm set in Identity Provider STS Service bundle");
        }
    }

    protected void unsetUserRealmDefault(UserRealm userRealmDefault) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultUserRealm unset in Identity Provider STS Service bundle");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ReleamService is unset in Identity Provider STS Service Bundle");
        }
    }

    @Reference(name="identity.attribute.service", service=IdentityAttributeService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeAttributeService")
    protected void addAttributeService(IdentityAttributeService attributeService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"IdentityAttributeService added in Identity Provider STS Service bundle");
        }
        IdentityAttributeServiceStore.addAttributeService(attributeService);
    }

    protected void removeAttributeService(IdentityAttributeService attributeService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"IdentityAttributeService removed in Identity Provider STS Service bundle");
            IdentityAttributeServiceStore.removeAttributeService(attributeService);
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService set in Identity Provider STS Service bundle");
        }
        configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unset in Identity Provider STS Service bundle");
        }
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

