/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.identity.provider.token.builder;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.xml.security.utils.Base64;
import org.joda.time.DateTime;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AttributeValue;
import org.opensaml.saml1.core.Audience;
import org.opensaml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.ConfirmationMethod;
import org.opensaml.saml1.core.Subject;
import org.opensaml.saml1.core.SubjectConfirmation;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Element;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.sts.common.identity.provider.GenericIdentityProviderData;
import org.wso2.carbon.identity.sts.common.identity.provider.RequestedClaimData;
import org.wso2.carbon.identity.sts.common.identity.provider.token.builder.SAMLTokenBuilder;

public class SAML1TokenBuilder
implements SAMLTokenBuilder {
    public static final String CONF_KEY = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    private static final Log log = LogFactory.getLog(SAML1TokenBuilder.class);
    protected Assertion assertion = null;
    protected AttributeStatement attributeStmt = null;
    protected List<Signature> signatureList = new ArrayList<Signature>();
    protected Element signedAssertion = null;
    protected String appilesTo = null;

    protected static XMLObject buildXMLObject(QName objectQName) throws IdentityProviderException {
        XMLObjectBuilder builder = Configuration.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new IdentityProviderException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    @Override
    public void createStatement(GenericIdentityProviderData ipData, RahasData rahasData) throws IdentityProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Begin SAML statement creation.");
        }
        this.attributeStmt = (AttributeStatement)SAML1TokenBuilder.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)SAML1TokenBuilder.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConf = (SubjectConfirmation)SAML1TokenBuilder.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        ConfirmationMethod confMethod = (ConfirmationMethod)SAML1TokenBuilder.buildXMLObject(ConfirmationMethod.DEFAULT_ELEMENT_NAME);
        confMethod.setConfirmationMethod(CONF_KEY);
        subjectConf.getConfirmationMethods().add(confMethod);
        subject.setSubjectConfirmation(subjectConf);
        this.attributeStmt.setSubject(subject);
        Map<String, RequestedClaimData> mapClaims = ipData.getRequestedClaims();
        if (rahasData.getAppliesToAddress() != null) {
            this.appilesTo = rahasData.getAppliesToAddress();
        }
        for (RequestedClaimData claim : mapClaims.values()) {
            String uri = claim.getUri();
            int index = uri.lastIndexOf("/");
            String attrName = uri.substring(index + 1, uri.length());
            String attrNamespace = uri.substring(0, index);
            Attribute attribute = (Attribute)SAML1TokenBuilder.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
            attribute.setAttributeName(attrName);
            attribute.setAttributeNamespace(attrNamespace);
            XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
            XSStringBuilder attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
            XSString stringValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            stringValue.setValue(claim.getValue());
            attribute.getAttributeValues().add(stringValue);
            this.attributeStmt.getAttributes().add(attribute);
        }
    }

    @Override
    public void createSAMLAssertion(DateTime notAfter, DateTime notBefore, String assertionId) throws IdentityProviderException {
        this.assertion = (Assertion)SAML1TokenBuilder.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)SAML1TokenBuilder.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notAfter);
        ServerConfiguration config = ServerConfiguration.getInstance();
        String host = "http://" + config.getFirstProperty("HostName");
        this.assertion.setIssuer(host);
        this.assertion.setIssueInstant(new DateTime());
        if (this.appilesTo != null) {
            Audience audience = (Audience)SAML1TokenBuilder.buildXMLObject(Audience.DEFAULT_ELEMENT_NAME);
            audience.setUri(this.appilesTo);
            AudienceRestrictionCondition audienceRestrictions = (AudienceRestrictionCondition)SAML1TokenBuilder.buildXMLObject(AudienceRestrictionCondition.DEFAULT_ELEMENT_NAME);
            audienceRestrictions.getAudiences().add(audience);
            conditions.getAudienceRestrictionConditions().add(audienceRestrictions);
        }
        this.assertion.setConditions(conditions);
        this.assertion.getAttributeStatements().add(this.attributeStmt);
        this.assertion.setID(assertionId);
    }

    @Override
    public void setSignature(String signatureAlgorithm, X509Credential cred) throws IdentityProviderException {
        Signature signature = (Signature)SAML1TokenBuilder.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)cred);
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            KeyInfo keyInfo = (KeyInfo)SAML1TokenBuilder.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)SAML1TokenBuilder.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)SAML1TokenBuilder.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
        }
        catch (CertificateEncodingException e) {
            log.error((Object)"Error while getting the encoded certificate", (Throwable)e);
            throw new IdentityProviderException("Error while getting the encoded certificate");
        }
        this.assertion.setSignature(signature);
        this.signatureList.add(signature);
    }

    @Override
    public void marshellAndSign() throws IdentityProviderException {
        try {
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)this.assertion);
            this.signedAssertion = marshaller.marshall((XMLObject)this.assertion);
            Signer.signObjects(this.signatureList);
        }
        catch (MarshallingException e) {
            log.debug((Object)e);
            throw new IdentityProviderException("errorMarshellingOrSigning", (Throwable)e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new IdentityProviderException("errorMarshellingOrSigning", (Throwable)e);
        }
    }

    @Override
    public Element getSAMLasDOM() throws IdentityProviderException {
        return this.signedAssertion;
    }
}

