/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.identity.provider;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.rahas.RahasData;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.sts.common.identity.provider.GenericIdentityProviderData;

public class IdentityProviderUtil {
    private static boolean intial;

    private IdentityProviderUtil() {
    }

    public static boolean isIntial() {
        return intial;
    }

    public static void setIntial(boolean intial) {
        IdentityProviderUtil.intial = intial;
    }

    public static OMElement createRequestedDisplayToken(OMElement parent, GenericIdentityProviderData data) {
        return IdentityProviderUtil.createOMElement(parent, "http://schemas.xmlsoap.org/ws/2005/05/identity", "RequestedDisplayToken", "ic");
    }

    public static OMElement createDisplayToken(OMElement parent, GenericIdentityProviderData data) {
        return IdentityProviderUtil.createOMElement(parent, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayToken", "ic");
    }

    public static OMElement createDisplayClaim(OMElement parent, String displayTag, String displayValue, String uri) {
        OMElement claimElem = IdentityProviderUtil.createOMElement(parent, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayClaim", "ic");
        claimElem.addAttribute("Uri", uri, null);
        OMElement tagElem = IdentityProviderUtil.createOMElement(claimElem, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag", "ic");
        tagElem.setText(displayTag);
        OMElement valElem = IdentityProviderUtil.createOMElement(claimElem, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayValue", "ic");
        valElem.setText(displayValue);
        return claimElem;
    }

    public static OMElement createOpenIdToken(OMElement parent, GenericIdentityProviderData data) {
        return IdentityProviderUtil.createOMElement(parent, "http://specs.openid.net/auth/2.0", "OpenIDToken", "openid");
    }

    private static OMElement createOMElement(OMElement parent, String ns, String ln, String prefix) {
        return parent.getOMFactory().createOMElement(new QName(ns, ln, prefix), (OMContainer)parent);
    }

    public static String getAppliesToHostName(RahasData data) throws IdentityProviderException {
        if (data.getAppliesToEpr() == null) {
            return null;
        }
        String relyingPartyURI = data.getAppliesToAddress();
        if (relyingPartyURI == null && (relyingPartyURI = data.getAppliesToEpr().getText()) == null) {
            throw new IdentityProviderException("cannotFindRelyingParty");
        }
        URI uri = null;
        try {
            uri = new URI(relyingPartyURI);
        }
        catch (URISyntaxException e) {
            throw new IdentityProviderException("Invalid Uril", (Throwable)e);
        }
        return uri.getHost();
    }
}

