/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.identity.provider;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.sts.common.identity.provider.RequestedClaimData;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class GenericIdentityProviderData {
    public static final String USERMAN_SERVICE = "UserManServiceURL";
    public static final String USER_CLASS = "UserClass";
    private static final Log log = LogFactory.getLog(GenericIdentityProviderData.class);
    protected String cardID = null;
    protected Map<String, RequestedClaimData> requestedClaims = new HashMap<String, RequestedClaimData>();
    protected Map<String, Claim> supportedClaims = new HashMap<String, Claim>();
    protected String displayTokenLang = null;
    protected int authMechanism = -1;
    protected X509Certificate rpCert;
    protected String userIdentifier = null;
    protected String requiredTokenType = null;

    public GenericIdentityProviderData(RahasData data) throws IdentityProviderException, ClassNotFoundException {
        OMElement rstElem = null;
        OMElement claimElem = null;
        rstElem = data.getRstElement();
        claimElem = data.getClaimElem();
        this.readAuthenticationMechanism(data);
        this.processUserIdentifier(data);
        this.loadClaims();
        this.processClaimData(data, claimElem);
        this.processInfoCardReference(rstElem);
        this.readRequestedTokenType(data);
        this.populateClaimValues(data);
        this.extracAndValidatetRPCert(data);
    }

    public String getRequiredTokenType() {
        return this.requiredTokenType;
    }

    public void setRequiredTokenType(String requiredTokenType) {
        this.requiredTokenType = StringUtils.isBlank((String)requiredTokenType) ? this.getDefautTokenType() : requiredTokenType;
    }

    public String getDefautTokenType() {
        return "urn:oasis:names:tc:SAML:1.0:assertion";
    }

    public X509Certificate getRpCert() {
        return this.rpCert;
    }

    public String getUserIdentifier() {
        return null;
    }

    public String getCardID() {
        return null;
    }

    public String getDisplayTokenLang() {
        return null;
    }

    public String getDisplayName(String uri) {
        return null;
    }

    public String getTenantDomain() throws IdentityProviderException {
        return null;
    }

    protected void loadClaims() throws IdentityProviderException {
        IdentityClaimManager claimManager = null;
        Claim[] claims = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading claims");
        }
        try {
            claimManager = IdentityClaimManager.getInstance();
            claims = claimManager.getAllSupportedClaims("http://schemas.xmlsoap.org/ws/2005/05/identity", IdentityTenantUtil.getRealm(null, (String)this.userIdentifier));
            for (int i = 0; i < claims.length; ++i) {
                Claim temp = claims[i];
                this.supportedClaims.put(temp.getClaimUri(), temp);
            }
            Claim tenant = new Claim();
            tenant.setClaimUri("http://wso2.org/claims/tenant");
            tenant.setDescription("Tenant");
            tenant.setDisplayTag("Tenant");
            tenant.setSupportedByDefault(true);
            tenant.setDialectURI("http://wso2.org");
            this.supportedClaims.put(tenant.getClaimUri(), tenant);
        }
        catch (IdentityException e) {
            log.error((Object)"Error while loading claims", (Throwable)e);
            throw new IdentityProviderException("Error while loading claims", (Throwable)e);
        }
    }

    protected void processClaimData(RahasData rahasData, OMElement claims) throws IdentityProviderException {
        if (claims == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing claim data");
        }
        Iterator iterator = null;
        iterator = claims.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimType"));
        while (iterator.hasNext()) {
            OMElement omElem = null;
            RequestedClaimData claim = null;
            String uriClaim = null;
            String optional = null;
            omElem = (OMElement)iterator.next();
            claim = this.getRequestedClaim();
            uriClaim = omElem.getAttributeValue(new QName(null, "Uri"));
            if (uriClaim == null) {
                log.error((Object)"Empty claim uri found while procession claim data");
                throw new IdentityProviderException("Empty claim uri found while procession claim data");
            }
            claim.setUri(uriClaim);
            optional = omElem.getAttributeValue(new QName(null, "Optional"));
            if (StringUtils.isNotBlank((String)optional)) {
                claim.setBOptional("true".equals(optional));
            } else {
                claim.setBOptional(true);
            }
            this.requestedClaims.put(claim.getUri(), claim);
        }
    }

    protected void processInfoCardReference(OMElement rst) throws IdentityProviderException {
    }

    protected void readAuthenticationMechanism(RahasData data) throws IdentityProviderException {
    }

    protected void extracAndValidatetRPCert(RahasData data) throws IdentityProviderException {
    }

    protected void processUserIdentifier(RahasData rahasData) throws IdentityProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing user identifier");
        }
        this.userIdentifier = rahasData.getPrincipal().getName();
    }

    protected void populateClaimValues(RahasData rahasData) throws IdentityProviderException {
        UserStoreManager connector = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Populating claim values");
        }
        try {
            connector = IdentityTenantUtil.getRealm(null, (String)this.userIdentifier).getUserStoreManager();
        }
        catch (Exception e) {
            log.error((Object)"Error while instantiating IdentityUserStore", (Throwable)e);
            throw new IdentityProviderException("Error while instantiating IdentityUserStore", (Throwable)e);
        }
        Iterator<RequestedClaimData> ite = this.requestedClaims.values().iterator();
        ArrayList<String> claimList = new ArrayList<String>();
        while (ite.hasNext()) {
            RequestedClaimData claim = ite.next();
            if (claim == null || claim.getUri().equals("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier") || claim.getUri().equals("http://wso2.org/claims/tenant")) continue;
            claimList.add(claim.getUri());
        }
        String[] claims = new String[claimList.size()];
        String userId = MultitenantUtils.getTenantAwareUsername((String)this.userIdentifier);
        Map mapValues = null;
        try {
            mapValues = connector.getUserClaimValues(userId, claimList.toArray(claims), null);
        }
        catch (Exception e) {
            throw new IdentityProviderException(e.getMessage(), (Throwable)e);
        }
        for (RequestedClaimData claimData : this.requestedClaims.values()) {
            if ("http://wso2.org/claims/tenant".equals(claimData.getUri())) {
                String domainName = null;
                domainName = MultitenantUtils.getTenantDomain((String)this.userIdentifier);
                if (domainName == null) {
                    domainName = "identity.cloud.wso2.com";
                }
                claimData.setValue(domainName);
                continue;
            }
            claimData.setValue((String)mapValues.get(claimData.getUri()));
        }
    }

    protected boolean validateKeyInfo(String issuerInfo, Element keyInfo) throws IdentityProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Validating key info");
        }
        try {
            OMElement elem = new StAXOMBuilder((InputStream)new ByteArrayInputStream(issuerInfo.getBytes())).getDocumentElement();
            OMElement keyValueElem = elem.getFirstElement();
            if (keyValueElem != null && keyValueElem.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyValue"))) {
                OMElement rsaKeyValueElem = keyValueElem.getFirstElement();
                if (rsaKeyValueElem != null && rsaKeyValueElem.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue"))) {
                    String modulus = rsaKeyValueElem.getFirstChildWithName(new QName("http://www.w3.org/2000/09/xmldsig#", "Modulus")).getText().trim();
                    String exponent = rsaKeyValueElem.getFirstChildWithName(new QName("http://www.w3.org/2000/09/xmldsig#", "Exponent")).getText().trim();
                    OMElement receivedKeyInfoElem = (OMElement)new OMDOMFactory().getDocument().importNode((Node)keyInfo, true);
                    OMElement receivedKeyValueElem = receivedKeyInfoElem.getFirstElement();
                    if (receivedKeyValueElem != null && receivedKeyValueElem.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyValue"))) {
                        OMElement receivedRsaKeyValueElem = receivedKeyValueElem.getFirstChildWithName(new QName("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue"));
                        if (receivedRsaKeyValueElem != null) {
                            String receivedModulus = receivedRsaKeyValueElem.getFirstChildWithName(new QName("http://www.w3.org/2000/09/xmldsig#", "Modulus")).getText().trim();
                            String receivedExponent = receivedRsaKeyValueElem.getFirstChildWithName(new QName("http://www.w3.org/2000/09/xmldsig#", "Exponent")).getText().trim();
                            return modulus.equals(receivedModulus) && exponent.equals(receivedExponent);
                        }
                        log.error((Object)"Unknown received KeyInfo type");
                        throw new IdentityProviderException("Unknown received KeyInfo type");
                    }
                    log.error((Object)"Unknown received KeyInfo type");
                    throw new IdentityProviderException("Unknown received KeyInfo type");
                }
                log.error((Object)"Error while instantiating IdentityUserStore");
                throw new IdentityProviderException("Unknown received KeyInfo type");
            }
            log.error((Object)"Unknown stored KeyInfo type");
            throw new IdentityProviderException("Unknown stored KeyInfo type");
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error parsing stored KeyInfo", (Throwable)e);
            throw new IdentityProviderException("Error parsing stored KeyInfo");
        }
    }

    protected void readRequestedTokenType(RahasData data) {
        this.requiredTokenType = data.getTokenType();
        if (this.requiredTokenType == null || this.requiredTokenType.trim().length() == 0) {
            this.requiredTokenType = this.getDefautTokenType();
        }
    }

    public Map<String, RequestedClaimData> getRequestedClaims() {
        return this.requestedClaims;
    }

    public void setRequestedClaims(Map<String, RequestedClaimData> requestedClaims) {
        this.requestedClaims = requestedClaims;
    }

    protected RequestedClaimData getRequestedClaim() {
        return new RequestedClaimData();
    }
}

