/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.identity.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.opensaml.Configuration;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLException;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.sts.common.identity.provider.IdentityAttributeService;
import org.wso2.carbon.identity.sts.common.identity.provider.IdentityAttributeServiceStore;
import org.wso2.carbon.identity.sts.common.identity.provider.RequestedClaimData;
import org.wso2.carbon.identity.sts.common.internal.IdentityProviderSTSServiceComponent;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AttributeCallbackHandler
implements SAMLCallbackHandler {
    private static final Log log = LogFactory.getLog(AttributeCallbackHandler.class);
    protected Map<String, RequestedClaimData> requestedClaims = new HashMap<String, RequestedClaimData>();
    protected Map<String, String> requestedClaimValues = new HashMap<String, String>();
    protected Map<String, Claim> supportedClaims = new HashMap<String, Claim>();
    private String userAttributeSeparator = ",,,";

    public void handle(SAMLCallback callback) throws SAMLException {
        SAMLAttributeCallback attrCallback = null;
        RahasData data = null;
        OMElement claimElem = null;
        String claimDialect = null;
        String userIdentifier = null;
        String[] splitArr = null;
        IdentityAttributeService[] attributeCallbackServices = null;
        String endPointReference = null;
        String spTenantDomain = null;
        if (callback instanceof SAMLAttributeCallback) {
            attrCallback = (SAMLAttributeCallback)callback;
            data = attrCallback.getData();
            claimElem = data.getClaimElem();
            claimDialect = data.getClaimDialect();
            userIdentifier = data.getPrincipal().getName();
            endPointReference = data.getAppliesToAddress();
            spTenantDomain = data.getInMessageContext().getProperty("spTenantDomain") != null ? (String)data.getInMessageContext().getProperty("spTenantDomain") : "carbon.super";
            AuthenticatedUser authenticatedUser = (AuthenticatedUser)data.getInMessageContext().getProperty("AuthenticatedUser");
            if (userIdentifier != null && (splitArr = userIdentifier.split(",")[0].split("=")).length == 2) {
                userIdentifier = splitArr[1];
            }
            if (StringUtils.isNotEmpty((String)claimDialect) && claimElem != null) {
                try {
                    this.processClaimData(data, claimElem);
                    this.loadClaims(claimElem, spTenantDomain);
                    this.populateClaimValues(userIdentifier, attrCallback);
                }
                catch (IdentityProviderException e) {
                    log.error((Object)"Error occurred while populating claim data", (Throwable)e);
                }
                attributeCallbackServices = IdentityAttributeServiceStore.getAttributeServices();
                for (int i = 0; i < attributeCallbackServices.length; ++i) {
                    try {
                        attributeCallbackServices[i].handle(attrCallback);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)"Error occurred while calling attribute callback", (Throwable)e);
                    }
                }
            } else {
                String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                ApplicationManagementService applicationManagementService = IdentityProviderSTSServiceComponent.getApplicationManagementService();
                try {
                    ServiceProvider serviceProvider = applicationManagementService.getServiceProviderByClientId(endPointReference, "wstrust", tenantDomain);
                    ClaimMapping[] claimMappings = serviceProvider.getClaimConfig().getClaimMappings();
                    for (int i = 0; i < claimMappings.length; ++i) {
                        String localClaimUri = claimMappings[i].getLocalClaim().getClaimUri();
                        String remoteClaimUri = claimMappings[i].getRemoteClaim().getClaimUri();
                        if (!StringUtils.isNotBlank((String)localClaimUri) || !StringUtils.isNotBlank((String)remoteClaimUri)) continue;
                        String remoteClaimSuffixValue = remoteClaimUri.substring(remoteClaimUri.lastIndexOf(47) + 1);
                        String remoteClaimPrefixValue = remoteClaimUri.substring(0, remoteClaimUri.lastIndexOf(47));
                        String localClaimValue = null;
                        if (!StringUtils.isNotBlank((String)remoteClaimSuffixValue) || !StringUtils.isNotBlank((String)remoteClaimPrefixValue)) continue;
                        if (this.isHandlerCalledFromWSTrustSTSFlow(attrCallback)) {
                            localClaimValue = IdentityProviderSTSServiceComponent.getRealmService().getBootstrapRealm().getUserStoreManager().getUserClaimValue(userIdentifier, localClaimUri, "default");
                        } else if (!authenticatedUser.isFederatedUser()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Loading claim values from local UserStore for user: " + authenticatedUser.toString()));
                            }
                            localClaimValue = IdentityProviderSTSServiceComponent.getRealmService().getBootstrapRealm().getUserStoreManager().getUserClaimValue(userIdentifier, localClaimUri, "default");
                        }
                        if (StringUtils.isEmpty(localClaimValue)) {
                            localClaimValue = new String();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Claim Values haven't properly set");
                            }
                        }
                        SAMLAttribute attribute = new SAMLAttribute(remoteClaimSuffixValue, remoteClaimPrefixValue, null, -1L, Arrays.asList(localClaimValue));
                        attrCallback.addAttributes(attribute);
                    }
                }
                catch (IdentityApplicationManagementException e) {
                    throw new SAMLException("Error while loading SP specific claims", (Exception)((Object)e));
                }
                catch (UserStoreException e) {
                    throw new SAMLException("Error while loading claims of the user", (Exception)((Object)e));
                }
            }
        }
    }

    private Attribute getSAML2Attribute(String name, String value, String namespace) {
        XMLObjectBuilderFactory builderFactory = null;
        SAMLObjectBuilder attrBuilder = null;
        Attribute attribute = null;
        XSStringBuilder attributeValueBuilder = null;
        XSString stringValue = null;
        builderFactory = Configuration.getBuilderFactory();
        attrBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        attribute = (Attribute)attrBuilder.buildObject();
        attribute.setName(name);
        attribute.setNameFormat(namespace);
        attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
        stringValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        stringValue.setValue(value);
        attribute.getAttributeValues().add(stringValue);
        return attribute;
    }

    private void loadClaims(OMElement claimsElement, String spTenantDomain) throws IdentityProviderException {
        String claimDialect = null;
        if (claimsElement.getNamespace() != null) {
            claimDialect = claimsElement.getAttributeValue(new QName(claimsElement.getNamespace().getNamespaceURI(), "Dialect"));
        }
        if (claimDialect == null || claimDialect.trim().length() == 0) {
            claimDialect = "http://wso2.org/claims";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading claims");
        }
        try {
            IdentityClaimManager claimManager = IdentityClaimManager.getInstance();
            Claim[] claims = claimManager.getAllSupportedClaims(claimDialect, IdentityTenantUtil.getRealm((String)spTenantDomain, null));
            for (int i = 0; i < claims.length; ++i) {
                Claim temp = claims[i];
                this.supportedClaims.put(temp.getClaimUri(), temp);
            }
        }
        catch (IdentityException e) {
            log.error((Object)"Error while loading claims", (Throwable)e);
            throw new IdentityProviderException("Error while loading claims", (Throwable)e);
        }
    }

    protected void loadClaims(String userIdentifier) throws IdentityProviderException {
        IdentityClaimManager claimManager = null;
        Claim[] claims = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading claims");
        }
        try {
            claimManager = IdentityClaimManager.getInstance();
            claims = claimManager.getAllSupportedClaims("http://wso2.org/claims", IdentityTenantUtil.getRealm(null, (String)userIdentifier));
            for (int i = 0; i < claims.length; ++i) {
                Claim temp = claims[i];
                this.supportedClaims.put(temp.getClaimUri(), temp);
            }
        }
        catch (IdentityException e) {
            log.error((Object)"Error while loading claims", (Throwable)e);
            throw new IdentityProviderException("Error while loading claims", (Throwable)e);
        }
    }

    protected void processClaimData(RahasData rahasData, OMElement claims) throws IdentityProviderException {
        if (claims == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing claim data");
        }
        Iterator iterator = null;
        iterator = claims.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimType"));
        while (iterator.hasNext()) {
            OMElement omElem = null;
            RequestedClaimData claim = null;
            String uriClaim = null;
            String optional = null;
            omElem = (OMElement)iterator.next();
            claim = this.getRequestedClaim();
            uriClaim = omElem.getAttributeValue(new QName(null, "Uri"));
            if (uriClaim == null) {
                log.error((Object)"Empty claim uri found while procession claim data");
                throw new IdentityProviderException("Empty claim uri found while procession claim data");
            }
            if (uriClaim.startsWith("{") && uriClaim.endsWith("}") && uriClaim.lastIndexOf("|") == uriClaim.indexOf("|")) {
                String tmpUri = uriClaim;
                uriClaim = uriClaim.substring(1, uriClaim.indexOf("|"));
                String claimValue = tmpUri.substring(tmpUri.indexOf("|") + 1, tmpUri.length() - 1);
                this.requestedClaimValues.put(uriClaim, claimValue);
            }
            claim.setUri(uriClaim);
            optional = omElem.getAttributeValue(new QName(null, "Optional"));
            if (StringUtils.isNotBlank((String)optional)) {
                claim.setBOptional("true".equals(optional));
            } else {
                claim.setBOptional(true);
            }
            this.requestedClaims.put(claim.getUri(), claim);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void populateClaimValues(String userIdentifier, SAMLAttributeCallback callback) throws IdentityProviderException {
        connector = null;
        rahasData = null;
        if (AttributeCallbackHandler.log.isDebugEnabled()) {
            AttributeCallbackHandler.log.debug((Object)"Populating claim values");
        }
        if (this.requestedClaims.isEmpty()) {
            return;
        }
        ite = this.requestedClaims.values().iterator();
        claimList = new ArrayList<String>();
        rahasData = callback.getData();
        authenticatedUser = (AuthenticatedUser)rahasData.getInMessageContext().getProperty("AuthenticatedUser");
        while (ite.hasNext()) {
            claim = ite.next();
            if (claim == null || claim.getUri().equals("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier")) continue;
            claimList.add(claim.getUri());
        }
        claimArray = new String[claimList.size()];
        userId = userIdentifier;
        mapValues = null;
        try {
            if (MapUtils.isEmpty(this.requestedClaimValues)) {
                try {
                    if (this.isHandlerCalledFromWSTrustSTSFlow(callback)) {
                        connector = IdentityTenantUtil.getRealm(null, (String)userId).getUserStoreManager();
                        mapValues = connector.getUserClaimValues(MultitenantUtils.getTenantAwareUsername((String)userId), claimList.toArray(claimArray), null);
                    }
                    if (authenticatedUser.isFederatedUser()) ** GOTO lbl36
                    if (AttributeCallbackHandler.log.isDebugEnabled()) {
                        AttributeCallbackHandler.log.debug((Object)("Loading claim values from local UserStore for user: " + authenticatedUser.toString()));
                    }
                    connector = IdentityTenantUtil.getRealm((String)authenticatedUser.getTenantDomain(), null).getUserStoreManager();
                    mapValues = connector.getUserClaimValues(MultitenantUtils.getTenantAwareUsername((String)userId), claimList.toArray(claimArray), null);
                }
                catch (org.wso2.carbon.user.api.UserStoreException e) {
                    throw new IdentityProviderException("Error while instantiating IdentityUserStore", (Throwable)e);
                }
            } else {
                mapValues = this.requestedClaimValues;
            }
lbl36:
            // 4 sources

            claimSeparator = mapValues.get("MultiAttributeSeparator");
            if (StringUtils.isNotBlank((String)claimSeparator)) {
                this.userAttributeSeparator = claimSeparator;
                mapValues.remove("MultiAttributeSeparator");
            }
            ite = this.requestedClaims.values().iterator();
            while (ite.hasNext()) {
                attribute = null;
                saml2Attribute = null;
                claimData = ite.next();
                claimData.setValue((String)mapValues.get(claimData.getUri()));
                if (claimData.getValue() == null) continue;
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(rahasData.getTokenType())) {
                    saml2Attribute = this.getSAML2Attribute(claimData.getUri(), claimData.getValue(), claimData.getUri());
                    callback.addAttributes(saml2Attribute);
                    continue;
                }
                if (this.supportedClaims.get(claimData.getUri()) != null) {
                    name = this.supportedClaims.get(claimData.getUri()).getDisplayTag();
                    nameSpace = claimData.getUri();
                } else {
                    nameSpace = claimData.getUri();
                    if (nameSpace.contains("/") && nameSpace.length() > nameSpace.lastIndexOf("/") + 1) {
                        name = nameSpace.substring(nameSpace.lastIndexOf("/") + 1);
                        nameSpace = nameSpace.substring(0, nameSpace.lastIndexOf("/"));
                    } else {
                        name = nameSpace;
                    }
                }
                values = new ArrayList<String>();
                if (claimData.getValue().contains(this.userAttributeSeparator)) {
                    st = new StringTokenizer(claimData.getValue(), this.userAttributeSeparator);
                    while (st.hasMoreElements()) {
                        attValue = st.nextElement().toString();
                        if (attValue == null || attValue.trim().length() <= 0) continue;
                        values.add(attValue);
                    }
                } else {
                    values.add(claimData.getValue());
                }
                attribute = new SAMLAttribute(name, nameSpace, null, -1L, values);
                callback.addAttributes(attribute);
            }
        }
        catch (Exception e) {
            throw new IdentityProviderException(e.getMessage(), (Throwable)e);
        }
    }

    protected RequestedClaimData getRequestedClaim() {
        return new RequestedClaimData();
    }

    private boolean isHandlerCalledFromWSTrustSTSFlow(SAMLAttributeCallback attributeCallback) {
        return !(attributeCallback.getData().getInMessageContext().getProperty("AuthenticatedUser") instanceof AuthenticatedUser);
    }
}

