/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.deployment;

import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.sts.common.deployment.SecurityDeploymentInterceptor;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class SecurityDeploymentListener
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(SecurityDeploymentListener.class);

    public void createdConfigurationContext(ConfigurationContext configCtx) {
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        SecurityDeploymentInterceptor secDeployInterceptor = new SecurityDeploymentInterceptor();
        secDeployInterceptor.init(axisConfig);
        axisConfig.addObservers((AxisObserver)secDeployInterceptor);
        Map policyResourceMap = SecurityServiceHolder.getPolicyResourceMap();
        try {
            UserRegistry registry = SecurityServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            for (Map.Entry resourceLocEntry : policyResourceMap.entrySet()) {
                if (registry.resourceExists((String)resourceLocEntry.getKey())) continue;
                registry.put((String)resourceLocEntry.getKey(), (Resource)resourceLocEntry.getValue());
            }
            if (!transactionStarted) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            String errorMsg = "Error when storing the policy resource in registry for tenant : " + tenantId;
            log.error((Object)errorMsg, (Throwable)e);
        }
    }
}

