/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.sts.common.SecurityConfigParams;
import org.wso2.carbon.identity.sts.common.SecurityScenario;
import org.wso2.carbon.identity.sts.common.SecurityScenarioDatabase;
import org.wso2.carbon.identity.sts.common.deployment.SecurityDeploymentListener;
import org.wso2.carbon.identity.sts.common.util.RahasUtil;
import org.wso2.carbon.identity.sts.common.util.SecurityConfigParamBuilder;
import org.wso2.carbon.identity.sts.common.util.ServerCrypto;
import org.wso2.carbon.identity.sts.common.util.ServicePasswordCallbackHandler;
import org.wso2.carbon.identity.sts.common.util.XmlConfiguration;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.SecurityConstants;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.PreAxisConfigurationPopulationObserver;
import org.wso2.carbon.utils.ServerException;

@Component(name="SecurityDeploymentInterceptor", immediate=true)
public class SecurityDeploymentInterceptor
implements AxisObserver {
    private static final Log log = LogFactory.getLog(SecurityDeploymentInterceptor.class);
    private static final String NO_POLICY_ID = "NoPolicy";
    private static final String APPLY_POLICY_TO_BINDINGS = "applyPolicyToBindings";

    @Activate
    protected void activate(ComponentContext ctxt) {
        BundleContext bundleCtx = ctxt.getBundleContext();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain("carbon.super");
            carbonContext.setTenantId(-1234);
            this.loadSecurityScenarios((Registry)SecurityServiceHolder.getRegistryService().getConfigSystemRegistry(), bundleCtx);
        }
        catch (Exception e) {
            String msg = "Cannot load security scenarios";
            log.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("org.apache.axis2.osgi.config.service", AxisObserver.class.getName());
        bundleCtx.registerService(AxisObserver.class.getName(), (Object)this, props);
        PreAxisConfigurationPopulationObserver preAxisConfigObserver = new PreAxisConfigurationPopulationObserver(){

            public void createdAxisConfiguration(AxisConfiguration axisConfiguration) {
                SecurityDeploymentInterceptor.this.init(axisConfiguration);
                axisConfiguration.addObservers((AxisObserver)SecurityDeploymentInterceptor.this);
            }
        };
        bundleCtx.registerService(PreAxisConfigurationPopulationObserver.class.getName(), (Object)preAxisConfigObserver, null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("org.apache.axis2.osgi.config.service", Axis2ConfigurationContextObserver.class.getName());
        bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new SecurityDeploymentListener(), properties);
    }

    public void init(AxisConfiguration axisConfig) {
    }

    public void moduleUpdate(AxisEvent event, AxisModule module) {
    }

    public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
    }

    public void serviceUpdate(AxisEvent axisEvent, AxisService axisService) {
        block16: {
            if (axisEvent.getEventType() == 1) {
                Policy policy = null;
                if (axisEvent.getEventType() == 1 && "wso2carbon-sts".equals(axisService.getName())) {
                    try {
                        this.applyPolicyToSTS(axisService);
                    }
                    catch (SecurityConfigException e) {
                        log.error((Object)"Error while applying policy to STS Service", (Throwable)e);
                    }
                    catch (AxisFault axisFault) {
                        log.error((Object)"Error while applying policy to STS Service", (Throwable)axisFault);
                    }
                }
                try {
                    policy = this.applyPolicyToBindings(axisService);
                    if (policy != null) {
                        this.processPolicy(axisService, policy.getId(), (PolicyComponent)policy);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while adding policies to bindings", (Throwable)e);
                }
                try {
                    if (axisService.getPolicySubject() != null && axisService.getPolicySubject().getAttachedPolicyComponents() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Policies found on axis service");
                        }
                        Iterator iterator = axisService.getPolicySubject().getAttachedPolicyComponents().iterator();
                        String policyId = null;
                        while (iterator.hasNext()) {
                            PolicyComponent currentPolicyComponent = (PolicyComponent)iterator.next();
                            if (currentPolicyComponent instanceof Policy) {
                                policyId = ((Policy)currentPolicyComponent).getId();
                            } else if (currentPolicyComponent instanceof PolicyReference) {
                                policyId = ((PolicyReference)currentPolicyComponent).getURI().substring(1);
                            }
                            this.processPolicy(axisService, policyId, currentPolicyComponent);
                        }
                        break block16;
                    }
                    return;
                }
                catch (Exception e) {
                    String msg = "Cannot handle service DEPLOY event for service: " + axisService.getName();
                    log.error((Object)msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
            }
        }
    }

    private void processPolicy(AxisService axisService, String policyId, PolicyComponent currentPolicyComponent) throws UserStoreException, AxisFault {
        AxisConfiguration axisConfiguration = null;
        if (StringUtils.isNotEmpty((String)policyId) && NO_POLICY_ID.equalsIgnoreCase(policyId)) {
            if (axisService != null) {
                UserRealm userRealm = (UserRealm)PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm();
                String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
                String serviceName = axisService.getName();
                this.removeAuthorization(userRealm, serviceGroupId, serviceName);
                axisConfiguration = axisService.getAxisConfiguration();
            }
            if (axisConfiguration != null) {
                AxisModule module = axisConfiguration.getModule("rampart");
                axisService.disengageModule(module);
                return;
            }
            throw new UserStoreException("Error in getting Axis configuration.");
        }
        if (policyId != null && this.isSecPolicy(policyId)) {
            SecurityScenario scenario;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy " + policyId + " is identified as a security policy and trying to apply security parameters"));
            }
            if ((scenario = SecurityScenarioDatabase.getByWsuId(policyId)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Policy " + policyId + " does not belongs to a pre-defined security scenario. So treating as a custom policy"));
                }
                SecurityScenario securityScenario = new SecurityScenario();
                securityScenario.setScenarioId("customScenario");
                securityScenario.setWsuId(policyId);
                securityScenario.setGeneralPolicy(false);
                securityScenario.setSummary("Custom security policy");
                SecurityScenarioDatabase.put(policyId, securityScenario);
                scenario = securityScenario;
            }
            this.applySecurityParameters(axisService, scenario, (Policy)currentPolicyComponent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadSecurityScenarios(Registry registry, BundleContext bundleContext) throws CarbonException, IOException, org.wso2.carbon.registry.core.exceptions.RegistryException {
        URL resource = bundleContext.getBundle().getResource("/scenarios/scenario-config.xml");
        if (resource == null) throw new CarbonException("Can't find the resource url");
        XmlConfiguration xmlConfiguration = new XmlConfiguration(resource.openStream(), "http://www.wso2.org/products/carbon/security");
        OMElement[] elements = xmlConfiguration.getElements("//ns:Scenario");
        try {
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            for (OMElement scenarioEle : elements) {
                SecurityScenario scenario = new SecurityScenario();
                String scenarioId = scenarioEle.getAttribute(SecurityConstants.ID_QN).getAttributeValue();
                scenario.setScenarioId(scenarioId);
                scenario.setSummary(scenarioEle.getFirstChildWithName(SecurityConstants.SUMMARY_QN).getText());
                scenario.setDescription(scenarioEle.getFirstChildWithName(SecurityConstants.DESCRIPTION_QN).getText());
                scenario.setCategory(scenarioEle.getFirstChildWithName(SecurityConstants.CATEGORY_QN).getText());
                scenario.setWsuId(scenarioEle.getFirstChildWithName(SecurityConstants.WSUID_QN).getText());
                scenario.setType(scenarioEle.getFirstChildWithName(SecurityConstants.TYPE_QN).getText());
                String resourceUri = "/repository/components/org.wso2.carbon.security.mgt/policy/" + scenarioId;
                Iterator modules = scenarioEle.getFirstChildWithName(SecurityConstants.MODULES_QN).getChildElements();
                while (modules.hasNext()) {
                    String module = ((OMElement)modules.next()).getText();
                    scenario.addModule(module);
                }
                SecurityScenarioDatabase.put(scenarioId, scenario);
                if (scenarioId.equals("DisableSecurity") || scenarioId.equals("policyFromRegistry")) continue;
                ResourceImpl scenarioResource = new ResourceImpl();
                scenarioResource.setContentStream(bundleContext.getBundle().getResource("scenarios/" + scenarioId + "-policy.xml").openStream());
                scenarioResource.setMediaType("application/policy+xml");
                if (!registry.resourceExists(resourceUri)) {
                    registry.put(resourceUri, (Resource)scenarioResource);
                }
                SecurityServiceHolder.addPolicyResource((String)resourceUri, (Resource)scenarioResource);
            }
            if (transactionStarted) return;
            registry.commitTransaction();
            return;
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw e;
        }
    }

    private void applySecurityParameters(AxisService service, SecurityScenario secScenario, Policy policy) {
        try {
            String allowRolesProxyParamValue;
            UserRealm userRealm = (UserRealm)PrivilegedCarbonContext.getThreadLocalCarbonContext().getUserRealm();
            UserRegistry govRegistry = (UserRegistry)PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
            String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
            String serviceName = service.getName();
            SecurityConfigParams configParams = SecurityConfigParamBuilder.getSecurityParams(this.getSecurityConfig(policy));
            if (secScenario.getModules().contains("rahas")) {
                AxisModule trustModule = service.getAxisConfiguration().getModule("rahas");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Enabling trust module : rahas");
                }
                service.disengageModule(trustModule);
                service.engageModule(trustModule);
                Properties cryptoProps = new Properties();
                cryptoProps.setProperty("org.wso2.carbon.security.crypto.privatestore", configParams.getPrivateStore());
                cryptoProps.setProperty("org.wso2.carbon.security.crypto.alias", configParams.getKeyAlias());
                if (configParams.getTrustStores() != null) {
                    cryptoProps.setProperty("org.wso2.carbon.security.crypto.truststores", configParams.getTrustStores());
                }
                service.addParameter(RahasUtil.getSCTIssuerConfigParameter(ServerCrypto.class.getName(), cryptoProps, -1, null, true, true));
                service.addParameter(RahasUtil.getTokenCancelerConfigParameter());
            }
            AuthorizationManager manager = userRealm.getAuthorizationManager();
            String resourceName = serviceGroupId + "/" + serviceName;
            this.removeAuthorization(userRealm, serviceGroupId, serviceName);
            String allowRolesParameter = configParams.getAllowedRoles();
            Parameter allowRolesProxyParam = service.getParameter("allowRoles");
            String string = allowRolesProxyParamValue = allowRolesProxyParam == null ? null : allowRolesProxyParam.getValue().toString();
            if (!StringUtils.isEmpty((String)allowRolesProxyParamValue)) {
                allowRolesParameter = StringUtils.isEmpty((String)allowRolesParameter) ? allowRolesProxyParamValue : allowRolesParameter + ',' + allowRolesProxyParamValue;
            }
            if (allowRolesParameter != null) {
                String[] allowRoles;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Authorizing roles " + allowRolesParameter));
                }
                if ((allowRoles = allowRolesParameter.split(",")) != null) {
                    for (String role : allowRoles) {
                        manager.authorizeRole(role, resourceName, "invoke-service");
                    }
                }
            }
            ServicePasswordCallbackHandler handler = new ServicePasswordCallbackHandler(configParams, serviceGroupId, serviceName, (Registry)govRegistry, userRealm);
            Parameter param = new Parameter();
            param.setName("passwordCallbackRef");
            param.setValue((Object)handler);
            service.addParameter(param);
        }
        catch (Throwable e) {
            String msg = "Cannot apply security parameters";
            log.error((Object)msg, e);
        }
    }

    private OMElement getSecurityConfig(Policy policy) {
        for (PolicyComponent component : policy.getPolicyComponents()) {
            OMElement value;
            if (!(component instanceof XmlPrimtiveAssertion) || (value = ((XmlPrimtiveAssertion)component).getValue()) == null || !SecurityConfigParamBuilder.SECURITY_CONFIG_QNAME.equals(value.getQName())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Carbon Security config found : " + value.toString()));
            }
            return value;
        }
        return null;
    }

    public void addParameter(Parameter param) throws AxisFault {
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
    }

    public Parameter getParameter(String name) {
        return null;
    }

    public ArrayList getParameters() {
        return new ArrayList();
    }

    public boolean isParameterLocked(String parameterName) {
        return false;
    }

    public void removeParameter(Parameter param) throws AxisFault {
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        SecurityServiceHolder.setRegistryService((RegistryService)registryService);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        SecurityServiceHolder.setRealmService((RealmService)realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        SecurityServiceHolder.setRealmService(null);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        SecurityServiceHolder.setRegistryService(null);
    }

    private boolean isSecPolicy(String policyId) {
        if ("RMPolicy".equals(policyId) || "WSO2CachingPolicy".equals(policyId) || "WSO2ServiceThrottlingPolicy".equals(policyId)) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Policy ID : " + policyId + " is identified as a security policy"));
        }
        return true;
    }

    private void removeAuthorization(UserRealm userRealm, String serviceGroupId, String serviceName) throws UserStoreException {
        String resourceName;
        AuthorizationManager manager = userRealm.getAuthorizationManager();
        String[] roles = manager.getAllowedRolesForResource(resourceName = serviceGroupId + "/" + serviceName, "invoke-service");
        if (roles != null) {
            for (String role : roles) {
                manager.clearRoleAuthorization(role, resourceName, "invoke-service");
            }
        }
    }

    private void applyPolicyToSTS(AxisService service) throws SecurityConfigException, AxisFault {
        try {
            Resource resource;
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            UserRegistry configRegistry = SecurityServiceHolder.getRegistryService().getConfigSystemRegistry(tenantId);
            String servicePath = this.getRegistryServicePath(service);
            Parameter param = new Parameter();
            param.setName(APPLY_POLICY_TO_BINDINGS);
            param.setValue((Object)Boolean.TRUE.toString());
            service.addParameter(param);
            String policyResourcePath = servicePath + "/policies/";
            if (configRegistry.resourceExists(policyResourcePath) && (resource = configRegistry.get(policyResourcePath)) instanceof Collection) {
                for (String policyPath : ((Collection)resource).getChildren()) {
                    Resource res = configRegistry.get(policyPath);
                    Policy policy = this.loadPolicy(res);
                    service.getPolicySubject().attachPolicy(policy);
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error occurred while persisting policy", (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error occurred while persisting policy", (Throwable)e);
        }
    }

    private Policy loadPolicy(Resource resource) throws RegistryException, XMLStreamException {
        InputStream in = resource.getContentStream();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        XMLStreamReader parser = xmlInputFactory.createXMLStreamReader(in);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement policyElement = builder.getDocumentElement();
        return PolicyEngine.getPolicy((OMElement)policyElement);
    }

    private String getRegistryServicePath(AxisService service) {
        StringBuilder pathValue = new StringBuilder();
        return pathValue.append("/repository/axis2/service-groups/").append(service.getAxisServiceGroup().getServiceGroupName()).append("/services/").append(service.getName()).toString();
    }

    public PolicySubject getPolicySubjectFromBindings(AxisService service) {
        return null;
    }

    public void addPolicyToAllBindings(AxisService axisService, Policy policy) throws ServerException {
        try {
            if (policy.getId() == null) {
                policy.setId(UUIDGenerator.getUUID());
            }
            Map endPointMap = axisService.getEndpoints();
            for (Map.Entry o : endPointMap.entrySet()) {
                Map.Entry entry = o;
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                AxisBinding binding = point.getBinding();
                String bindingName = binding.getName().getLocalPart();
                if (bindingName.endsWith("HttpBinding") && !policy.getAttributes().containsValue("UTOverTransport")) continue;
                binding.getPolicySubject().attachPolicy(policy);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in adding security policy to all bindings", (Throwable)e);
            throw new ServerException("addPoliciesToService", (Throwable)e);
        }
    }

    private Policy applyPolicyToBindings(AxisService axisService) throws ServerException {
        Parameter parameter = axisService.getParameter(APPLY_POLICY_TO_BINDINGS);
        if (parameter != null && "true".equalsIgnoreCase(parameter.getValue().toString()) && axisService.getPolicySubject() != null && axisService.getPolicySubject().getAttachedPolicyComponents() != null) {
            for (PolicyComponent currentPolicyComponent : axisService.getPolicySubject().getAttachedPolicyComponents()) {
                if (!(currentPolicyComponent instanceof Policy)) continue;
                Policy policy = (Policy)currentPolicyComponent;
                String policyId = policy.getId();
                axisService.getPolicySubject().detachPolicyComponent(policyId);
                this.addPolicyToAllBindings(axisService, policy);
                return policy;
            }
        }
        return null;
    }
}

