/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.config.service;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.sts.common.SecurityScenario;
import org.wso2.carbon.identity.sts.common.SecurityScenarioDatabase;
import org.wso2.carbon.identity.sts.common.config.SecurityConfigAdmin;
import org.wso2.carbon.identity.sts.common.config.service.KerberosConfigData;
import org.wso2.carbon.identity.sts.common.config.service.SecurityConfigData;
import org.wso2.carbon.identity.sts.common.config.service.SecurityScenarioData;
import org.wso2.carbon.identity.sts.common.config.service.SecurityScenarioDataWrapper;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.user.core.UserRealm;

public class SecurityConfigAdminService
extends AbstractAdmin {
    protected UserRealm getUserRealm() {
        return (UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
    }

    public void activateUsernameTokenAuthentication(String serviceName, String[] userGroups) throws SecurityConfigException {
        SecurityConfigAdmin admin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig());
        admin.activateUsernameTokenAuthentication(serviceName, userGroups);
    }

    public void disableSecurityOnService(String serviceName) throws SecurityConfigException {
        SecurityConfigAdmin admin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig());
        admin.disableSecurityOnService(serviceName);
    }

    public void applySecurity(String serviceName, String policyId, String policyPath, String[] trustedStores, String privateStore, String[] userGroupNames) throws SecurityConfigException {
        SecurityConfigAdmin admin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig());
        admin.applySecurity(serviceName, policyId, policyPath, trustedStores, privateStore, userGroupNames);
    }

    public void applyKerberosSecurityPolicy(String serviceName, String policyId, String servicePrincipalName, String servicePrincipalPassword) throws SecurityConfigException {
        if (servicePrincipalName == null || StringUtils.equals((String)"".trim(), (String)servicePrincipalName)) {
            throw new SecurityConfigException("Please specify a valid service principal. Service principal should not be null");
        }
        if (servicePrincipalPassword == null || StringUtils.equals((String)"".trim(), (String)servicePrincipalPassword)) {
            throw new SecurityConfigException("Please specify a valid service principal password. Service principal password should not be null");
        }
        SecurityConfigAdmin admin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig());
        KerberosConfigData kerberosConfigurations = new KerberosConfigData();
        kerberosConfigurations.setServicePrincipleName(servicePrincipalName);
        kerberosConfigurations.setServicePrinciplePassword(servicePrincipalPassword);
        admin.applySecurity(serviceName, policyId, kerberosConfigurations);
    }

    public SecurityScenarioDataWrapper getScenarios(String serviceName) throws SecurityConfigException {
        Collection<SecurityScenario> scenarios = SecurityScenarioDatabase.getAllScenarios();
        SecurityScenarioData[] scenarioData = new SecurityScenarioData[scenarios.size()];
        int count = 0;
        for (SecurityScenario scenario : scenarios) {
            if (!scenario.getGeneralPolicy()) continue;
            SecurityScenarioData data = new SecurityScenarioData();
            data.setCategory(scenario.getCategory());
            data.setCurrentScenario(scenario.getIsCurrentScenario());
            data.setDescription(scenario.getDescription());
            data.setScenarioId(scenario.getScenarioId());
            data.setSummary(scenario.getSummary());
            data.setType(scenario.getType());
            scenarioData[count++] = data;
        }
        SecurityScenarioDataWrapper scenarioDataWrapper = new SecurityScenarioDataWrapper();
        scenarioDataWrapper.setScenarios(scenarioData);
        scenarioDataWrapper.setCurrentScenario(this.getCurrentScenario(serviceName));
        return scenarioDataWrapper;
    }

    private SecurityScenarioData getCurrentScenario(String serviceName) throws SecurityConfigException {
        SecurityConfigAdmin admin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig());
        admin.forceActualServiceDeployment(serviceName);
        return admin.getCurrentScenario(serviceName);
    }

    public SecurityScenarioData getSecurityScenario(String sceneId) throws SecurityConfigException {
        SecurityConfigAdmin admin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig());
        return admin.getSecurityScenario(sceneId);
    }

    public SecurityConfigData getSecurityConfigData(String serviceName, String scenarioId, String policyPath) throws SecurityConfigException {
        SecurityConfigAdmin admin = new SecurityConfigAdmin(this.getUserRealm(), this.getConfigSystemRegistry(), this.getAxisConfig());
        return admin.getSecurityConfigData(serviceName, scenarioId, policyPath);
    }
}

