/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.config;

import java.util.Map;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.utils.ServerException;

public class SecurityServiceAdmin {
    private static final Log log = LogFactory.getLog(SecurityServiceAdmin.class);
    protected AxisConfiguration axisConfig = null;

    public SecurityServiceAdmin(AxisConfiguration config) throws ServerException {
        this.axisConfig = config;
    }

    public SecurityServiceAdmin(AxisConfiguration config, Registry registry) {
        this.axisConfig = config;
    }

    public void addSecurityPolicyToAllBindings(AxisService axisService, Policy policy) throws ServerException {
        try {
            if (policy.getId() == null) {
                policy.setId(UUIDGenerator.getUUID());
            }
            Map endPointMap = axisService.getEndpoints();
            for (Map.Entry o : endPointMap.entrySet()) {
                Map.Entry entry = o;
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                AxisBinding binding = point.getBinding();
                String bindingName = binding.getName().getLocalPart();
                if (bindingName.endsWith("HttpBinding") && !policy.getAttributes().containsValue("UTOverTransport")) continue;
                binding.getPolicySubject().attachPolicy(policy);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in adding security policy to all bindings", (Throwable)e);
            throw new ServerException("addPoliciesToService", (Throwable)e);
        }
    }

    public void removeSecurityPolicyFromAllBindings(AxisService axisService, String uuid) throws ServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removing  security policy from all bindings.");
        }
        Map endPointMap = axisService.getEndpoints();
        for (Map.Entry o : endPointMap.entrySet()) {
            Map.Entry entry = o;
            AxisEndpoint point = (AxisEndpoint)entry.getValue();
            AxisBinding binding = point.getBinding();
            if (binding.getPolicySubject().getAttachedPolicyComponent(uuid) == null) continue;
            binding.getPolicySubject().detachPolicyComponent(uuid);
        }
    }

    public void setServiceParameterElement(String serviceName, Parameter parameter) throws AxisFault {
        AxisService axisService = this.axisConfig.getService(serviceName);
        if (axisService == null) {
            throw new AxisFault("Invalid service name '" + serviceName + "'");
        }
        Parameter p = axisService.getParameter(parameter.getName());
        if (p != null) {
            if (!p.isLocked()) {
                axisService.addParameter(parameter);
            }
        } else {
            axisService.addParameter(parameter);
        }
    }
}

