/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common.config;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.apache.rampart.policy.RampartPolicyBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.KerberosConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.Token;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.sts.common.SecurityConfigParams;
import org.wso2.carbon.identity.sts.common.SecurityScenario;
import org.wso2.carbon.identity.sts.common.SecurityScenarioDatabase;
import org.wso2.carbon.identity.sts.common.config.SecurityServiceAdmin;
import org.wso2.carbon.identity.sts.common.config.service.KerberosConfigData;
import org.wso2.carbon.identity.sts.common.config.service.SecurityConfigData;
import org.wso2.carbon.identity.sts.common.config.service.SecurityScenarioData;
import org.wso2.carbon.identity.sts.common.internal.SecurityMgtServiceComponent;
import org.wso2.carbon.identity.sts.common.util.RahasUtil;
import org.wso2.carbon.identity.sts.common.util.SecurityConfigParamBuilder;
import org.wso2.carbon.identity.sts.common.util.SecurityTokenStore;
import org.wso2.carbon.identity.sts.common.util.ServerCrypto;
import org.wso2.carbon.identity.sts.common.util.ServicePasswordCallbackHandler;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.SecurityConstants;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ServerException;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class SecurityConfigAdmin {
    public static final String USER = "rampart.config.user";
    public static final String IDENTITY_CONFIG_DIR = "identity";
    public static final String DISABLE_REST = "disableREST";
    public static final String POLICY_PATH = "policyPath";
    private static final String SEC_LABEL = "sec";
    private static final Log log = LogFactory.getLog(SecurityConfigAdmin.class);
    private AxisConfiguration axisConfig = null;
    private CallbackHandler callback = null;
    private Registry registry = null;
    private UserRegistry govRegistry = null;
    private UserRealm realm = null;

    public SecurityConfigAdmin(AxisConfiguration config) throws SecurityConfigException {
        this.axisConfig = config;
        try {
            this.registry = SecurityServiceHolder.getRegistryService().getConfigSystemRegistry();
            this.govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry();
        }
        catch (Exception e) {
            String msg = "Error when retrieving a registry instance";
            log.error((Object)msg);
            throw new SecurityConfigException(msg, (Throwable)e);
        }
    }

    public SecurityConfigAdmin(AxisConfiguration config, Registry reg, CallbackHandler cb) {
        this.axisConfig = config;
        this.registry = reg;
        this.callback = cb;
        try {
            this.govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(((UserRegistry)reg).getTenantId());
        }
        catch (Exception e) {
            log.error((Object)"Error when obtaining the governance registry instance.", (Throwable)e);
        }
    }

    public SecurityConfigAdmin(UserRealm realm, Registry registry, AxisConfiguration config) throws SecurityConfigException {
        this.axisConfig = config;
        this.registry = registry;
        this.realm = realm;
        try {
            this.govRegistry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry(((UserRegistry)registry).getTenantId());
        }
        catch (Exception e) {
            log.error((Object)"Error when obtaining the governance registry instance.");
            throw new SecurityConfigException("Error when obtaining the governance registry instance.", (Throwable)e);
        }
    }

    public SecurityScenarioData getSecurityScenario(String sceneId) throws SecurityConfigException {
        SecurityScenarioData data = null;
        SecurityScenario scenario = SecurityScenarioDatabase.get(sceneId);
        if (scenario != null) {
            data = new SecurityScenarioData();
            data.setCategory(scenario.getCategory());
            data.setDescription(scenario.getDescription());
            data.setScenarioId(scenario.getScenarioId());
            data.setSummary(scenario.getSummary());
        }
        return data;
    }

    public SecurityScenarioData getCurrentScenario(String serviceName) throws SecurityConfigException {
        String policyPath;
        Parameter param;
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        SecurityScenarioData data = null;
        if (service == null) {
            try {
                service = (AxisService)GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.axisConfig).get(serviceName);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while reading Transit Ghosts map", (Throwable)axisFault);
            }
            if (service == null) {
                throw new SecurityConfigException("AxisService is Null");
            }
        }
        if ((param = service.getParameter("secPolicyRegistryPath")) != null) {
            data = new SecurityScenarioData();
            data.setPolicyRegistryPath((String)param.getValue());
            data.setScenarioId("policyFromRegistry");
        } else {
            SecurityScenario scenario = this.readCurrentScenario(serviceName);
            if (scenario != null) {
                data = new SecurityScenarioData();
                data.setCategory(scenario.getCategory());
                data.setDescription(scenario.getDescription());
                data.setScenarioId(scenario.getScenarioId());
                data.setSummary(scenario.getSummary());
            }
        }
        if (data != null && "policyFromRegistry".equalsIgnoreCase(data.getScenarioId()) && StringUtils.isEmpty((String)data.getPolicyRegistryPath()) && StringUtils.isNotEmpty((String)(policyPath = this.getPolicyRegistryPath(serviceName)))) {
            data.setPolicyRegistryPath(policyPath);
            Parameter pathParam = new Parameter("secPolicyRegistryPath", (Object)policyPath);
            try {
                service.addParameter(pathParam);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while adding policy path parameter to sts service", (Throwable)axisFault);
            }
        }
        return data;
    }

    public String[] getRequiredModules(String serviceName, String moduleId) throws Exception {
        SecurityScenarioData securityScenarioData = this.getCurrentScenario(serviceName);
        if (securityScenarioData != null) {
            SecurityScenario securityScenario = SecurityScenarioDatabase.get(securityScenarioData.getScenarioId());
            String[] moduleNames = securityScenario.getModules().toArray(new String[securityScenario.getModules().size()]);
            return moduleNames;
        }
        return new String[0];
    }

    public void disableSecurityOnService(String serviceName) throws SecurityConfigException {
        String[] moduleNames;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disabling security on service :" + serviceName));
        }
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        SecurityScenario scenario = this.readCurrentScenario(serviceName);
        if (scenario == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Scenario not found. Hence returning");
            }
            return;
        }
        this.removeSecurityPolicy(service, scenario.getWsuId());
        for (String moduleName : moduleNames = scenario.getModules().toArray(new String[scenario.getModules().size()])) {
            AxisModule module = service.getAxisConfiguration().getModule(moduleName);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Disengaging module : " + moduleName));
                }
                service.disengageModule(module);
            }
            catch (AxisFault axisFault) {
                throw new SecurityConfigException("Error while disengaging module :" + moduleName, (Throwable)axisFault);
            }
        }
        try {
            Parameter scenarioIDSetParam;
            Parameter scenarioIDParam;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Removing service parameters : passwordCallbackRef ,disableREST");
            }
            Parameter param = new Parameter();
            param.setName("passwordCallbackRef");
            service.removeParameter(param);
            Parameter param2 = new Parameter();
            param2.setName(DISABLE_REST);
            service.removeParameter(param2);
            Parameter pathParam = service.getParameter("secPolicyRegistryPath");
            if (pathParam != null) {
                service.removeParameter(pathParam);
            }
            if ((scenarioIDParam = service.getParameter("ScenarioID")) != null) {
                service.removeParameter(scenarioIDParam);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ScenarioID parameter is removed from axis service: " + service.getName()));
                }
            }
            if ((scenarioIDSetParam = service.getParameter("ScenarioIDSet")) != null) {
                service.removeParameter(scenarioIDSetParam);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ScenarioIDSet parameter is removed from axis service: " + service.getName()));
                }
            }
        }
        catch (AxisFault axisFault) {
            throw new SecurityConfigException("Error while removing parameters from service on disable security ", (Throwable)axisFault);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing Authorization roles");
        }
        AuthorizationManager acAdmin = null;
        try {
            acAdmin = this.realm.getAuthorizationManager();
            String resourceName = serviceGroupId + "/" + serviceName;
            String[] roles = acAdmin.getAllowedRolesForResource(resourceName, "invoke-service");
            for (int i = 0; i < roles.length; ++i) {
                acAdmin.clearRoleAuthorization(roles[i], resourceName, "invoke-service");
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Removed role :" + roles[i]));
            }
        }
        catch (UserStoreException e) {
            throw new SecurityConfigException("Error while removing authorization roles ", (Throwable)e);
        }
    }

    private void removeSecurityPolicy(AxisService service, String scenarioWsId) throws SecurityConfigException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing security policy for service : " + service.getName() + " , ScenarioWsId :" + scenarioWsId));
        }
        try {
            Parameter scenarioIDSetParam;
            Parameter scenarioIDParam;
            Registry configRegistry = this.registry;
            String servicePath = this.getRegistryServicePath(service);
            String policyResourcePath = servicePath + "/policies/";
            if (configRegistry.resourceExists(policyResourcePath)) {
                configRegistry.delete(policyResourcePath);
            }
            if (service.getPolicySubject().getAttachedPolicyComponents() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Service level policy attached.. Removing policy");
                }
                service.getPolicySubject().getAttachedPolicyComponents().clear();
            }
            if ((scenarioIDParam = service.getParameter("ScenarioID")) != null) {
                service.removeParameter(scenarioIDParam);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ScenarioID parameter is removed from axis service: " + service.getName()));
                }
            }
            if ((scenarioIDSetParam = service.getParameter("ScenarioIDSet")) != null) {
                service.removeParameter(scenarioIDSetParam);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ScenarioIDSet parameter is removed from axis service: " + service.getName()));
                }
            }
            SecurityServiceAdmin admin = new SecurityServiceAdmin(this.axisConfig, this.registry);
            admin.removeSecurityPolicyFromAllBindings(service, scenarioWsId);
        }
        catch (RegistryException e) {
            throw new SecurityConfigException("Error occurred while removing security policy", (Throwable)e);
        }
        catch (AxisFault axisFault) {
            throw new SecurityConfigException("Error while removing scenario ID from axis service", (Throwable)axisFault);
        }
        catch (ServerException e) {
            log.error((Object)"Error while removing policy from service bindings ", (Throwable)e);
        }
    }

    private KerberosConfigData readKerberosConfigurations(OMElement carbonSecConfig) throws SecurityConfigException {
        KerberosConfigData kerberosConfigData = null;
        if (carbonSecConfig != null) {
            OMElement kerberosElement;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading kerberos configurations from carbonSecConfig : " + carbonSecConfig.toString()));
            }
            if ((kerberosElement = carbonSecConfig.getFirstChildWithName(new QName("http://www.wso2.org/products/carbon/security", "Kerberos"))) != null) {
                kerberosConfigData = new KerberosConfigData();
                Map<String, String> kerberosProperties = this.getProperties(kerberosElement);
                if (kerberosProperties.get("service.principal.name") != null) {
                    kerberosConfigData.setServicePrincipleName(kerberosProperties.get("service.principal.name"));
                }
                if (kerberosProperties.get("service.principal.password") != null) {
                    String encryptedString = kerberosProperties.get("service.principal.password");
                    CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
                    try {
                        kerberosConfigData.setServicePrinciplePassword(new String(cryptoUtil.base64DecodeAndDecrypt(encryptedString)));
                    }
                    catch (CryptoException e) {
                        String msg = "Unable to decode and decrypt password string.";
                        log.warn((Object)msg, (Throwable)e);
                    }
                }
            }
        }
        return kerberosConfigData;
    }

    private Map<String, String> getTrustProperties(OMElement carbonSecConfig) {
        OMElement trustElement = null;
        if (carbonSecConfig != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving trust properties from carbonSecConfig : " + carbonSecConfig));
            }
            trustElement = carbonSecConfig.getFirstChildWithName(new QName("http://www.wso2.org/products/carbon/security", "Trust"));
        }
        return this.getProperties(trustElement);
    }

    private OMElement getCarbonSecConfigs(Policy policy) {
        if (log.isDebugEnabled() && policy != null) {
            log.debug((Object)("Retrieving carbonSecConfigs from policy id : " + policy.getId()));
        }
        if (policy != null) {
            List it = (List)policy.getAlternatives().next();
            for (Assertion assertion : it) {
                OMElement xmlPrimitiveAssertion;
                if (!(assertion instanceof XmlPrimtiveAssertion) || !"CarbonSecConfig".equals((xmlPrimitiveAssertion = ((XmlPrimtiveAssertion)assertion).getValue()).getLocalName())) continue;
                OMElement carbonSecConfigElement = ((XmlPrimtiveAssertion)assertion).getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("carbonSecConfig : " + carbonSecConfigElement.toString()));
                }
                return carbonSecConfigElement;
            }
        }
        return null;
    }

    private RampartConfig getRampartConfigs(Policy policy) {
        if (policy != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving RampartConfigs from policy with id : " + policy.getId()));
            }
            List it = (List)policy.getAlternatives().next();
            for (Assertion assertion : it) {
                if (!(assertion instanceof RampartConfig)) continue;
                return (RampartConfig)assertion;
            }
        }
        return null;
    }

    private String getEncryptedPassword(String password) throws SecurityConfigException {
        CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
        try {
            return cryptoUtil.encryptAndBase64Encode(password.getBytes());
        }
        catch (CryptoException e) {
            String msg = "Unable to encrypt and encode password string.";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, (Throwable)e);
        }
    }

    private String getRegistryServicePath(AxisService service) {
        StringBuilder pathValue = new StringBuilder();
        return pathValue.append("/repository/axis2/service-groups/").append(service.getAxisServiceGroup().getServiceGroupName()).append("/services/").append(service.getName()).toString();
    }

    public void activateUsernameTokenAuthentication(String serviceName, String[] userGroups) throws SecurityConfigException {
    }

    public void applySecurity(String serviceName, String scenarioId, KerberosConfigData kerberosConfigurations) throws SecurityConfigException {
        if (kerberosConfigurations == null) {
            log.error((Object)"Kerberos configurations provided are invalid.");
            throw new SecurityConfigException("Kerberos configuration parameters are null. Please specify valid kerberos configurations.");
        }
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            throw new SecurityConfigException("nullService");
        }
        this.disableSecurityOnService(serviceName);
        OMElement policyElement = this.loadPolicyAsXML(scenarioId, null);
        OMElement carbonSecConfigs = this.addUserParameters(policyElement, null, null, null, kerberosConfigurations, false, null);
        policyElement.addChild((OMNode)this.buildRampartConfigXML(null, null, kerberosConfigurations));
        Policy policy = PolicyEngine.getPolicy((OMElement)policyElement);
        try {
            this.persistPolicy(service, policyElement, policy.getId());
            this.applyPolicy(service, policy, carbonSecConfigs);
            this.getPOXCache().remove((Object)serviceName);
        }
        catch (Exception e) {
            throw new SecurityConfigException("Error while persisting policy in registry ", (Throwable)e);
        }
    }

    public void applySecurity(String serviceName, String scenarioId, String policyPath, String[] trustedStores, String privateStore, String[] userGroups) throws SecurityConfigException {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        OMElement carbonSecConfigs = null;
        if (service == null) {
            throw new SecurityConfigException("Service not available.");
        }
        if (userGroups != null) {
            Arrays.sort(userGroups);
            if (Arrays.binarySearch(userGroups, "system/wso2.anonymous.role") > -1) {
                log.error((Object)"Security breach. A user is attempting to enable anonymous for UT access");
                throw new SecurityConfigException("Invalid data provided");
            }
        }
        this.disableSecurityOnService(serviceName);
        OMElement policyElement = this.loadPolicyAsXML(scenarioId, policyPath);
        SecurityScenario scenario = SecurityScenarioDatabase.get(scenarioId);
        boolean isTrustEnabled = scenario.getModules().contains("rahas");
        if (isTrustEnabled || userGroups != null && userGroups.length > 0) {
            carbonSecConfigs = this.addUserParameters(policyElement, trustedStores, privateStore, userGroups, null, isTrustEnabled, policyPath);
        }
        if (StringUtils.isBlank((String)policyPath)) {
            policyElement.addChild((OMNode)this.buildRampartConfigXML(privateStore, trustedStores, null));
        }
        Policy policy = PolicyEngine.getPolicy((OMElement)policyElement);
        try {
            this.persistPolicy(service, policyElement, policy.getId());
            this.applyPolicy(service, policy, carbonSecConfigs);
            String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
            if (userGroups != null) {
                for (String value : userGroups) {
                    AuthorizationManager acAdmin = this.realm.getAuthorizationManager();
                    acAdmin.authorizeRole(value, serviceGroupId + "/" + service.getName(), "invoke-service");
                }
            }
            if (IdentityUtil.isNotBlank((String)policyPath) && scenarioId.equals("policyFromRegistry")) {
                Parameter pathParam = new Parameter("secPolicyRegistryPath", (Object)policyPath);
                service.addParameter(pathParam);
            }
        }
        catch (Exception e) {
            throw new SecurityConfigException("Error while persisting policy in registry", (Throwable)e);
        }
    }

    private void applyPolicy(AxisService service, Policy policy, OMElement carbonSecElement) throws Exception {
        boolean isRahasEngaged;
        if (service == null || policy == null) {
            throw new SecurityConfigException("Error while applying policy to service. Service and policy must be present to apply policy");
        }
        String policyId = policy.getId();
        SecurityScenario securityScenario = SecurityScenarioDatabase.getByWsuId(policyId);
        this.disableRESTCalls(service.getName(), securityScenario.getScenarioId());
        if (GhostDeployerUtils.isGhostService((AxisService)service)) {
            try {
                service = GhostDeployerUtils.deployActualService((AxisConfiguration)this.axisConfig, (AxisService)service);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while loading actual service from Ghost", (Throwable)axisFault);
            }
        }
        if (isRahasEngaged = this.engageModules(securityScenario.getScenarioId(), service.getName(), service)) {
            if (carbonSecElement == null) {
                carbonSecElement = this.getCarbonSecConfigs(policy);
            }
            if (carbonSecElement != null) {
                this.setRahasParameters(service, carbonSecElement);
            }
        }
        try {
            String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
            CallbackHandler handler = this.callback == null ? new ServicePasswordCallbackHandler(null, serviceGroupId, service.getName(), this.registry, this.realm) : this.callback;
            Parameter param = new Parameter();
            param.setName("passwordCallbackRef");
            param.setValue((Object)handler);
            service.addParameter(param);
            this.getPOXCache().remove((Object)service.getName());
            Cache<String, String> cache = this.getPOXCache();
            if (cache != null) {
                cache.remove((Object)service.getName());
            }
            try {
                Parameter params = new Parameter();
                params.setName("ScenarioID");
                params.setValue((Object)securityScenario.getScenarioId());
                service.addParameter(params);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ScenarioID parameter is added to axis service: " + service.getName()));
                }
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while adding Scenario ID parameter", (Throwable)axisFault);
            }
            try {
                Parameter scenarioIDSetParam = new Parameter("ScenarioIDSet", (Object)true);
                service.addParameter(scenarioIDSetParam);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ScenarioIDSet parameter is added to axis service: " + service.getName()));
                }
            }
            catch (AxisFault scenarioIDSetParam) {
                // empty catch block
            }
            SecurityServiceAdmin admin = new SecurityServiceAdmin(this.axisConfig, this.registry);
            admin.addSecurityPolicyToAllBindings(service, policy);
        }
        catch (RegistryException e) {
            throw new SecurityConfigException("Error occurred while creating callback handler", (Throwable)e);
        }
        catch (AxisFault e) {
            throw new SecurityConfigException("Error occurred while adding callback parameter", (Throwable)e);
        }
        catch (ServerException e) {
            throw new SecurityConfigException("Error while adding policy to bindings", (Throwable)e);
        }
    }

    private OMElement buildRampartConfigXML(String privateStore, String[] trustedStores, KerberosConfigData kerberosConfig) throws SecurityConfigException {
        ByteArrayOutputStream out = null;
        XMLStreamWriter writer = null;
        OMElement rampartConfigElement = null;
        try {
            Properties props = this.getServerCryptoProperties(privateStore, trustedStores);
            RampartConfig rampartConfig = new RampartConfig();
            this.populateRampartConfig(rampartConfig, props, kerberosConfig);
            out = new ByteArrayOutputStream();
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            rampartConfig.serialize(writer);
            writer.flush();
            writer.close();
            out.close();
            out.flush();
            rampartConfigElement = AXIOMUtil.stringToOM((String)out.toString());
        }
        catch (Exception e) {
            throw new SecurityConfigException("Error while building rampart configs", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing output stream", (Throwable)e);
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (XMLStreamException e) {
                        log.error((Object)"Error while closing xml stream writer", (Throwable)e);
                    }
                }
            }
        }
        return rampartConfigElement;
    }

    private void persistPolicy(AxisService service, OMElement policy, String policyID) throws RegistryException {
        Resource resource = this.registry.newResource();
        resource.setContent((Object)policy.toString());
        String servicePath = this.getRegistryServicePath(service);
        String policyResourcePath = servicePath + "/policies/" + policyID;
        this.registry.put(policyResourcePath, resource);
    }

    private OMElement addUserParameters(OMElement policyElement, String[] trustedStores, String privateStore, String[] userGroups, KerberosConfigData kerberosConfigData, boolean isTrusEnabled, String policyPath) throws SecurityConfigException {
        OMAttribute propertyNameAttribute;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding user parameters to policy element : " + policyElement));
        }
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace secElement = factory.createOMNamespace("http://www.wso2.org/products/carbon/security", SEC_LABEL);
        OMElement carbonSecElement = factory.createOMElement("CarbonSecConfig", secElement);
        OMElement kerberosElement = factory.createOMElement("Kerberos", secElement);
        OMElement policyPathElement = factory.createOMElement(POLICY_PATH, secElement);
        OMElement trustElement = null;
        if ((trustedStores != null || privateStore != null) && isTrusEnabled) {
            OMText storePropertyValue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding trust element to policy");
            }
            trustElement = factory.createOMElement("Trust", secElement);
            if (trustedStores != null && trustedStores.length > 0) {
                OMElement trustStorePropertyElement = factory.createOMElement("property", secElement);
                propertyNameAttribute = factory.createOMAttribute("name", null, "org.wso2.carbon.security.crypto.truststores");
                trustStorePropertyElement.addAttribute(propertyNameAttribute);
                storePropertyValue = factory.createOMText((OMContainer)trustStorePropertyElement, this.getArrayAsString(trustedStores));
                trustStorePropertyElement.addChild((OMNode)storePropertyValue);
                trustElement.addChild((OMNode)trustStorePropertyElement);
                carbonSecElement.addChild((OMNode)trustElement);
            }
            if (privateStore != null) {
                OMElement privateStorePropertyElement = factory.createOMElement("property", secElement);
                propertyNameAttribute = factory.createOMAttribute("name", null, "org.wso2.carbon.security.crypto.privatestore");
                privateStorePropertyElement.addAttribute(propertyNameAttribute);
                storePropertyValue = factory.createOMText((OMContainer)privateStorePropertyElement, privateStore);
                privateStorePropertyElement.addChild((OMNode)storePropertyValue);
                trustElement.addChild((OMNode)privateStorePropertyElement);
                ServerConfiguration serverConfig = ServerConfiguration.getInstance();
                String keyAlias = null;
                keyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
                OMElement aliasPropertyElement = factory.createOMElement("property", secElement);
                OMAttribute aliasPropertyNameAttribute = factory.createOMAttribute("name", null, "org.wso2.carbon.security.crypto.alias");
                aliasPropertyElement.addAttribute(aliasPropertyNameAttribute);
                OMText aliasPropertyValue = factory.createOMText((OMContainer)aliasPropertyElement, keyAlias);
                aliasPropertyElement.addChild((OMNode)aliasPropertyValue);
                trustElement.addChild((OMNode)aliasPropertyElement);
                carbonSecElement.addChild((OMNode)trustElement);
            }
        }
        if (userGroups != null && userGroups.length > 0) {
            OMElement authorizationElement = factory.createOMElement("Authorization", secElement);
            OMElement propertyElement = factory.createOMElement("property", secElement);
            OMAttribute propertyNameAttribute2 = factory.createOMAttribute("name", null, "org.wso2.carbon.security.allowedroles");
            propertyElement.addAttribute(propertyNameAttribute2);
            OMText propertyValue = factory.createOMText((OMContainer)propertyElement, this.getArrayAsString(userGroups));
            propertyElement.addChild((OMNode)propertyValue);
            authorizationElement.addChild((OMNode)propertyElement);
            carbonSecElement.addChild((OMNode)authorizationElement);
        }
        if (kerberosConfigData != null) {
            if (StringUtils.isNotEmpty((String)kerberosConfigData.getServicePrincipleName())) {
                OMElement principalNamePropertyElement = factory.createOMElement("property", secElement);
                propertyNameAttribute = factory.createOMAttribute("name", null, "service.principal.name");
                principalNamePropertyElement.addAttribute(propertyNameAttribute);
                OMText principalNameValue = factory.createOMText((OMContainer)principalNamePropertyElement, kerberosConfigData.getServicePrincipleName());
                principalNamePropertyElement.addChild((OMNode)principalNameValue);
                kerberosElement.addChild((OMNode)principalNamePropertyElement);
            }
            if (StringUtils.isNotEmpty((String)kerberosConfigData.getServicePrinciplePassword())) {
                OMElement principalPasswordPropertyElement = factory.createOMElement("property", secElement);
                propertyNameAttribute = factory.createOMAttribute("name", null, "service.principal.password");
                OMAttribute propertyEncryptedAttribute = factory.createOMAttribute("encrypted", null, "true");
                principalPasswordPropertyElement.addAttribute(propertyNameAttribute);
                principalPasswordPropertyElement.addAttribute(propertyEncryptedAttribute);
                OMText principalPasswordValue = null;
                principalPasswordValue = factory.createOMText((OMContainer)principalPasswordPropertyElement, this.getEncryptedPassword(kerberosConfigData.getServicePrinciplePassword()));
                principalPasswordPropertyElement.addChild((OMNode)principalPasswordValue);
                kerberosElement.addChild((OMNode)principalPasswordPropertyElement);
            }
            carbonSecElement.addChild((OMNode)kerberosElement);
        }
        if (IdentityUtil.isNotBlank((String)policyPath)) {
            OMText policyPathValue = factory.createOMText((OMContainer)policyPathElement, policyPath);
            policyPathElement.addChild((OMNode)policyPathValue);
            carbonSecElement.addChild((OMNode)policyPathElement);
        }
        policyElement.addChild((OMNode)carbonSecElement);
        return carbonSecElement;
    }

    private String getArrayAsString(String[] userGroups) {
        StringBuilder groups = new StringBuilder();
        boolean isFirst = true;
        for (String group : userGroups) {
            if (isFirst) {
                groups.append(group);
                isFirst = false;
                continue;
            }
            groups.append(",");
            groups.append(group);
        }
        return groups.toString();
    }

    private OMElement loadPolicyAsXML(String scenarioId, String policyPath) throws SecurityConfigException {
        try {
            OMAttribute att;
            Registry registryToLoad = this.registry;
            String resourceUri = "/repository/components/org.wso2.carbon.security.mgt/policy/" + scenarioId;
            if (IdentityUtil.isNotBlank((String)policyPath) && scenarioId.equals("policyFromRegistry")) {
                resourceUri = policyPath.substring(policyPath.lastIndexOf(58) + 1);
                String regIdentifier = policyPath.substring(0, policyPath.lastIndexOf(58));
                if ("gov".equals(regIdentifier)) {
                    registryToLoad = this.govRegistry;
                }
            }
            Resource resource = null;
            resource = registryToLoad.get(resourceUri);
            InputStream in = resource.getContentStream();
            XMLStreamReader parser = null;
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            parser = xmlInputFactory.createXMLStreamReader(in);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement policyElement = builder.getDocumentElement();
            if (IdentityUtil.isNotBlank((String)policyPath) && scenarioId.equals("policyFromRegistry") && (att = policyElement.getAttribute(SecurityConstants.POLICY_ID_QNAME)) != null) {
                att.setAttributeValue("policyFromRegistry");
            }
            return policyElement;
        }
        catch (RegistryException e) {
            throw new SecurityConfigException("Error occurred while loading policy.", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new SecurityConfigException("Error occurred while loading policy.", (Throwable)e);
        }
    }

    protected boolean engageModules(String scenarioId, String serviceName, AxisService axisService) throws SecurityConfigException {
        boolean isRahasEngaged = false;
        SecurityScenario securityScenario = SecurityScenarioDatabase.get(scenarioId);
        String[] moduleNames = securityScenario.getModules().toArray(new String[securityScenario.getModules().size()]);
        try {
            for (String modName : moduleNames) {
                AxisModule module = axisService.getAxisConfiguration().getModule(modName);
                axisService.disengageModule(module);
                axisService.engageModule(module);
                if (!"rahas".equalsIgnoreCase(modName)) continue;
                isRahasEngaged = true;
            }
            return isRahasEngaged;
        }
        catch (AxisFault e) {
            log.error((Object)e);
            throw new SecurityConfigException("Error in engaging modules", (Throwable)e);
        }
    }

    protected void disableRESTCalls(String serviceName, String scenrioId) throws SecurityConfigException {
        if (scenrioId.equals("scenario1")) {
            return;
        }
        try {
            AxisService service = this.axisConfig.getServiceForActivation(serviceName);
            if (service == null) {
                throw new SecurityConfigException("nullService");
            }
            Parameter param = new Parameter();
            param.setName(DISABLE_REST);
            param.setValue((Object)Boolean.TRUE.toString());
            service.addParameter(param);
        }
        catch (AxisFault e) {
            log.error((Object)e);
            throw new SecurityConfigException("disablingREST", (Throwable)e);
        }
    }

    public void populateRampartConfig(RampartConfig rampartConfig, Properties props, KerberosConfigData kerberosConfigurations) throws SecurityConfigException {
        if (rampartConfig != null) {
            if (kerberosConfigurations != null) {
                Properties kerberosProperties = new Properties();
                kerberosProperties.setProperty("service.principal.name", kerberosConfigurations.getServicePrincipleName());
                KerberosConfig kerberosConfig = new KerberosConfig();
                kerberosConfig.setProp(kerberosProperties);
                String carbonSecurityConfigurationPath = CarbonUtils.getCarbonConfigDirPath() + File.separatorChar + IDENTITY_CONFIG_DIR;
                String krbFile = carbonSecurityConfigurationPath + File.separatorChar + "krb5.conf";
                File krbFileObject = new File(krbFile);
                if (!krbFileObject.exists()) {
                    throw new SecurityConfigException("Kerberos configuration file not found at " + krbFile);
                }
                log.info((Object)("Setting java.security.krb5.conf to kerberos configuration file " + krbFile));
                System.setProperty("java.security.krb5.conf", krbFile);
                rampartConfig.setKerberosConfig(kerberosConfig);
            } else {
                if (!props.isEmpty()) {
                    CryptoConfig encrCryptoConfig = new CryptoConfig();
                    encrCryptoConfig.setProvider(ServerCrypto.class.getName());
                    encrCryptoConfig.setProp(props);
                    encrCryptoConfig.setCacheEnabled(true);
                    encrCryptoConfig.setCryptoKey("org.wso2.carbon.security.crypto.privatestore");
                    rampartConfig.setEncrCryptoConfig(encrCryptoConfig);
                    CryptoConfig signatureCryptoConfig = new CryptoConfig();
                    signatureCryptoConfig.setProvider(ServerCrypto.class.getName());
                    signatureCryptoConfig.setProp(props);
                    signatureCryptoConfig.setCacheEnabled(true);
                    signatureCryptoConfig.setCryptoKey("org.wso2.carbon.security.crypto.privatestore");
                    rampartConfig.setSigCryptoConfig(signatureCryptoConfig);
                }
                rampartConfig.setEncryptionUser("useReqSigCert");
                rampartConfig.setUser(props.getProperty(USER));
                int ttl = 300;
                int timeSkew = 300;
                rampartConfig.setTimestampTTL(Integer.toString(ttl));
                rampartConfig.setTimestampMaxSkew(Integer.toString(timeSkew));
                String tokenStoreClassName = ServerConfiguration.getInstance().getFirstProperty("Security.TokenStoreClassName");
                if (tokenStoreClassName == null) {
                    rampartConfig.setTokenStoreClass(SecurityTokenStore.class.getName());
                } else {
                    rampartConfig.setTokenStoreClass(tokenStoreClassName);
                }
            }
        }
    }

    public Properties getServerCryptoProperties(String privateStore, String[] trustedCertStores) throws Exception {
        Properties props = new Properties();
        int tenantId = ((UserRegistry)this.registry).getTenantId();
        if (trustedCertStores != null && trustedCertStores.length > 0) {
            StringBuilder trustString = new StringBuilder();
            for (String trustedCertStore : trustedCertStores) {
                if (trustString.length() > 0) {
                    trustString.append(",");
                }
                trustString.append(trustedCertStore);
            }
            props.setProperty("org.wso2.carbon.security.crypto.truststores", trustString.toString());
        }
        if (privateStore != null) {
            props.setProperty("org.wso2.carbon.security.crypto.privatestore", privateStore);
            KeyStoreManager keyMan = KeyStoreManager.getInstance((int)tenantId);
            KeyStore ks = keyMan.getKeyStore(privateStore);
            String privKeyAlias = KeyStoreUtil.getPrivateKeyAlias((KeyStore)ks);
            props.setProperty("org.wso2.carbon.security.crypto.alias", privKeyAlias);
            props.setProperty(USER, privKeyAlias);
        }
        if (privateStore != null || trustedCertStores != null && trustedCertStores.length > 0) {
            props.setProperty("org.wso2.stratos.tenant.id", Integer.toString(tenantId));
        }
        return props;
    }

    public void setServiceTransports(String serviceId, List<String> transportProtocols) throws SecurityConfigException, AxisFault {
        AxisService axisService = this.axisConfig.getServiceForActivation(serviceId);
        if (axisService == null) {
            throw new SecurityConfigException("nullService");
        }
        ArrayList<String> transports = new ArrayList<String>();
        for (int i = 0; i < transportProtocols.size(); ++i) {
            transports.add(transportProtocols.get(i));
        }
        axisService.setExposedTransports(transports);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully add selected transport bindings to service " + serviceId));
        }
    }

    public boolean isHttpsTransportOnly(Policy policy) throws SecurityConfigException {
        boolean httpsRequired = false;
        try {
            Iterator alternatives = policy.getAlternatives();
            if (alternatives.hasNext()) {
                Token encrToken;
                List it = (List)alternatives.next();
                RampartPolicyData rampartPolicyData = RampartPolicyBuilder.build((List)it);
                if (rampartPolicyData.isTransportBinding()) {
                    httpsRequired = true;
                } else if (rampartPolicyData.isSymmetricBinding() && (encrToken = rampartPolicyData.getEncryptionToken()) instanceof SecureConversationToken) {
                    Policy bsPol = ((SecureConversationToken)encrToken).getBootstrapPolicy();
                    Iterator alts = bsPol.getAlternatives();
                    List bsIt = (List)alts.next();
                    RampartPolicyData bsRampartPolicyData = RampartPolicyBuilder.build((List)bsIt);
                    httpsRequired = bsRampartPolicyData.isTransportBinding();
                }
            }
        }
        catch (WSSPolicyException e) {
            log.error((Object)"Error in checking http transport only", (Throwable)e);
            throw new SecurityConfigException("Error in checking http transport only", (Throwable)e);
        }
        return httpsRequired;
    }

    public List<String> getHttpsTransports() {
        ArrayList<String> httpsTransports = new ArrayList<String>();
        for (String transport : this.axisConfig.getTransportsIn().keySet()) {
            if (transport.toLowerCase().indexOf("https") == -1) continue;
            httpsTransports.add(transport);
        }
        return httpsTransports;
    }

    public List<String> getAllTransports() {
        ArrayList<String> allTransports = new ArrayList<String>();
        for (String transport : this.axisConfig.getTransportsIn().keySet()) {
            allTransports.add(transport);
        }
        return allTransports;
    }

    public SecurityConfigData getSecurityConfigData(String serviceName, String scenarioId, String policyPath) throws SecurityConfigException {
        SecurityConfigData data = null;
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        try {
            String trustedStores;
            SecurityScenario scenario;
            Parameter param;
            if (scenarioId == null) {
                return data;
            }
            if (scenarioId.equals("policyFromRegistry") ? (param = service.getParameter("secPolicyRegistryPath")) == null || !policyPath.equals(param.getValue()) : (scenario = this.readCurrentScenario(serviceName)) == null || !scenario.getScenarioId().equals(scenarioId)) {
                return data;
            }
            Policy policy = this.getCurrentPolicy(service);
            OMElement carbonSecConfig = this.getCarbonSecConfigs(policy);
            RampartConfig rampartConfigs = this.getRampartConfigs(policy);
            Map<String, String> trustProperties = this.getTrustProperties(carbonSecConfig);
            KerberosConfigData kerberosData = this.readKerberosConfigurations(carbonSecConfig);
            data = new SecurityConfigData();
            data.setKerberosConfigurations(kerberosData);
            AuthorizationManager acReader = this.realm.getAuthorizationManager();
            String[] roles = acReader.getAllowedRolesForResource(serviceGroupId + "/" + serviceName, "invoke-service");
            data.setUserGroups(roles);
            String privateStore = this.getProperty(rampartConfigs, trustProperties, "org.wso2.carbon.security.crypto.privatestore");
            if (StringUtils.isNotBlank((String)privateStore)) {
                data.setPrivateStore(privateStore);
            }
            if (StringUtils.isNotBlank((String)(trustedStores = this.getProperty(rampartConfigs, trustProperties, "org.wso2.carbon.security.crypto.truststores")))) {
                data.setTrustedKeyStores(trustedStores.split(","));
            }
            return data;
        }
        catch (UserStoreException e) {
            log.error((Object)"Error in getting security config data. Failed to get Authorization Manager", (Throwable)e);
            return data;
        }
    }

    private String getPolicyRegistryPath(String serviceName) {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String policyPath = "";
        try {
            OMElement carbonSecConfig = this.getCarbonSecConfigs(this.getCurrentPolicy(service));
            OMElement policyPathElement = carbonSecConfig.getFirstChildWithName(new QName("http://www.wso2.org/products/carbon/security", POLICY_PATH));
            if (policyPathElement != null) {
                policyPath = policyPathElement.getText();
            }
        }
        catch (SecurityConfigException e) {
            log.error((Object)"Error while retrieving current policy from service", (Throwable)e);
        }
        return policyPath;
    }

    public SecurityScenario readCurrentScenario(String serviceName) throws SecurityConfigException {
        SecurityScenario scenario = null;
        scenario = null;
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        Object serviceGroupId = null;
        try {
            if (service == null) {
                try {
                    service = (AxisService)GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.axisConfig).get(serviceName);
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error while reading Transit Ghosts map", (Throwable)axisFault);
                }
                if (service == null) {
                    throw new SecurityConfigException("AxisService is Null");
                }
            }
            if (GhostDeployerUtils.isGhostService((AxisService)service)) {
                service = GhostDeployerUtils.deployActualService((AxisConfiguration)this.axisConfig, (AxisService)service);
            }
            Map endPointMap = service.getEndpoints();
            for (Map.Entry o : endPointMap.entrySet()) {
                SecurityScenario epSecurityScenario = null;
                Map.Entry entry = o;
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                AxisBinding binding = point.getBinding();
                Collection policies = binding.getPolicySubject().getAttachedPolicyComponents();
                Iterator policyComponents = policies.iterator();
                String policyId = null;
                while (policyComponents.hasNext()) {
                    PolicyComponent currentPolicyComponent = (PolicyComponent)policyComponents.next();
                    if (currentPolicyComponent instanceof Policy) {
                        policyId = ((Policy)currentPolicyComponent).getId();
                    } else if (currentPolicyComponent instanceof PolicyReference) {
                        policyId = ((PolicyReference)currentPolicyComponent).getURI().substring(1);
                    }
                    if (policyId == null) continue;
                    epSecurityScenario = SecurityScenarioDatabase.getByWsuId(policyId);
                }
                if (epSecurityScenario == null) {
                    if (binding.getName().getLocalPart().contains("HttpBinding")) continue;
                    scenario = null;
                    break;
                }
                scenario = epSecurityScenario;
            }
            if (scenario == null) {
                Collection policies = service.getPolicySubject().getAttachedPolicyComponents();
                Iterator policyComponents = policies.iterator();
                String policyId = null;
                while (policyComponents.hasNext()) {
                    PolicyComponent currentPolicyComponent = (PolicyComponent)policyComponents.next();
                    if (currentPolicyComponent instanceof Policy) {
                        policyId = ((Policy)currentPolicyComponent).getId();
                    } else {
                        if (!(currentPolicyComponent instanceof PolicyReference)) continue;
                        policyId = ((PolicyReference)currentPolicyComponent).getURI().substring(1);
                    }
                    if (policyId == null) continue;
                    scenario = SecurityScenarioDatabase.getByWsuId(policyId);
                }
            }
            return scenario;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading Security Scenario", (Throwable)e);
            throw new SecurityConfigException("readingSecurity", (Throwable)e);
        }
    }

    public void forceActualServiceDeployment(String serviceName) {
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        if (service == null) {
            try {
                service = (AxisService)GhostDeployerUtils.getTransitGhostServicesMap((AxisConfiguration)this.axisConfig).get(serviceName);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while reading Transit Ghosts map", (Throwable)axisFault);
            }
        }
        if (service != null && GhostDeployerUtils.isGhostService((AxisService)service)) {
            try {
                GhostDeployerUtils.deployActualService((AxisConfiguration)this.axisConfig, (AxisService)service);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error while loading actual service from Ghost", (Throwable)axisFault);
            }
        }
    }

    private Cache<String, String> getPOXCache() {
        CacheManager manager = Caching.getCacheManagerFactory().getCacheManager("POX_CACHE_MANAGER");
        return manager.getCache("pox-security");
    }

    private Map<String, String> getProperties(OMElement parentElement) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (parentElement != null) {
            Iterator iterator = parentElement.getChildElements();
            while (iterator.hasNext()) {
                OMElement element = (OMElement)iterator.next();
                String nameAttribute = element.getAttribute(new QName("name")).getAttributeValue();
                String value = element.getText();
                properties.put(nameAttribute, value);
            }
        }
        return properties;
    }

    private String getProperty(RampartConfig rampartConfig, Map<String, String> trustProperties, String propertyName) {
        String propertyValue = null;
        if (trustProperties != null && StringUtils.isNotEmpty((String)(propertyValue = trustProperties.get(propertyName)))) {
            return propertyValue;
        }
        if (rampartConfig != null) {
            if (rampartConfig.getEncrCryptoConfig() != null && rampartConfig.getEncrCryptoConfig().getProp().get(propertyName) != null && StringUtils.isNotEmpty((String)(propertyValue = rampartConfig.getEncrCryptoConfig().getProp().get(propertyName).toString()))) {
                return propertyValue;
            }
            if (rampartConfig.getSigCryptoConfig() != null && rampartConfig.getSigCryptoConfig().getProp().get(propertyName) != null && StringUtils.isNotEmpty((String)(propertyValue = rampartConfig.getEncrCryptoConfig().getProp().get(propertyName).toString()))) {
                return propertyValue;
            }
        }
        return propertyValue;
    }

    private Policy loadPolicy(Resource resource) throws org.wso2.carbon.registry.api.RegistryException, XMLStreamException {
        InputStream in = resource.getContentStream();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        XMLStreamReader parser = xmlInputFactory.createXMLStreamReader(in);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        OMElement policyElement = builder.getDocumentElement();
        return PolicyEngine.getPolicy((OMElement)policyElement);
    }

    private Policy getCurrentPolicy(AxisService service) throws SecurityConfigException {
        try {
            String[] stringArray;
            int n;
            int n2;
            Resource resource;
            int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            UserRegistry configRegistry = SecurityMgtServiceComponent.getRegistryService().getConfigSystemRegistry(tenantId);
            String servicePath = this.getRegistryServicePath(service);
            String policyResourcePath = servicePath + "/policies/";
            if (configRegistry.resourceExists(policyResourcePath) && (resource = configRegistry.get(policyResourcePath)) instanceof org.wso2.carbon.registry.core.Collection && (n2 = 0) < (n = (stringArray = ((org.wso2.carbon.registry.core.Collection)resource).getChildren()).length)) {
                String policyPath = stringArray[n2];
                Resource res = configRegistry.get(policyPath);
                return this.loadPolicy(res);
            }
        }
        catch (org.wso2.carbon.registry.api.RegistryException e) {
            throw new SecurityConfigException("Error while retrieving policy from registry for service " + service.getName(), (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new SecurityConfigException("Error occurred while loading policy from registry resource", (Throwable)e);
        }
        return null;
    }

    private void setRahasParameters(AxisService service, OMElement carbonSecConfig) throws Exception {
        SecurityConfigParams configParams = SecurityConfigParamBuilder.getSecurityParams(carbonSecConfig);
        Properties cryptoProps = new Properties();
        cryptoProps.setProperty("org.wso2.carbon.security.crypto.privatestore", configParams.getPrivateStore());
        cryptoProps.setProperty("org.wso2.carbon.security.crypto.alias", configParams.getKeyAlias());
        if (configParams.getTrustStores() != null) {
            cryptoProps.setProperty("org.wso2.carbon.security.crypto.truststores", configParams.getTrustStores());
        }
        service.addParameter(RahasUtil.getSCTIssuerConfigParameter(ServerCrypto.class.getName(), cryptoProps, -1, null, true, true));
        service.addParameter(RahasUtil.getTokenCancelerConfigParameter());
    }
}

