/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.common;

import org.wso2.carbon.base.ServerConfiguration;

public class SecurityConfigParams {
    private String privateStore;
    private String trustStores;
    private String allowedRoles;
    private String keyAlias;
    private String serverPrincipalPassword;
    private boolean isServerPrincipalPasswordEncrypted = true;

    public String getPrivateStore() {
        if (this.privateStore == null) {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String pvtStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
            return pvtStore.substring(pvtStore.lastIndexOf("/") + 1);
        }
        return this.privateStore;
    }

    public void setPrivateStore(String privateStore) {
        this.privateStore = privateStore;
    }

    public String getTrustStores() {
        return this.trustStores;
    }

    public void setTrustStores(String trustStores) {
        this.trustStores = trustStores;
    }

    public String getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(String allowedRoles) {
        this.allowedRoles = allowedRoles;
    }

    public String getKeyAlias() {
        if (this.keyAlias == null) {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            return serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
        }
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getServerPrincipalPassword() {
        return this.serverPrincipalPassword;
    }

    public void setServerPrincipalPassword(String serverPrincipalPassword) {
        this.serverPrincipalPassword = serverPrincipalPassword;
    }

    public boolean isServerPrincipalPasswordEncrypted() {
        return this.isServerPrincipalPasswordEncrypted;
    }

    public void setServerPrincipalPasswordEncrypted(boolean isServerPrincipalPasswordEncrypted) {
        this.isServerPrincipalPasswordEncrypted = isServerPrincipalPasswordEncrypted;
    }
}

