/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.mgt.synapse.internal;

import java.util.Collection;
import java.util.Map;
import org.apache.synapse.Startup;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.FailoverEndpoint;
import org.apache.synapse.endpoints.HTTPEndpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.RecipientListEndpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.startup.quartz.StartUpController;
import org.apache.synapse.task.TaskDescription;
import org.wso2.carbon.application.mgt.synapse.EndpointMetadata;
import org.wso2.carbon.application.mgt.synapse.TaskMetadata;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;

public class SynapseConfigAdmin
extends AbstractServiceBusAdmin {
    private SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
    private Map<String, Endpoint> namedEndpointMap = this.synapseConfiguration.getDefinedEndpoints();
    private Collection<Startup> namedTaskMap = this.synapseConfiguration.getStartups();
    private final String ADDRESS_EP = "address";
    private final String FAILOVER_EP = "failover";
    private final String WSDL_EP = "WSDL";
    private final String LOADBALANCE_EP = "loadBalance";
    private final String DEFAULT_EP = "default";
    private final String HTTP_EP = "http";
    private final String TEMPLATE_EP = "template";
    private final String RECIPIENTLIST_EP = "recipientlist";

    public EndpointMetadata getEndpointMetadata(String endpointName) {
        Endpoint endpoint = this.namedEndpointMap.get(endpointName);
        if (endpoint != null) {
            EndpointMetadata epData = new EndpointMetadata();
            epData.setName(endpointName);
            epData.setType(this.getEndpointType(endpoint));
            return epData;
        }
        return null;
    }

    public TaskMetadata getTaskMetaData(String instanceName) {
        for (Startup startup : this.namedTaskMap) {
            if (!startup.getName().equals(instanceName)) continue;
            TaskDescription taskDescription = ((StartUpController)startup).getTaskDescription();
            TaskMetadata taskMetadata = new TaskMetadata();
            taskMetadata.setName(taskDescription.getName());
            taskMetadata.setGroupName(taskDescription.getTaskGroup());
            return taskMetadata;
        }
        return null;
    }

    private String getEndpointType(Endpoint ep) {
        String epType = null;
        if (ep instanceof AddressEndpoint) {
            epType = "address";
        } else if (ep instanceof DefaultEndpoint) {
            epType = "default";
        } else if (ep instanceof WSDLEndpoint) {
            epType = "WSDL";
        } else if (ep instanceof FailoverEndpoint) {
            epType = "failover";
        } else if (ep instanceof LoadbalanceEndpoint) {
            epType = "loadBalance";
        } else if (ep instanceof HTTPEndpoint) {
            epType = "http";
        } else if (ep instanceof TemplateEndpoint) {
            epType = "template";
        } else if (ep instanceof RecipientListEndpoint) {
            epType = "recipientlist";
        }
        return epType;
    }
}

