/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.operator;

import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.collection.OverwritingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.UpdateAttributeMapper;
import org.wso2.siddhi.core.util.collection.operator.Finder;
import org.wso2.siddhi.core.util.collection.operator.Operator;

public class EventChunkOperator
implements Operator {
    protected ExpressionExecutor expressionExecutor;
    protected int candidateEventPosition;

    public EventChunkOperator(ExpressionExecutor expressionExecutor, int candidateEventPosition) {
        this.expressionExecutor = expressionExecutor;
        this.candidateEventPosition = candidateEventPosition;
    }

    @Override
    public Finder cloneFinder(String key) {
        return new EventChunkOperator(this.expressionExecutor.cloneExecutor(key), this.candidateEventPosition);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object candidateEvents, StreamEventCloner candidateEventCloner) {
        ComplexEventChunk candidateEventChunk = (ComplexEventChunk)candidateEvents;
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        candidateEventChunk.reset();
        while (candidateEventChunk.hasNext()) {
            StreamEvent candidateEvent = (StreamEvent)candidateEventChunk.next();
            matchingEvent.setEvent(this.candidateEventPosition, candidateEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                returnEventChunk.add(candidateEventCloner.copyStreamEvent(candidateEvent));
            }
            matchingEvent.setEvent(this.candidateEventPosition, null);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, Object candidateEvents) {
        ComplexEventChunk candidateEventChunk = (ComplexEventChunk)candidateEvents;
        try {
            candidateEventChunk.reset();
            while (candidateEventChunk.hasNext()) {
                StreamEvent candidateEvent = (StreamEvent)candidateEventChunk.next();
                matchingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                if (!((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            matchingEvent.setEvent(this.candidateEventPosition, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object candidateEvents) {
        ComplexEventChunk candidateEventChunk = (ComplexEventChunk)candidateEvents;
        deletingEventChunk.reset();
        while (deletingEventChunk.hasNext()) {
            StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
            try {
                candidateEventChunk.reset();
                while (candidateEventChunk.hasNext()) {
                    StreamEvent candidateEvent = (StreamEvent)candidateEventChunk.next();
                    deletingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                    if (!((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) continue;
                    candidateEventChunk.remove();
                }
            }
            finally {
                deletingEvent.setEvent(this.candidateEventPosition, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers) {
        ComplexEventChunk candidateEventChunk = (ComplexEventChunk)candidateEvents;
        updatingEventChunk.reset();
        while (updatingEventChunk.hasNext()) {
            StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
            try {
                candidateEventChunk.reset();
                while (candidateEventChunk.hasNext()) {
                    StreamEvent candidateEvent = (StreamEvent)candidateEventChunk.next();
                    updatingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                    if (!((Boolean)this.expressionExecutor.execute(updatingEvent)).booleanValue()) continue;
                    for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                        candidateEvent.setOutputData(updateAttributeMapper.getOutputData(updatingEvent), updateAttributeMapper.getCandidateAttributePosition());
                    }
                }
            }
            finally {
                updatingEvent.setEvent(this.candidateEventPosition, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StreamEvent> overwriteOrAdd(ComplexEventChunk<StateEvent> overwritingOrAddingEventChunk, Object candidateEvents, UpdateAttributeMapper[] updateAttributeMappers, OverwritingStreamEventExtractor overwritingStreamEventExtractor) {
        ComplexEventChunk candidateEventChunk = (ComplexEventChunk)candidateEvents;
        overwritingOrAddingEventChunk.reset();
        ComplexEventChunk<StreamEvent> failedEventChunk = new ComplexEventChunk<StreamEvent>(overwritingOrAddingEventChunk.isBatch());
        while (overwritingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)overwritingOrAddingEventChunk.next();
            try {
                boolean updated = false;
                candidateEventChunk.reset();
                while (candidateEventChunk.hasNext()) {
                    StreamEvent candidateEvent = (StreamEvent)candidateEventChunk.next();
                    overwritingOrAddingEvent.setEvent(this.candidateEventPosition, candidateEvent);
                    if (!((Boolean)this.expressionExecutor.execute(overwritingOrAddingEvent)).booleanValue()) continue;
                    for (UpdateAttributeMapper updateAttributeMapper : updateAttributeMappers) {
                        candidateEvent.setOutputData(updateAttributeMapper.getOutputData(overwritingOrAddingEvent), updateAttributeMapper.getCandidateAttributePosition());
                    }
                    updated = true;
                }
                if (updated) continue;
                failedEventChunk.add(overwritingStreamEventExtractor.getOverwritingStreamEvent(overwritingOrAddingEvent));
            }
            finally {
                overwritingOrAddingEvent.setEvent(this.candidateEventPosition, null);
            }
        }
        return failedEventChunk;
    }
}

