/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.query.api.definition.Attribute;

public class MaxAttributeAggregator
extends AttributeAggregator {
    private MaxAttributeAggregator maxOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Max aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Max not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.maxOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        return this.maxOutputAttributeAggregator.processAdd(data);
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        return this.maxOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        return this.maxOutputAttributeAggregator.reset();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object[] currentState() {
        return this.maxOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Object[] state) {
        this.maxOutputAttributeAggregator.restoreState(state);
    }

    class MaxAttributeAggregatorLong
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private Deque<Long> maxDeque = new LinkedList<Long>();
        private volatile Long maxValue = null;

        MaxAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            Iterator<Long> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() < value) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Long>>("MaxDeque", this.maxDeque), new AbstractMap.SimpleEntry<String, Long>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.maxValue = (Long)stateEntry2.getValue();
        }
    }

    class MaxAttributeAggregatorInt
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private Deque<Integer> maxDeque = new LinkedList<Integer>();
        private volatile Integer maxValue = null;

        MaxAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            Iterator<Integer> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() < value) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Integer>>("MaxDeque", this.maxDeque), new AbstractMap.SimpleEntry<String, Integer>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.maxValue = (Integer)stateEntry2.getValue();
        }
    }

    class MaxAttributeAggregatorFloat
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private Deque<Float> maxDeque = new LinkedList<Float>();
        private volatile Float maxValue = null;

        MaxAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            Iterator<Float> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next().floatValue() < value.floatValue()) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Float>>("MaxDeque", this.maxDeque), new AbstractMap.SimpleEntry<String, Float>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.maxValue = (Float)stateEntry2.getValue();
        }
    }

    class MaxAttributeAggregatorDouble
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private Deque<Double> maxDeque = new LinkedList<Double>();
        private volatile Double maxValue = null;

        MaxAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            Iterator<Double> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() < value) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public Object[] currentState() {
            return new Object[]{new AbstractMap.SimpleEntry<String, Deque<Double>>("MaxDeque", this.maxDeque), new AbstractMap.SimpleEntry<String, Double>("MaxValue", this.maxValue)};
        }

        @Override
        public void restoreState(Object[] state) {
            Map.Entry stateEntry = (Map.Entry)state[0];
            this.maxDeque = (Deque)stateEntry.getValue();
            Map.Entry stateEntry2 = (Map.Entry)state[1];
            this.maxValue = (Double)stateEntry2.getValue();
        }
    }
}

