/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.AbstractMap;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;

public class CronWindowProcessor
extends WindowProcessor
implements Job {
    private ComplexEventChunk<StreamEvent> currentEventChunk = new ComplexEventChunk(false);
    private ComplexEventChunk<StreamEvent> expiredEventChunk = new ComplexEventChunk(false);
    private ExecutionPlanContext executionPlanContext;
    private Scheduler scheduler;
    private String jobName;
    private final String jobGroup = "CronWindowGroup";
    private String cronString;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        if (attributeExpressionExecutors != null) {
            this.cronString = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        CronWindowProcessor cronWindowProcessor = this;
        synchronized (cronWindowProcessor) {
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                this.currentEventChunk.add(clonedStreamEvent);
                streamEventChunk.remove();
            }
        }
    }

    @Override
    public void start() {
        this.scheduleCronJob(this.cronString, this.elementId);
    }

    @Override
    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.deleteJob(new JobKey(this.jobName, "CronWindowGroup"));
            }
        }
        catch (SchedulerException e) {
            log.error((Object)("Error while removing the cron job : " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public Object[] currentState() {
        return new Object[]{new AbstractMap.SimpleEntry<String, StreamEvent>("CurrentEventChunk", this.currentEventChunk.getFirst()), new AbstractMap.SimpleEntry<String, StreamEvent>("ExpiredEventChunk", this.expiredEventChunk.getFirst())};
    }

    @Override
    public void restoreState(Object[] state) {
        this.currentEventChunk.clear();
        Map.Entry stateEntry = (Map.Entry)state[0];
        this.currentEventChunk.add((StreamEvent)stateEntry.getValue());
        this.expiredEventChunk.clear();
        Map.Entry stateEntry2 = (Map.Entry)state[1];
        this.expiredEventChunk.add((StreamEvent)stateEntry2.getValue());
    }

    private void scheduleCronJob(String cronString, String elementId) {
        try {
            StdSchedulerFactory schedFact = new StdSchedulerFactory();
            this.scheduler = schedFact.getScheduler();
            this.jobName = "EventRemoverJob_" + elementId;
            JobKey jobKey = new JobKey(this.jobName, "CronWindowGroup");
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
            this.scheduler.start();
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("windowProcessor", (Object)this);
            JobDetail job = JobBuilder.newJob(CronWindowProcessor.class).withIdentity(this.jobName, "CronWindowGroup").usingJobData(dataMap).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("EventRemoverTrigger_" + elementId, "CronWindowGroup").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            log.error((Object)"Error while instantiating quartz scheduler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvents() {
        ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>(false);
        CronWindowProcessor cronWindowProcessor = this;
        synchronized (cronWindowProcessor) {
            long currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
            while (this.expiredEventChunk.hasNext()) {
                StreamEvent expiredEvent = (StreamEvent)this.expiredEventChunk.next();
                expiredEvent.setTimestamp(currentTime);
            }
            if (this.expiredEventChunk.getFirst() != null) {
                streamEventChunk.add(this.expiredEventChunk.getFirst());
            }
            this.expiredEventChunk.clear();
            while (this.currentEventChunk.hasNext()) {
                StreamEvent currentEvent = (StreamEvent)this.currentEventChunk.next();
                StreamEvent toExpireEvent = this.streamEventCloner.copyStreamEvent(currentEvent);
                toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                this.expiredEventChunk.add(toExpireEvent);
            }
            streamEventChunk.add(this.currentEventChunk.getFirst());
            this.currentEventChunk.clear();
        }
        if (streamEventChunk.getFirst() != null) {
            this.nextProcessor.process(streamEventChunk);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Running Event Remover Job");
        }
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        CronWindowProcessor windowProcessor = (CronWindowProcessor)dataMap.get((Object)"windowProcessor");
        windowProcessor.dispatchEvents();
    }
}

